/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.SignatureMethodConfigType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SignatureMethodsConfigType
extends ConfigBeanNode {
    SignatureMethodConfigType[] _signatureMethods = null;

    public SignatureMethodsConfigType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public SignatureMethodsConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setSignatureMethods(SignatureMethodConfigType[] signatureMethods) throws ConfigurationException {
        SignatureMethodConfigType[] oldValue = this._signatureMethods;
        this._signatureMethods = signatureMethods;
        this.firePropertyChange("signatureMethods", oldValue, this._signatureMethods);
    }

    public SignatureMethodConfigType[] getSignatureMethods() {
        return this._signatureMethods;
    }

    public SignatureMethodConfigType[] defaultSignatureMethods() {
        return new SignatureMethodConfigType[0];
    }

    public void addSignatureMethods() throws ConfigurationException {
        if (this._signatureMethods != null) {
            return;
        }
        SignatureMethodConfigType[] signatureMethods = new SignatureMethodConfigType[]{new SignatureMethodConfigType(this)};
        this.setSignatureMethods(signatureMethods);
    }

    public void removeSignatureMethods() throws ConfigurationException {
        if (this._signatureMethods == null) {
            return;
        }
        this.setSignatureMethods(null);
    }

    public void addSignatureMethod(SignatureMethodConfigType signatureMethod) throws ConfigurationException {
        signatureMethod.setParent(this);
        int existingSignatureMethodsCnt = 0;
        if (this._signatureMethods != null) {
            existingSignatureMethodsCnt = this._signatureMethods.length;
        }
        SignatureMethodConfigType[] newSignatureMethods = new SignatureMethodConfigType[existingSignatureMethodsCnt + 1];
        for (int n = 0; n < existingSignatureMethodsCnt; ++n) {
            newSignatureMethods[n] = this._signatureMethods[n];
        }
        newSignatureMethods[existingSignatureMethodsCnt] = signatureMethod;
        SignatureMethodConfigType[] oldValue = this._signatureMethods;
        this._signatureMethods = newSignatureMethods;
        this.firePropertyChange("signatureMethods", oldValue, this._signatureMethods);
    }

    public void removeSignatureMethod(SignatureMethodConfigType signatureMethod) throws ConfigurationException {
        int existingSignatureMethodsCnt = 0;
        if (this._signatureMethods != null) {
            existingSignatureMethodsCnt = this._signatureMethods.length;
        }
        SignatureMethodConfigType[] newSignatureMethods = new SignatureMethodConfigType[existingSignatureMethodsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingSignatureMethodsCnt; ++n) {
            if (signatureMethod.equals(this._signatureMethods[n])) continue;
            newSignatureMethods[newIndex++] = this._signatureMethods[n];
        }
        if (newSignatureMethods.length == 0) {
            newSignatureMethods = null;
        }
        SignatureMethodConfigType[] oldValue = this._signatureMethods;
        this._signatureMethods = newSignatureMethods;
        this.firePropertyChange("signatureMethods", oldValue, this._signatureMethods);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "signature-methods");
        XMLUtils.writeTagAttributeEnd(out, indentation, "signature-methods");
        SignatureMethodsConfigType.writeXML(out, indentation + "\t", this._signatureMethods);
        XMLUtils.writeTagEnd(out, indentation, "signature-methods");
    }

    private void init() throws ConfigurationException {
        this.setXpath("signature-methods");
        Vector<SignatureMethodConfigType> signatureMethods = new Vector<SignatureMethodConfigType>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("signature-method")) continue;
                SignatureMethodConfigType configBean = new SignatureMethodConfigType(this, node);
                signatureMethods.add(configBean);
            }
        }
        if (signatureMethods.size() > 0) {
            this.setSignatureMethods(signatureMethods.toArray(new SignatureMethodConfigType[0]));
        }
    }
}

