/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SignElementsConfigType;
import oracle.oc4j.admin.deploy.spi.xml.TbsElementTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.TbsElementType;

public class SignElementsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private SignElementsConfigType _bean;
    private static final String ADD_TBS_ELEMENT_MENU_STRING = "Add Tbs Element";
    private static final String REMOVE_TBS_ELEMENTS_MENU_STRING = "Remove Tbs Elements";
    private JMenuItem _addTbsElementMenuItem;
    private JMenuItem _removeTbsElementsMenuItem;

    public SignElementsTreeNode(ConfigTreeNode rootNode, SignElementsConfigType tbsElements) {
        super(tbsElements);
        this.setRootNode(rootNode);
        this._bean = tbsElements;
        this._addTbsElementMenuItem = new JMenuItem(ADD_TBS_ELEMENT_MENU_STRING);
        this._addTbsElementMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addTbsElementMenuItem.setFont(SignElementsTreeNode.getFont());
        this._addTbsElementMenuItem.addActionListener(this);
        this._removeTbsElementsMenuItem = new JMenuItem(REMOVE_TBS_ELEMENTS_MENU_STRING);
        this._removeTbsElementsMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeTbsElementsMenuItem.setFont(SignElementsTreeNode.getFont());
        this._removeTbsElementsMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addTbsElementMenuItem);
        this._popup.add(this._removeTbsElementsMenuItem);
    }

    public String viewHeaderString() {
        return "Tbs Elements";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        TbsElementType[] tbsElements = this._bean.getTbsElements();
        if (tbsElements != null) {
            for (int i = 0; i < tbsElements.length; ++i) {
                TbsElementType tbsElement = tbsElements[i];
                if (tbsElement == null) continue;
                TbsElementTreeNode tbsElementTreeNode = new TbsElementTreeNode(this.getRootNode(), tbsElement);
                this.addChild(tbsElementTreeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_TBS_ELEMENT_MENU_STRING)) {
                TbsElementType newTbsElement = new TbsElementType(this._bean);
                if (this.showAddDialog(newTbsElement, ADD_TBS_ELEMENT_MENU_STRING)) {
                    this._bean.addTbsElement(newTbsElement);
                    TbsElementTreeNode newNode = new TbsElementTreeNode(this, newTbsElement);
                    this.insertNode(newNode);
                }
            } else if (event.getActionCommand().equals(REMOVE_TBS_ELEMENTS_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof TbsElementTreeNode) {
            TbsElementType tbsElement = (TbsElementType)node.getConfigBeanNode();
            this._bean.removeTbsElement(tbsElement);
            this.removeNode(node);
        }
    }
}

