/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.CallPropertiesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.PortInfosTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ServiceQnameTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ServiceQnameType;
import oracle.oc4j.admin.deploy.spi.xml.ServiceRefMappingConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.StubPropertiesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.TypeMappingsType;
import oracle.oc4j.admin.deploy.spi.xml.WSDTypeMappingsTreeNode;

public class ServiceRefMappingTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ServiceRefMappingConfigBean _bean;
    private static final String ADD_SERVICE_QNAME_MENU_STRING = "Add Service Qname";
    private static final String ADD_TYPE_MAPPINGS_MENU_STRING = "Add Type Mappings";
    private JMenuItem _addServiceQnameMenuItem;
    private JMenuItem _addTypeMappingsMenuItem;

    public ServiceRefMappingTreeNode(ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(this);
        this._bean = (ServiceRefMappingConfigBean)bean;
        this._addServiceQnameMenuItem = new JMenuItem(ADD_SERVICE_QNAME_MENU_STRING);
        this._addServiceQnameMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addServiceQnameMenuItem.setFont(ServiceRefMappingTreeNode.getFont());
        this._addServiceQnameMenuItem.addActionListener(this);
        if (this._bean.getServiceQname() != null) {
            this._addServiceQnameMenuItem.setEnabled(false);
        }
        this._addTypeMappingsMenuItem = new JMenuItem(ADD_TYPE_MAPPINGS_MENU_STRING);
        this._addTypeMappingsMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addTypeMappingsMenuItem.setFont(ServiceRefMappingTreeNode.getFont());
        this._addTypeMappingsMenuItem.addActionListener(this);
        if (this._bean.getTypeMappings() != null) {
            this._addTypeMappingsMenuItem.setEnabled(false);
        }
        this._popup = new JPopupMenu();
        this._popup.add(this._addServiceQnameMenuItem);
        this._popup.add(this._addTypeMappingsMenuItem);
    }

    public String viewHeaderString() {
        return "Service Reference Mapping";
    }

    public String toString() {
        return this._bean.getName();
    }

    protected void buildChildJTree() {
        Method xmlMethod;
        TypeMappingsType typeMappings;
        ServiceQnameType serviceQname = this._bean.getServiceQname();
        if (serviceQname != null) {
            ServiceQnameTreeNode serviceQnameTreeNode = new ServiceQnameTreeNode(this.getRootNode(), serviceQname);
            this.addChild(serviceQnameTreeNode);
        }
        if ((typeMappings = this._bean.getTypeMappings()) != null) {
            WSDTypeMappingsTreeNode WSDTypeMappingsTreeNode2 = new WSDTypeMappingsTreeNode(this, typeMappings);
            this.addChild(WSDTypeMappingsTreeNode2);
        }
        try {
            xmlMethod = ServiceRefMappingConfigBean.class.getMethod("writeStubPropertiesXML", PrintWriter.class, String.class);
            StubPropertiesTreeNode stubPropertiesTreeNode = new StubPropertiesTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(stubPropertiesTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        try {
            xmlMethod = ServiceRefMappingConfigBean.class.getMethod("writeCallPropertiesXML", PrintWriter.class, String.class);
            CallPropertiesTreeNode callPropertiesTreeNode = new CallPropertiesTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(callPropertiesTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
        try {
            xmlMethod = ServiceRefMappingConfigBean.class.getMethod("writePortInfosXML", PrintWriter.class, String.class);
            PortInfosTreeNode portInfosTreeNode = new PortInfosTreeNode(this.getRootNode(), new MultipleType(this._bean, xmlMethod));
            this.addChild(portInfosTreeNode);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public boolean showDefaults() {
        return true;
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_SERVICE_QNAME_MENU_STRING)) {
                ServiceQnameType newServiceQname = this._bean.defaultServiceQname();
                if (this.showAddDialog(newServiceQname, ADD_SERVICE_QNAME_MENU_STRING)) {
                    this._bean.setServiceQname(newServiceQname);
                    ServiceQnameTreeNode newNode = new ServiceQnameTreeNode(this, newServiceQname);
                    this.insertNode(newNode);
                    this._addServiceQnameMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_TYPE_MAPPINGS_MENU_STRING) && this._bean.getTypeMappings() == null) {
                this._bean.addTypeMappings();
                WSDTypeMappingsTreeNode newNode = new WSDTypeMappingsTreeNode(this, this._bean.getTypeMappings());
                this.insertNode(newNode);
                this._addTypeMappingsMenuItem.setEnabled(false);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ServiceQnameTreeNode) {
            this._bean.removeServiceQname();
            this.removeNode(node);
            this._addServiceQnameMenuItem.setEnabled(true);
        } else if (node instanceof WSDTypeMappingsTreeNode) {
            this._bean.removeTypeMappings();
            this.removeNode(node);
            this._addTypeMappingsMenuItem.setEnabled(true);
        }
    }
}

