/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.SerializerTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SerializerType;

public class SerializersTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_SERIALIZER_MENU_STRING = "Add Serializer";
    private JMenuItem _addSerializerMenuItem;
    private SerializerType[] serializersType = new SerializerType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public SerializersTreeNode(ConfigTreeNode rootNode, MultipleType serializers) {
        super(serializers);
        this.setRootNode(rootNode);
        this._parentBean = serializers.getConfigParent();
        this._addSerializerMenuItem = new JMenuItem(ADD_SERIALIZER_MENU_STRING);
        this._addSerializerMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSerializerMenuItem.setFont(SerializersTreeNode.getFont());
        this._addSerializerMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addSerializerMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getSerializers", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addSerializer", SerializerType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeSerializer", SerializerType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Serializers";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            SerializerType[] serializers = (SerializerType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (serializers != null) {
                for (int i = 0; i < serializers.length; ++i) {
                    SerializerType serializer = serializers[i];
                    if (serializer == null) continue;
                    SerializerTreeNode serializerTreeNode = new SerializerTreeNode(this.getRootNode(), serializer);
                    this.addChild(serializerTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            SerializerType newSerializer;
            if (event.getActionCommand().equals(ADD_SERIALIZER_MENU_STRING) && this.showAddDialog(newSerializer = new SerializerType(this._parentBean), ADD_SERIALIZER_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newSerializer);
                SerializerTreeNode newNode = new SerializerTreeNode(this, newSerializer);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof SerializerTreeNode) {
            try {
                SerializerType serializer = (SerializerType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, serializer);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

