/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.InitParamType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SerializerType
extends ConfigBeanNode {
    String _className = null;
    InitParamType[] _initParams = null;

    public SerializerType(ConfigBeanNode parent) {
        this(parent, null);
    }

    public SerializerType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void setClassName(String className) {
        String oldValue = this._className;
        this._className = className;
        this.firePropertyChange("className", oldValue, this._className);
    }

    public String getClassName() {
        return this._className;
    }

    public String defaultClassName() {
        return "";
    }

    public void setInitParams(InitParamType[] initParams) {
        this._initParams = initParams;
    }

    public InitParamType[] getInitParams() {
        return this._initParams;
    }

    public InitParamType[] defaultInitParams() {
        return new InitParamType[0];
    }

    public void addInitParams() throws ConfigurationException {
        if (this._initParams != null) {
            return;
        }
        InitParamType[] initParams = new InitParamType[]{new InitParamType(this, null)};
        this.setInitParams(initParams);
    }

    public void removeInitParams() {
        if (this._initParams == null) {
            return;
        }
        this.setInitParams(null);
    }

    public void addInitParam(InitParamType initParam) {
        initParam.setParent(this);
        int existingInitParamsCnt = 0;
        if (this._initParams != null) {
            existingInitParamsCnt = this._initParams.length;
        }
        InitParamType[] newInitParams = new InitParamType[existingInitParamsCnt + 1];
        for (int n = 0; n < existingInitParamsCnt; ++n) {
            newInitParams[n] = this._initParams[n];
        }
        newInitParams[existingInitParamsCnt] = initParam;
        InitParamType[] oldValue = this._initParams;
        this._initParams = newInitParams;
        this.firePropertyChange("initParams", oldValue, this._initParams);
    }

    public void removeInitParam(InitParamType initParam) {
        int existingInitParamsCnt = 0;
        if (this._initParams != null) {
            existingInitParamsCnt = this._initParams.length;
        }
        InitParamType[] newInitParams = new InitParamType[existingInitParamsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingInitParamsCnt; ++n) {
            if (initParam.equals(this._initParams[n])) continue;
            newInitParams[newIndex++] = this._initParams[n];
        }
        if (newInitParams.length == 0) {
            newInitParams = null;
        }
        InitParamType[] oldValue = this._initParams;
        this._initParams = newInitParams;
        this.firePropertyChange("initParams", oldValue, this._initParams);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "serializer");
        XMLUtils.writeAttribute(out, indentation, "class", this._className);
        XMLUtils.writeTagAttributeEnd(out, indentation, "serializer");
        this.writeInitParamsXML(out, indentation + "\t");
        XMLUtils.writeTagEnd(out, indentation, "serializer");
    }

    public static void writeXML(PrintWriter out, String indentation, SerializerType[] serializers) throws ExtendedRuntimeException {
        if (serializers == null) {
            return;
        }
        for (int n = 0; n < serializers.length; ++n) {
            serializers[n].writeXML(out, indentation);
        }
    }

    public void writeInitParamsXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        if (this._initParams != null) {
            SerializerType.writeXML(out, indentation + "\t", this._initParams);
        }
    }

    private void init() {
        this.setXpath("serializer");
        Vector<InitParamType> initParams = new Vector<InitParamType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "class");
            if (val != null && !val.trim().equals("")) {
                this._className = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("init-param")) continue;
                InitParamType configBean = new InitParamType(this, node);
                initParams.add(configBean);
            }
        }
        if (initParams.size() > 0) {
            this._initParams = initParams.toArray(new InitParamType[0]);
        }
    }
}

