/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.InboundConfigType;
import oracle.oc4j.admin.deploy.spi.xml.InboundTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.OutboundConfigType;
import oracle.oc4j.admin.deploy.spi.xml.OutboundTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SecurityOperationConfigType;

public class SecurityOperationTreeNode
extends ConfigTreeNode
implements ActionListener {
    private SecurityOperationConfigType _bean;
    private static final String ADD_INBOUND_MENU_STRING = "Add Inbound";
    private static final String ADD_OUTBOUND_MENU_STRING = "Add Outbound";
    private static final String REMOVE_SECURITY_MENU_STRING = "Remove Security";
    private JMenuItem _addInboundMenuItem;
    private JMenuItem _addOutboundMenuItem;
    private JMenuItem _removeSecurityMenuItem;

    public SecurityOperationTreeNode(ConfigTreeNode rootNode, ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = (SecurityOperationConfigType)bean;
        this._addInboundMenuItem = new JMenuItem(ADD_INBOUND_MENU_STRING);
        this._addInboundMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addInboundMenuItem.setFont(SecurityOperationTreeNode.getFont());
        this._addInboundMenuItem.addActionListener(this);
        if (this._bean.getInbound() != null) {
            this._addInboundMenuItem.setEnabled(false);
        }
        this._addOutboundMenuItem = new JMenuItem(ADD_OUTBOUND_MENU_STRING);
        this._addOutboundMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addOutboundMenuItem.setFont(SecurityOperationTreeNode.getFont());
        this._addOutboundMenuItem.addActionListener(this);
        if (this._bean.getOutbound() != null) {
            this._addOutboundMenuItem.setEnabled(false);
        }
        this._removeSecurityMenuItem = new JMenuItem(REMOVE_SECURITY_MENU_STRING);
        this._removeSecurityMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeSecurityMenuItem.setFont(SecurityOperationTreeNode.getFont());
        this._removeSecurityMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addInboundMenuItem);
        this._popup.add(this._addOutboundMenuItem);
        this._popup.add(this._removeSecurityMenuItem);
    }

    public String viewHeaderString() {
        return "Security";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        OutboundConfigType outbound;
        InboundConfigType inbound = this._bean.getInbound();
        if (inbound != null) {
            InboundTreeNode inboundTreeNode = new InboundTreeNode(this.getRootNode(), inbound);
            this.addChild(inboundTreeNode);
        }
        if ((outbound = this._bean.getOutbound()) != null) {
            OutboundTreeNode outboundTreeNode = new OutboundTreeNode(this.getRootNode(), outbound);
            this.addChild(outboundTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_INBOUND_MENU_STRING)) {
                if (this._bean.getInbound() == null) {
                    this._bean.addInbound();
                    InboundTreeNode newNode = new InboundTreeNode(this, this._bean.getInbound());
                    this.insertNode(newNode);
                    this._addInboundMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_OUTBOUND_MENU_STRING)) {
                if (this._bean.getOutbound() == null) {
                    this._bean.addOutbound();
                    OutboundTreeNode newNode = new OutboundTreeNode(this, this._bean.getOutbound());
                    this.insertNode(newNode);
                    this._addOutboundMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_SECURITY_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof InboundTreeNode) {
            this._bean.removeInbound();
            this.removeNode(node);
            this._addInboundMenuItem.setEnabled(true);
        } else if (node instanceof OutboundTreeNode) {
            this._bean.removeOutbound();
            this.removeNode(node);
            this._addOutboundMenuItem.setEnabled(true);
        }
    }
}

