/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.SamlAuthorityConfigType;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import oracle.oc4j.admin.deploy.spi.xml.SubjectConfirmationMethodConfigType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SamlTokenConfigType
extends ConfigBeanNode {
    SubjectConfirmationMethodConfigType _subjectConfirmationMethod = null;
    PropertyConfigBean[] _properties = null;
    String _name = null;
    String _cbhandlerName = null;
    String _issuerName = null;
    String _attribute = null;
    StringType _nameFormat = null;
    StringType _oldNameFormat = null;
    SamlAuthorityConfigType _samlAuthority = null;

    public SamlTokenConfigType(ConfigBeanNode parent) throws ConfigurationException {
        this(parent, null);
    }

    public SamlTokenConfigType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public void setSubjectConfirmationMethod(SubjectConfirmationMethodConfigType subjectConfirmationMethod) throws ConfigurationException {
        SubjectConfirmationMethodConfigType oldValue = this._subjectConfirmationMethod;
        this._subjectConfirmationMethod = subjectConfirmationMethod;
        this.firePropertyChange("subjectConfirmationMethod", oldValue, this._subjectConfirmationMethod);
    }

    public SubjectConfirmationMethodConfigType getSubjectConfirmationMethod() {
        return this._subjectConfirmationMethod;
    }

    public SubjectConfirmationMethodConfigType defaultSubjectConfirmationMethod() throws ConfigurationException {
        try {
            return new SubjectConfirmationMethodConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addSubjectConfirmationMethod() throws ConfigurationException {
        if (this._subjectConfirmationMethod != null) {
            return;
        }
        SubjectConfirmationMethodConfigType subjectConfirmationMethod = new SubjectConfirmationMethodConfigType(this, null);
        this.setSubjectConfirmationMethod(subjectConfirmationMethod);
    }

    public void removeSubjectConfirmationMethod() throws ConfigurationException {
        if (this._subjectConfirmationMethod == null) {
            return;
        }
        this.setSubjectConfirmationMethod(null);
    }

    public void setProperties(PropertyConfigBean[] properties) throws ConfigurationException {
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = properties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        return new PropertyConfigBean[0];
    }

    public void addProperties() throws ConfigurationException {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() throws ConfigurationException {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) throws ConfigurationException {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) throws ConfigurationException {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void setName(String name) {
        String oldValue = this._name;
        this._name = name;
        this.firePropertyChange("name", oldValue, this._name);
    }

    public String getName() {
        return this._name;
    }

    public String defaultName() {
        return "";
    }

    public void setCbhandlerName(String cbhandlerName) {
        String oldValue = this._cbhandlerName;
        this._cbhandlerName = cbhandlerName;
        this.firePropertyChange("cbhandlerName", oldValue, this._cbhandlerName);
    }

    public String getCbhandlerName() {
        return this._cbhandlerName;
    }

    public String defaultCbhandlerName() {
        return "";
    }

    public void setIssuerName(String issuerName) {
        String oldValue = this._issuerName;
        this._issuerName = issuerName;
        this.firePropertyChange("issuerName", oldValue, this._issuerName);
    }

    public String getIssuerName() {
        return this._issuerName;
    }

    public String defaultIssuerName() {
        return "";
    }

    public void setAttribute(String attribute) {
        String oldValue = this._attribute;
        this._attribute = attribute;
        this.firePropertyChange("attribute", oldValue, this._attribute);
    }

    public String getAttribute() {
        return this._attribute;
    }

    public String defaultAttribute() {
        return "";
    }

    public void setNameFormat(StringType nameFormat) throws ConfigurationException {
        this._nameFormat = nameFormat;
        this.firePropertyChange("nameFormat", this._oldNameFormat, this._nameFormat);
        if (this._nameFormat != null) {
            if (this._oldNameFormat == null) {
                this._oldNameFormat = this.defaultNameFormat();
            }
            this._oldNameFormat.setValue(this._nameFormat.getValue());
        } else {
            this._oldNameFormat = null;
        }
    }

    public StringType getNameFormat() {
        return this._nameFormat;
    }

    public StringType defaultNameFormat() {
        String[] tags = new String[]{"UNSPECIFIED", "EMAIL", "X509-SUBJECT-NAME", "WINDOWS-DOMAIN-NAME"};
        return new StringType(this, tags, "UNSPECIFIED");
    }

    public void setSamlAuthority(SamlAuthorityConfigType samlAuthority) throws ConfigurationException {
        SamlAuthorityConfigType oldValue = this._samlAuthority;
        this._samlAuthority = samlAuthority;
        this.firePropertyChange("samlAuthority", oldValue, this._samlAuthority);
    }

    public SamlAuthorityConfigType getSamlAuthority() {
        return this._samlAuthority;
    }

    public SamlAuthorityConfigType defaultSamlAuthority() throws ConfigurationException {
        try {
            return new SamlAuthorityConfigType(this, null);
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addSamlAuthority() throws ConfigurationException {
        if (this._samlAuthority != null) {
            return;
        }
        SamlAuthorityConfigType samlAuthority = new SamlAuthorityConfigType(this, null);
        this.setSamlAuthority(samlAuthority);
    }

    public void removeSamlAuthority() throws ConfigurationException {
        if (this._samlAuthority == null) {
            return;
        }
        this.setSamlAuthority(null);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "saml-token");
        XMLUtils.writeAttribute(out, indentation, "name-format", this._nameFormat);
        if (this._name != null && this._name.length() > 0) {
            XMLUtils.writeAttribute(out, indentation, "name", this._name);
        }
        if (this._cbhandlerName != null && this._cbhandlerName.length() > 0) {
            XMLUtils.writeAttribute(out, indentation, "cbhandler-name", this._cbhandlerName);
        }
        if (this._issuerName != null && this._issuerName.length() > 0) {
            XMLUtils.writeAttribute(out, indentation, "issuer-name", this._issuerName);
        }
        XMLUtils.writeTagAttributeEnd(out, indentation, "saml-token");
        if (this._subjectConfirmationMethod != null) {
            this._subjectConfirmationMethod.writeXML(out, indentation + "\t");
        }
        if (this._attribute != null && this._attribute.length() > 0) {
            XMLUtils.writeTagAttributeStart(out, indentation + "\t", "attribute");
            XMLUtils.writeAttribute(out, indentation + "\t", "path", this._attribute);
            XMLUtils.writeTagAttributeEnd(out, indentation + "\t", "attribute");
            XMLUtils.writeTagEnd(out, indentation + "\t", "attribute");
        }
        SamlTokenConfigType.writeXML(out, indentation + "\t", this._properties);
        if (this._samlAuthority != null) {
            this._samlAuthority.writeXML(out, indentation + "\t");
        }
        XMLUtils.writeTagEnd(out, indentation, "saml-token");
    }

    private void init() throws ConfigurationException {
        this.setXpath("saml-token");
        Vector<PropertyConfigBean> properties = new Vector<PropertyConfigBean>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "name-format");
            if (val != null && !val.trim().equals("")) {
                StringType nameFormat = this.defaultNameFormat();
                nameFormat.setValue(val);
                this.setNameFormat(nameFormat);
            }
            if ((val = XMLUtils.getAttribute(node, "name")) != null && !val.trim().equals("")) {
                this._name = val;
            }
            if ((val = XMLUtils.getAttribute(node, "cbhandler-name")) != null && !val.trim().equals("")) {
                this._cbhandlerName = val;
            }
            if ((val = XMLUtils.getAttribute(node, "issuer-name")) != null && !val.trim().equals("")) {
                this._issuerName = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("subject-confirmation-method")) {
                    SubjectConfirmationMethodConfigType subjectConfirmationMethod = new SubjectConfirmationMethodConfigType(this, node);
                    this.setSubjectConfirmationMethod(subjectConfirmationMethod);
                    continue;
                }
                if (name.equals("property")) {
                    PropertyConfigBean configBean = new PropertyConfigBean(this, node);
                    properties.add(configBean);
                    continue;
                }
                if (name.equals("attribute")) {
                    val = XMLUtils.getAttribute(node, "path");
                    if (val == null || val.trim().equals("")) continue;
                    this._attribute = val;
                    continue;
                }
                if (!name.equals("saml-authority")) continue;
                SamlAuthorityConfigType samlAuthority = new SamlAuthorityConfigType(this, node);
                this.setSamlAuthority(samlAuthority);
            }
        }
        if (properties.size() > 0) {
            this.setProperties(properties.toArray(new PropertyConfigBean[0]));
        }
    }
}

