/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceRefType
extends ConfigBeanNode {
    String description;
    String resRefName;
    String resType;
    String resAuth;
    String resSharingScope;

    public ResourceRefType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("resource-ref");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (nodeName.equals("res-ref-name")) {
                    this.resRefName = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("description")) {
                    this.description = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("res-type")) {
                    this.resType = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (nodeName.equals("res-auth")) {
                    this.resAuth = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!nodeName.equals("res-sharing-scope")) continue;
                this.resSharingScope = XMLUtils.getValue(childNodes.item(i));
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "resource-ref");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "description", this.description);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "res-ref-name", this.resRefName);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "res-type", this.resType);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "res-auth", this.resAuth);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "res-sharing-scope", this.resSharingScope);
        XMLUtils.writeTagEnd(out, indentation, "resource-ref");
    }

    public String getDescription() {
        return this.description;
    }

    public String getResAuth() {
        return this.resAuth;
    }

    public String getResRefName() {
        return this.resRefName;
    }

    public String getResSharingScope() {
        return this.resSharingScope;
    }

    public String getResType() {
        return this.resType;
    }
}

