/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;
import oracle.oc4j.admin.deploy.spi.xml.ProviderPortTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ProviderPortType;

public class ProviderPortsTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_PROVIDER_PORT_MENU_STRING = "Add Provider Port";
    private JMenuItem _addProviderPortMenuItem;
    private ProviderPortType[] providerPortsType = new ProviderPortType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public ProviderPortsTreeNode(ConfigTreeNode rootNode, MultipleType providerPorts) {
        super(providerPorts);
        this.setRootNode(rootNode);
        this._parentBean = providerPorts.getConfigParent();
        this._addProviderPortMenuItem = new JMenuItem(ADD_PROVIDER_PORT_MENU_STRING);
        this._addProviderPortMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addProviderPortMenuItem.setFont(ProviderPortsTreeNode.getFont());
        this._addProviderPortMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addProviderPortMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getProviderPorts", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addProviderPort", ProviderPortType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeProviderPort", ProviderPortType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Provider Ports";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            ProviderPortType[] providerPorts = (ProviderPortType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (providerPorts != null) {
                for (int i = 0; i < providerPorts.length; ++i) {
                    ProviderPortType providerPort = providerPorts[i];
                    if (providerPort == null) continue;
                    ProviderPortTreeNode providerPortTreeNode = new ProviderPortTreeNode(this.getRootNode(), providerPort);
                    this.addChild(providerPortTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            ProviderPortType newProviderPort;
            if (event.getActionCommand().equals(ADD_PROVIDER_PORT_MENU_STRING) && this.showAddDialog(newProviderPort = new ProviderPortType(this._parentBean, null), ADD_PROVIDER_PORT_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newProviderPort);
                ProviderPortTreeNode newNode = new ProviderPortTreeNode(this, newProviderPort);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof ProviderPortTreeNode) {
            try {
                ProviderPortType providerPort = (ProviderPortType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, providerPort);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

