/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MimeMappingType
extends ConfigBeanNode {
    String extension;
    String mimeType;

    public MimeMappingType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("mime-mapping");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String nodeName = childNodes.item(i).getNodeName();
                if (nodeName.equals("extension")) {
                    this.extension = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!nodeName.equals("mime-type")) continue;
                this.mimeType = XMLUtils.getValue(childNodes.item(i));
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "mime-mapping");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "extension", this.extension);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "mime-type", this.mimeType);
        XMLUtils.writeTagEnd(out, indentation, "mime-mapping");
    }

    public String getExtension() {
        return this.extension;
    }

    public String getMimeType() {
        return this.mimeType;
    }
}

