/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MailSessionType
extends ConfigBeanNode {
    String _description = null;
    String _location = null;
    String _smtpHost = null;
    String _username = null;
    String _password = null;
    PropertyConfigBean[] _properties = null;

    public MailSessionType(ConfigBeanNode parent) {
        this(parent, null);
    }

    public MailSessionType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void setDescription(String description) {
        String oldValue = this._description;
        this._description = description;
        this.firePropertyChange("description", oldValue, this._description);
    }

    public String getDescription() {
        return this._description;
    }

    public String defaultDescription() {
        return "";
    }

    public void setLocation(String location) {
        String oldValue = this._location;
        this._location = location;
        this.firePropertyChange("location", oldValue, this._location);
    }

    public String getLocation() {
        return this._location;
    }

    public String defaultLocation() {
        return "";
    }

    public void setSmtpHost(String smtpHost) {
        String oldValue = this._smtpHost;
        this._smtpHost = smtpHost;
        this.firePropertyChange("smtpHost", oldValue, this._smtpHost);
    }

    public String getSmtpHost() {
        return this._smtpHost;
    }

    public String defaultSmtpHost() {
        return "";
    }

    public void setUsername(String username) {
        String oldValue = this._username;
        this._username = username;
        this.firePropertyChange("username", oldValue, this._username);
    }

    public String getUsername() {
        return this._username;
    }

    public String defaultUsername() {
        return "";
    }

    public void setPassword(String password) {
        String oldValue = this._password;
        this._password = password;
        this.firePropertyChange("password", oldValue, this._password);
    }

    public String getPassword() {
        return this._password;
    }

    public String defaultPassword() {
        return "";
    }

    public void setProperties(PropertyConfigBean[] properties) {
        this._properties = properties;
    }

    public PropertyConfigBean[] getProperties() {
        return this._properties;
    }

    public PropertyConfigBean[] defaultProperties() {
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        return properties;
    }

    public void addProperties() {
        if (this._properties != null) {
            return;
        }
        PropertyConfigBean[] properties = new PropertyConfigBean[]{new PropertyConfigBean(this, null)};
        this.setProperties(properties);
    }

    public void removeProperties() {
        if (this._properties == null) {
            return;
        }
        this.setProperties(null);
    }

    public void addProperty(PropertyConfigBean property) {
        property.setParent(this);
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt + 1];
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            newProperties[n] = this._properties[n];
        }
        newProperties[existingPropertiesCnt] = property;
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public void removeProperty(PropertyConfigBean property) {
        int existingPropertiesCnt = 0;
        if (this._properties != null) {
            existingPropertiesCnt = this._properties.length;
        }
        PropertyConfigBean[] newProperties = new PropertyConfigBean[existingPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingPropertiesCnt; ++n) {
            if (property.equals(this._properties[n])) continue;
            newProperties[newIndex++] = this._properties[n];
        }
        if (newProperties.length == 0) {
            newProperties = null;
        }
        PropertyConfigBean[] oldValue = this._properties;
        this._properties = newProperties;
        this.firePropertyChange("properties", oldValue, this._properties);
    }

    public boolean validatePropertyValue(String name, Object value) {
        return !name.equals("location") || value != null && value instanceof String && ((String)value).length() != 0;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "mail-session");
        XMLUtils.writeAttribute(out, indentation, "location", this._location);
        XMLUtils.writeAttribute(out, indentation, "smtp-host", this._smtpHost);
        XMLUtils.writeAttribute(out, indentation, "username", this._username);
        XMLUtils.writeAttribute(out, indentation, "password", this._password);
        XMLUtils.writeTagAttributeEnd(out, indentation, "mail-session");
        if (this._description != null && this._description.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "description", this._description);
        }
        MailSessionType.writeXML(out, indentation + "\t", this._properties);
        XMLUtils.writeTagEnd(out, indentation, "mail-session");
    }

    public static void writeXML(PrintWriter out, String indentation, MailSessionType[] mailSessions) throws ExtendedRuntimeException {
        if (mailSessions == null) {
            return;
        }
        for (int n = 0; n < mailSessions.length; ++n) {
            mailSessions[n].writeXML(out, indentation);
        }
    }

    private void init() {
        this.setXpath("mail-session");
        Vector<PropertyConfigBean> properties = new Vector<PropertyConfigBean>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "location");
            if (val != null && !val.trim().equals("")) {
                this._location = val;
            }
            if ((val = XMLUtils.getAttribute(node, "smtp-host")) != null && !val.trim().equals("")) {
                this._smtpHost = val;
            }
            if ((val = XMLUtils.getAttribute(node, "username")) != null && !val.trim().equals("")) {
                this._username = val;
            }
            if ((val = XMLUtils.getAttribute(node, "password")) != null && !val.trim().equals("")) {
                this._password = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("description")) {
                    this._description = XMLUtils.getValue(node);
                    continue;
                }
                if (!name.equals("property")) continue;
                PropertyConfigBean configBean = new PropertyConfigBean(this, node);
                properties.add(configBean);
            }
        }
        if (properties.size() > 0) {
            this._properties = properties.toArray(new PropertyConfigBean[0]);
        }
    }
}

