/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LoginModuleTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LoginModuleType;
import oracle.oc4j.admin.deploy.spi.xml.MultipleType;

public class LoginModulesTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ConfigBeanNode _parentBean;
    private static final String ADD_LOGIN_MODULE_MENU_STRING = "Add Login Module";
    private JMenuItem _addLoginModuleMenuItem;
    private LoginModuleType[] loginModulesType = new LoginModuleType[0];
    private Method _readMethod = null;
    private Method _addMethod = null;
    private Method _removeMethod = null;

    public LoginModulesTreeNode(ConfigTreeNode rootNode, MultipleType loginModules) {
        super(loginModules);
        this.setRootNode(rootNode);
        this._parentBean = loginModules.getConfigParent();
        this._addLoginModuleMenuItem = new JMenuItem(ADD_LOGIN_MODULE_MENU_STRING);
        this._addLoginModuleMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addLoginModuleMenuItem.setFont(LoginModulesTreeNode.getFont());
        this._addLoginModuleMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addLoginModuleMenuItem);
        Class<?> beanClass = this._parentBean.getClass();
        try {
            this._readMethod = beanClass.getMethod("getLoginModules", null);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._addMethod = beanClass.getMethod("addLoginModule", LoginModuleType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
        try {
            this._removeMethod = beanClass.getMethod("removeLoginModule", LoginModuleType.class);
        }
        catch (NoSuchMethodException ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public String viewHeaderString() {
        return "Login Modules";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        try {
            LoginModuleType[] loginModules = (LoginModuleType[])this._readMethod.invoke((Object)this._parentBean, null);
            if (loginModules != null) {
                for (int i = 0; i < loginModules.length; ++i) {
                    LoginModuleType loginModule = loginModules[i];
                    if (loginModule == null) continue;
                    LoginModuleTreeNode loginModuleTreeNode = new LoginModuleTreeNode(this.getRootNode(), loginModule);
                    this.addChild(loginModuleTreeNode);
                }
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            LoginModuleType newLoginModule;
            if (event.getActionCommand().equals(ADD_LOGIN_MODULE_MENU_STRING) && this.showAddDialog(newLoginModule = new LoginModuleType(this._parentBean, null), ADD_LOGIN_MODULE_MENU_STRING)) {
                this._addMethod.invoke((Object)this._parentBean, newLoginModule);
                LoginModuleTreeNode newNode = new LoginModuleTreeNode(this, newLoginModule);
                this.insertNode(newNode);
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof LoginModuleTreeNode) {
            try {
                LoginModuleType loginModule = (LoginModuleType)node.getConfigBeanNode();
                this._removeMethod.invoke((Object)this._parentBean, loginModule);
                this.removeNode(node);
            }
            catch (Throwable t) {
                throw new ExtendedConfigurationException(t);
            }
        }
    }
}

