/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.OptionType;
import oracle.oc4j.admin.deploy.spi.xml.StringType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoginModuleType
extends ConfigBeanNode {
    String _key = null;
    String _className = null;
    StringType _controlFlag = null;
    StringType _oldControlFlag = null;
    OptionType[] _options = null;

    public LoginModuleType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(null, parent, node);
        this.init();
    }

    public String getKey() {
        return this._key;
    }

    public String defaultKey() {
        return "class control-flag";
    }

    public void setClassName(String className) throws ConfigurationException {
        String oldValue = this._className;
        this._className = className;
        this.firePropertyChange("className", oldValue, this._className);
    }

    public String getClassName() {
        return this._className;
    }

    public String defaultClassName() {
        return "";
    }

    public void setControlFlag(StringType controlFlag) throws ConfigurationException {
        this._controlFlag = controlFlag;
        this.firePropertyChange("controlFlag", this._oldControlFlag, this._controlFlag);
        if (this._controlFlag != null) {
            if (this._oldControlFlag == null) {
                this._oldControlFlag = this.defaultControlFlag();
            }
            this._oldControlFlag.setValue(this._controlFlag.getValue());
        } else {
            this._oldControlFlag = null;
        }
    }

    public StringType getControlFlag() {
        return this._controlFlag;
    }

    public StringType defaultControlFlag() {
        String[] tags = new String[]{"required", "requisite", "optional", "sufficient", ""};
        return new StringType(this, tags, "");
    }

    public void setOptions(OptionType[] options) throws ConfigurationException {
        OptionType[] oldValue = this._options;
        this._options = options;
        this.firePropertyChange("options", oldValue, this._options);
    }

    public OptionType[] getOptions() {
        return this._options;
    }

    public OptionType[] defaultOptions() {
        return new OptionType[0];
    }

    public void addOptions() throws ConfigurationException {
        if (this._options != null) {
            return;
        }
        OptionType[] options = new OptionType[]{new OptionType(this, null)};
        this.setOptions(options);
    }

    public void removeOptions() throws ConfigurationException {
        if (this._options == null) {
            return;
        }
        this.setOptions(null);
    }

    public void addOption(OptionType option) throws ConfigurationException {
        option.setParent(this);
        int existingOptionsCnt = 0;
        if (this._options != null) {
            existingOptionsCnt = this._options.length;
        }
        OptionType[] newOptions = new OptionType[existingOptionsCnt + 1];
        for (int n = 0; n < existingOptionsCnt; ++n) {
            newOptions[n] = this._options[n];
        }
        newOptions[existingOptionsCnt] = option;
        OptionType[] oldValue = this._options;
        this._options = newOptions;
        this.firePropertyChange("options", oldValue, this._options);
    }

    public void removeOption(OptionType option) throws ConfigurationException {
        int existingOptionsCnt = 0;
        if (this._options != null) {
            existingOptionsCnt = this._options.length;
        }
        OptionType[] newOptions = new OptionType[existingOptionsCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingOptionsCnt; ++n) {
            if (option.equals(this._options[n])) continue;
            newOptions[newIndex++] = this._options[n];
        }
        if (newOptions.length == 0) {
            newOptions = null;
        }
        OptionType[] oldValue = this._options;
        this._options = newOptions;
        this.firePropertyChange("options", oldValue, this._options);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "login-module");
        XMLUtils.writeAttribute(out, indentation + "\t", "Key", this._key);
        XMLUtils.writeTagAttributeEnd(out, indentation, "login-module");
        if (this._className != null && this._className.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "class", this._className);
        }
        if (this._controlFlag != null && this._controlFlag.getValue() != null && this._controlFlag.getValue().length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "control-flag", this._controlFlag);
        }
        this.writeOptionsXML(out, indentation + "\t");
        XMLUtils.writeTagEnd(out, indentation, "login-module");
    }

    public static void writeXML(PrintWriter out, String indentation, LoginModuleType[] modules) throws ExtendedRuntimeException {
        if (modules == null) {
            return;
        }
        XMLUtils.writeTagAttributeStart(out, indentation, "login-modules");
        XMLUtils.writeTagAttributeEnd(out, indentation, "login-modules");
        for (int n = 0; n < modules.length; ++n) {
            modules[n].writeXML(out, indentation + "\t");
        }
        XMLUtils.writeTagEnd(out, indentation, "login-modules");
    }

    public void writeOptionsXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        OptionType.writeXML(out, indentation, this._options);
    }

    private void init() throws ConfigurationException {
        this.setXpath("application/login-modules/login-module");
        Vector<OptionType> options = new Vector<OptionType>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("class")) {
                    this._className = XMLUtils.getValue(node);
                    continue;
                }
                if (name.equals("control-flag")) {
                    StringType controlFlag = this.defaultControlFlag();
                    controlFlag.setValue(XMLUtils.getValue(node));
                    this.setControlFlag(controlFlag);
                    continue;
                }
                if (!name.equals("options")) continue;
                NodeList optionNodes = node.getChildNodes();
                for (int n = 0; n < optionNodes.getLength(); ++n) {
                    node = optionNodes.item(n);
                    name = node.getNodeName();
                    if (!name.equals("option")) continue;
                    OptionType configBean = new OptionType(this, node);
                    options.add(configBean);
                }
            }
        }
        this._key = this.defaultKey();
        if (options.size() > 0) {
            this.setOptions(options.toArray(new OptionType[0]));
        }
    }
}

