/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LoggingNamespacesTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.LoggingNamespacesType;
import oracle.oc4j.admin.deploy.spi.xml.LoggingPortType;

public class LoggingPortTreeNode
extends ConfigTreeNode
implements ActionListener {
    private LoggingPortType _bean;
    private static final String ADD_NAMESPACES_MENU_STRING = "Add Namespaces";
    private static final String REMOVE_LOGGING_MENU_STRING = "Remove Logging";
    private JMenuItem _addNamespacesMenuItem;
    private JMenuItem _removeLoggingMenuItem;

    public LoggingPortTreeNode(ConfigTreeNode rootNode, ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = (LoggingPortType)bean;
        this._addNamespacesMenuItem = new JMenuItem(ADD_NAMESPACES_MENU_STRING);
        this._addNamespacesMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addNamespacesMenuItem.setFont(LoggingPortTreeNode.getFont());
        this._addNamespacesMenuItem.addActionListener(this);
        if (this._bean.getNamespaces() != null) {
            this._addNamespacesMenuItem.setEnabled(false);
        }
        this._removeLoggingMenuItem = new JMenuItem(REMOVE_LOGGING_MENU_STRING);
        this._removeLoggingMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeLoggingMenuItem.setFont(LoggingPortTreeNode.getFont());
        this._removeLoggingMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addNamespacesMenuItem);
        this._popup.add(this._removeLoggingMenuItem);
    }

    public String viewHeaderString() {
        return "Logging";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        LoggingNamespacesType namespaces = this._bean.getNamespaces();
        if (namespaces != null) {
            LoggingNamespacesTreeNode loggingNamespacesTreeNode = new LoggingNamespacesTreeNode(this.getRootNode(), namespaces);
            this.addChild(loggingNamespacesTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_NAMESPACES_MENU_STRING)) {
                if (this._bean.getNamespaces() == null) {
                    this._bean.addNamespaces();
                    LoggingNamespacesTreeNode newNode = new LoggingNamespacesTreeNode(this, this._bean.getNamespaces());
                    this.insertNode(newNode);
                    this._addNamespacesMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_LOGGING_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof LoggingNamespacesTreeNode) {
            this._bean.removeNamespaces();
            this.removeNode(node);
            this._addNamespacesMenuItem.setEnabled(true);
        }
    }
}

