/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.LoggingNamespaceType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoggingNamespacesType
extends ConfigBeanNode {
    protected LoggingNamespaceType[] _namespaces = null;

    public LoggingNamespacesType(DDBean stdBean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        super(stdBean, parent, node);
        this.init();
    }

    public LoggingNamespacesType(ConfigBeanNode parent, Node node) throws ConfigurationException {
        this(null, parent, node);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "namespaces");
        XMLUtils.writeTagAttributeEnd(out, indentation, "namespaces");
        LoggingNamespaceType.writeXML(out, indentation + "\t", this.getNamespaces());
        XMLUtils.writeTagEnd(out, indentation, "namespaces");
    }

    public void writeNamespacesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        LoggingNamespaceType.writeXML(out, indentation, this._namespaces);
    }

    private void init() throws ConfigurationException {
        this.setXpath("namespaces");
        Vector<LoggingNamespaceType> namespaces = new Vector<LoggingNamespaceType>();
        if (this.getNode() != null) {
            Object val = null;
            Node node = this.getNode();
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("namespace")) continue;
                LoggingNamespaceType namespace = new LoggingNamespaceType(this, node);
                namespaces.add(namespace);
            }
        }
        if (namespaces.size() > 0) {
            this._namespaces = namespaces.toArray(new LoggingNamespaceType[0]);
        }
    }

    public void setNamespaces(LoggingNamespaceType[] namespaces) throws ConfigurationException {
        LoggingNamespaceType[] oldValue = this._namespaces;
        this._namespaces = namespaces;
        this.firePropertyChange("namespaces", oldValue, this._namespaces);
    }

    public LoggingNamespaceType[] getNamespaces() {
        return this._namespaces;
    }

    public LoggingNamespaceType[] defaultNamespaces() {
        try {
            return new LoggingNamespaceType[0];
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public void addNamespaces() throws ConfigurationException {
        if (this._namespaces != null) {
            return;
        }
        LoggingNamespaceType[] namespaces = new LoggingNamespaceType[]{new LoggingNamespaceType(this, null)};
        this.setNamespaces(namespaces);
    }

    public void removeNamespaces() throws ConfigurationException {
        if (this._namespaces == null) {
            return;
        }
        this.setNamespaces(null);
    }

    public void addNamespace(LoggingNamespaceType namespace) throws ConfigurationException {
        namespace.setParent(this);
        int existingNamespacesCnt = 0;
        if (this._namespaces != null) {
            existingNamespacesCnt = this._namespaces.length;
        }
        LoggingNamespaceType[] newNamespaces = new LoggingNamespaceType[existingNamespacesCnt + 1];
        for (int n = 0; n < existingNamespacesCnt; ++n) {
            newNamespaces[n] = this._namespaces[n];
        }
        newNamespaces[existingNamespacesCnt] = namespace;
        LoggingNamespaceType[] oldValue = this._namespaces;
        this._namespaces = newNamespaces;
        this.firePropertyChange("namespaces", oldValue, this._namespaces);
    }

    public void removeNamespace(LoggingNamespaceType namespace) throws ConfigurationException {
        int existingNamespacesCnt = 0;
        if (this._namespaces != null) {
            existingNamespacesCnt = this._namespaces.length;
        }
        LoggingNamespaceType[] newNamespaces = new LoggingNamespaceType[existingNamespacesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingNamespacesCnt; ++n) {
            if (namespace.equals(this._namespaces[n])) continue;
            newNamespaces[newIndex++] = this._namespaces[n];
        }
        if (newNamespaces.length == 0) {
            newNamespaces = null;
        }
        LoggingNamespaceType[] oldValue = this._namespaces;
        this._namespaces = newNamespaces;
        this.firePropertyChange("namespaces", oldValue, this._namespaces);
    }
}

