/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.JaznConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.JaznWebAppTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.JaznWebAppType;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.PropertyTreeNode;

public class JaznTreeNode
extends ConfigTreeNode
implements ActionListener,
PropertyChangeListener {
    private JaznConfigBean _bean;
    private static final String ADD_JAZN_WEB_APP_MENU_STRING = "Add Jazn Web App";
    private static final String ADD_PROPERTY_MENU_STRING = "Add Property";
    private static final String REMOVE_JAZN_MENU_STRING = "Remove Jazn";
    private JMenuItem _addJaznWebAppMenuItem;
    private JMenuItem _addPropertyMenuItem;
    private JMenuItem _removeJaznMenuItem;

    public JaznTreeNode(ConfigTreeNode rootNode, JaznConfigBean bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addJaznWebAppMenuItem = new JMenuItem(ADD_JAZN_WEB_APP_MENU_STRING);
        this._addJaznWebAppMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addJaznWebAppMenuItem.setFont(JaznTreeNode.getFont());
        this._addJaznWebAppMenuItem.addActionListener(this);
        if (this._bean.getJaznWebApp() != null) {
            this._addJaznWebAppMenuItem.setEnabled(false);
        }
        this._addPropertyMenuItem = new JMenuItem(ADD_PROPERTY_MENU_STRING);
        this._addPropertyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPropertyMenuItem.setFont(JaznTreeNode.getFont());
        this._addPropertyMenuItem.addActionListener(this);
        this._removeJaznMenuItem = new JMenuItem(REMOVE_JAZN_MENU_STRING);
        this._removeJaznMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeJaznMenuItem.setFont(JaznTreeNode.getFont());
        this._removeJaznMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addJaznWebAppMenuItem);
        this._popup.add(this._addPropertyMenuItem);
        this._popup.add(this._removeJaznMenuItem);
        if (this._bean != null) {
            this._bean.addPropertyChangeListener(this);
        }
    }

    public String viewHeaderString() {
        return "Jazn";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        JaznWebAppType jaznWebApp;
        PropertyConfigBean[] properties = this._bean.getProperties();
        if (properties != null) {
            for (int i = 0; i < properties.length; ++i) {
                PropertyConfigBean property = properties[i];
                if (property == null) continue;
                PropertyTreeNode propertyTreeNode = new PropertyTreeNode(this.getRootNode(), property);
                this.addChild(propertyTreeNode);
            }
        }
        if ((jaznWebApp = this._bean.getJaznWebApp()) != null) {
            JaznWebAppTreeNode jaznWebAppTreeNode = new JaznWebAppTreeNode(this.getRootNode(), jaznWebApp);
            this.addChild(jaznWebAppTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_PROPERTY_MENU_STRING)) {
                PropertyConfigBean newProperty = new PropertyConfigBean(this._bean);
                if (this.showAddDialog(newProperty, ADD_PROPERTY_MENU_STRING)) {
                    this._bean.addProperty(newProperty);
                }
            } else if (event.getActionCommand().equals(ADD_JAZN_WEB_APP_MENU_STRING)) {
                JaznWebAppType newJaznWebApp = this._bean.defaultJaznWebApp();
                if (this.showAddDialog(newJaznWebApp, ADD_JAZN_WEB_APP_MENU_STRING)) {
                    this._bean.setJaznWebApp(newJaznWebApp);
                    JaznWebAppTreeNode newNode = new JaznWebAppTreeNode(this, newJaznWebApp);
                    this.insertNode(newNode);
                    this._addJaznWebAppMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_JAZN_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof PropertyTreeNode) {
            PropertyConfigBean property = (PropertyConfigBean)node.getConfigBeanNode();
            this._bean.removeProperty(property);
            this.removeNode(node);
        } else if (node instanceof JaznWebAppTreeNode) {
            this._bean.removeJaznWebApp();
            this.removeNode(node);
            this._addJaznWebAppMenuItem.setEnabled(true);
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if ("properties".equals(propertyName)) {
            this.rebuildTree();
        }
    }
}

