/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IconType
extends ConfigBeanNode {
    private String smallIcon;
    private String largeIcon;

    public IconType(ConfigBeanNode parent, Node node) {
        this(null, parent, node);
    }

    public IconType(DDBean stdBean, ConfigBeanNode parent, Node node) {
        super(stdBean, parent, node);
        this.init();
    }

    public void init() {
        this.setXpath("icon");
        Node node = this.getNode();
        if (node != null) {
            NodeList childNodes = node.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String name = childNodes.item(i).getNodeName();
                if (name.equals("small-icon")) {
                    this.smallIcon = XMLUtils.getValue(childNodes.item(i));
                    continue;
                }
                if (!name.equals("large-icon")) continue;
                this.largeIcon = XMLUtils.getValue(childNodes.item(i));
            }
        }
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagStart(out, indentation, "icon");
        XMLUtils.writeTagWithValue(out, indentation + "\t", "large-icon", this.largeIcon);
        XMLUtils.writeTagWithValue(out, indentation + "\t", "small-icon", this.smallIcon);
        XMLUtils.writeTagEnd(out, indentation + "\t", "icon");
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    public void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }
}

