/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.XMLUtils;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigPropertyType;
import oracle.oc4j.admin.deploy.spi.xml.ConnectionPoolingType;
import oracle.oc4j.admin.deploy.spi.xml.FileType;
import oracle.oc4j.admin.deploy.spi.xml.SecurityConfigType;
import oracle.oc4j.admin.deploy.spi.xml.XaRecoveryConfigType;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConnectorFactoryType
extends ConfigBeanNode {
    String _description = null;
    String _connectorName = null;
    String _location = null;
    FileType _log = null;
    ConfigPropertyType[] _configProperties = null;
    ConnectionPoolingType _connectionPooling = null;
    SecurityConfigType _securityConfig = null;
    String _connectionFactoryInterface = null;
    XaRecoveryConfigType _xaRecoveryConfig = null;

    public ConnectorFactoryType(ConfigBeanNode parent) {
        this(parent, null);
    }

    public ConnectorFactoryType(ConfigBeanNode parent, Node node) {
        super(null, parent, node);
        this.init();
    }

    public void setDescription(String description) throws ConfigurationException {
        String oldValue = this._description;
        this._description = description;
        this.firePropertyChange("description", oldValue, this._description);
    }

    public String getDescription() {
        return this._description;
    }

    public String defaultDescription() {
        return "";
    }

    public ConnectionPoolingType getConnectionPooling() {
        return this._connectionPooling;
    }

    public void setConnectionPooling(ConnectionPoolingType connectionPooling) {
        ConnectionPoolingType oldValue = this._connectionPooling;
        this._connectionPooling = connectionPooling;
        this.firePropertyChange("connectionPooling", oldValue, this._connectionPooling);
    }

    public void addConnectionPooling() {
        if (this._connectionPooling != null) {
            return;
        }
        ConnectionPoolingType connectionPooling = new ConnectionPoolingType(this, null);
        this.setConnectionPooling(connectionPooling);
    }

    public void removeConnectionPooling() {
        if (this._connectionPooling == null) {
            return;
        }
        this.setConnectionPooling(null);
    }

    public ConnectionPoolingType defaultConnectionPooling() {
        return new ConnectionPoolingType(this, null);
    }

    public void setConnectorName(String connectorName) throws ConfigurationException {
        String oldValue = this._connectorName;
        this._connectorName = connectorName;
        this.firePropertyChange("connectorName", oldValue, this._connectorName);
    }

    public String getConnectorName() {
        return this._connectorName;
    }

    public String defaultConnectorName() {
        return "";
    }

    public void setLocation(String location) {
        String oldValue = this._location;
        this._location = location;
        this.firePropertyChange("location", oldValue, this._location);
    }

    public String getLocation() {
        return this._location;
    }

    public String defaultLocation() {
        return "";
    }

    public FileType getLog() {
        return this._log;
    }

    public void setLog(FileType log) {
        FileType oldValue = this._log;
        this._log = log;
        this.firePropertyChange("log", oldValue, this._log);
    }

    public void addLog() {
        if (this._log != null) {
            return;
        }
        FileType log = new FileType(this, null);
        this.setLog(log);
    }

    public void removeLog() {
        if (this._log == null) {
            return;
        }
        this.setLog(null);
    }

    public FileType defaultLog() {
        return new FileType(this, null);
    }

    public void setConfigProperties(ConfigPropertyType[] configProperties) {
        ConfigPropertyType[] oldValue = this._configProperties;
        this._configProperties = configProperties;
        this.firePropertyChange("configProperties", oldValue, this._configProperties);
    }

    public ConfigPropertyType[] getConfigProperties() {
        return this._configProperties;
    }

    public ConfigPropertyType[] defaultConfigProperties() {
        ConfigPropertyType[] configProperties = new ConfigPropertyType[]{new ConfigPropertyType(this, null)};
        return configProperties;
    }

    public void addConfigProperties() {
        if (this._configProperties != null) {
            return;
        }
        ConfigPropertyType[] configProperties = new ConfigPropertyType[]{new ConfigPropertyType(this, null)};
        this.setConfigProperties(configProperties);
    }

    public void removeConfigProperties() {
        if (this._configProperties == null) {
            return;
        }
        this.setConfigProperties(null);
    }

    public void addConfigProperty(ConfigPropertyType configProperty) {
        configProperty.setParent(this);
        int existingConfigPropertiesCnt = 0;
        if (this._configProperties != null) {
            existingConfigPropertiesCnt = this._configProperties.length;
        }
        ConfigPropertyType[] newConfigProperties = new ConfigPropertyType[existingConfigPropertiesCnt + 1];
        for (int n = 0; n < existingConfigPropertiesCnt; ++n) {
            newConfigProperties[n] = this._configProperties[n];
        }
        newConfigProperties[existingConfigPropertiesCnt] = configProperty;
        ConfigPropertyType[] oldValue = this._configProperties;
        this._configProperties = newConfigProperties;
        this.firePropertyChange("configProperties", oldValue, this._configProperties);
    }

    public void removeConfigProperty(ConfigPropertyType configProperty) {
        int existingConfigPropertiesCnt = 0;
        if (this._configProperties != null) {
            existingConfigPropertiesCnt = this._configProperties.length;
        }
        ConfigPropertyType[] newConfigProperties = new ConfigPropertyType[existingConfigPropertiesCnt - 1];
        int newIndex = 0;
        for (int n = 0; n < existingConfigPropertiesCnt; ++n) {
            if (configProperty.equals(this._configProperties[n])) continue;
            newConfigProperties[newIndex++] = this._configProperties[n];
        }
        if (newConfigProperties.length == 0) {
            newConfigProperties = null;
        }
        ConfigPropertyType[] oldValue = this._configProperties;
        this._configProperties = newConfigProperties;
        this.firePropertyChange("configProperties", oldValue, this._configProperties);
    }

    public SecurityConfigType getSecurityConfig() {
        return this._securityConfig;
    }

    public void setSecurityConfig(SecurityConfigType securityConfig) {
        SecurityConfigType oldValue = this._securityConfig;
        this._securityConfig = securityConfig;
        this.firePropertyChange("securityConfig", oldValue, this._securityConfig);
    }

    public void addSecurityConfig() {
        if (this._securityConfig != null) {
            return;
        }
        SecurityConfigType securityConfig = new SecurityConfigType(this, null);
        this.setSecurityConfig(securityConfig);
    }

    public void removeSecurityConfig() {
        if (this._securityConfig == null) {
            return;
        }
        this.setSecurityConfig(null);
    }

    public SecurityConfigType defaultSecurityConfig() {
        return new SecurityConfigType(this, null);
    }

    public void setConnectionFactoryInterface(String connectionFactoryInterface) throws ConfigurationException {
        String oldValue = this._connectionFactoryInterface;
        this._connectionFactoryInterface = connectionFactoryInterface;
        this.firePropertyChange("connectionFactoryInterface", oldValue, this._connectionFactoryInterface);
    }

    public String getConnectionFactoryInterface() {
        return this._connectionFactoryInterface;
    }

    public String defaultConnectionFactoryInterface() {
        return "";
    }

    public XaRecoveryConfigType getXaRecoveryConfig() {
        return this._xaRecoveryConfig;
    }

    public void setXaRecoveryConfig(XaRecoveryConfigType xaRecoveryConfig) {
        XaRecoveryConfigType oldValue = this._xaRecoveryConfig;
        this._xaRecoveryConfig = xaRecoveryConfig;
        this.firePropertyChange("xaRecoveryConfig", oldValue, this._xaRecoveryConfig);
    }

    public void addXaRecoveryConfig() {
        if (this._xaRecoveryConfig != null) {
            return;
        }
        XaRecoveryConfigType xaRecoveryConfig = new XaRecoveryConfigType(this, null);
        this.setXaRecoveryConfig(xaRecoveryConfig);
    }

    public void removeXaRecoveryConfig() {
        if (this._xaRecoveryConfig == null) {
            return;
        }
        this.setXaRecoveryConfig(null);
    }

    public XaRecoveryConfigType defaultXaRecoveryConfig() {
        return new XaRecoveryConfigType(this, null);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        XMLUtils.writeTagAttributeStart(out, indentation, "connector-factory");
        XMLUtils.writeAttribute(out, indentation, "connector-name", this._connectorName);
        XMLUtils.writeAttribute(out, indentation, "location", this._location);
        XMLUtils.writeTagAttributeEnd(out, indentation, "connector-factory");
        if (this._description != null && this._description.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "description", this._description);
        }
        ConnectorFactoryType.writeXML(out, indentation + "\t", this._configProperties);
        if (this._connectionPooling != null) {
            this._connectionPooling.writeXML(out, indentation + "\t");
        }
        if (this._securityConfig != null) {
            this._securityConfig.writeXML(out, indentation + "\t");
        }
        if (this._log != null && this._log.getPath() != null && this._log.getPath().length() > 0) {
            XMLUtils.writeTagAttributeStart(out, indentation + "\t", "log");
            XMLUtils.writeTagAttributeEnd(out, indentation + "\t", "log");
            this._log.writeXML(out, indentation + "\t\t");
            XMLUtils.writeTagEnd(out, indentation + "\t", "log");
        }
        if (this._connectionFactoryInterface != null && this._connectionFactoryInterface.length() > 0) {
            XMLUtils.writeTag(out, indentation + "\t", "connectionfactory-interface", this._connectionFactoryInterface);
        }
        if (this._xaRecoveryConfig != null) {
            this._xaRecoveryConfig.writeXML(out, indentation + "\t");
        }
        XMLUtils.writeTagEnd(out, indentation, "connector-factory");
    }

    public void writeConfigPropertiesXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        ConnectorFactoryType.writeXML(out, indentation + "\t", this._configProperties);
    }

    private void init() {
        this.setXpath("connector-factory");
        Vector<ConfigPropertyType> configProperties = new Vector<ConfigPropertyType>();
        if (this.getNode() != null) {
            String val = null;
            Node node = this.getNode();
            val = XMLUtils.getAttribute(node, "connector-name");
            if (val != null && !val.trim().equals("")) {
                this._connectorName = val;
            }
            if ((val = XMLUtils.getAttribute(node, "location")) != null && !val.trim().equals("")) {
                this._location = val;
            }
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                node = nodes.item(i);
                String name = node.getNodeName();
                if (name.equals("description")) {
                    this._description = XMLUtils.getValue(node);
                    continue;
                }
                if (name.equals("log")) {
                    NodeList logNodes = node.getChildNodes();
                    for (int l = 0; l < logNodes.getLength(); ++l) {
                        node = logNodes.item(l);
                        name = node.getNodeName();
                        if (!name.equals("file")) continue;
                        this._log = new FileType(this, node);
                    }
                    continue;
                }
                if (name.equals("config-property")) {
                    ConfigPropertyType configBean = new ConfigPropertyType(this, node);
                    configProperties.add(configBean);
                    continue;
                }
                if (name.equals("connection-pooling")) {
                    this._connectionPooling = new ConnectionPoolingType(this, node);
                    continue;
                }
                if (name.equals("security-config")) {
                    this._securityConfig = new SecurityConfigType(this, node);
                    continue;
                }
                if (name.equals("connectionfactory-interface")) {
                    this._connectionFactoryInterface = XMLUtils.getValue(node);
                    continue;
                }
                if (!name.equals("xa-recovery-config")) continue;
                this._xaRecoveryConfig = new XaRecoveryConfigType(this, node);
            }
        }
        this._configProperties = configProperties.toArray(new ConfigPropertyType[0]);
    }
}

