/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.XpathEvent;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.exceptions.BeanNotFoundException;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import oracle.oc4j.admin.deploy.gui.DataEntryElement;
import oracle.oc4j.admin.deploy.gui.DataEntryElementFactory;
import oracle.oc4j.admin.deploy.gui.PropertyValidator;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.deploy.shared.xml.XMLizable;
import oracle.oc4j.admin.deploy.spi.DeplManager;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.deploy.spi.ProprietaryTargetModuleID;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedConfigurationException;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanRootNode;
import oracle.oc4j.admin.deploy.spi.xml.ContextParamMappingType;
import oracle.oc4j.admin.deploy.spi.xml.EjbRefMappingConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.EntityDeploymentConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.EnvEntryMappingConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.JavaBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.MessageDestinationMappingType;
import oracle.oc4j.admin.deploy.spi.xml.MessageDestinationRefMappingType;
import oracle.oc4j.admin.deploy.spi.xml.MessageDrivenDeploymentConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.PortComponentConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.ResourceEnvRefMappingConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.ResourceRefMappingConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.SecurityRoleMappingConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.ServiceRefMappingConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.SessionDeploymentConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.WebServiceDescriptionConfigBean;
import oracle.oc4j.admin.deploy.spi.xml.XmlType;
import org.w3c.dom.Node;

public abstract class ConfigBeanNode
extends JavaBeanNode
implements XMLizable,
DConfigBean,
PropertyValidator {
    protected DDBean _stdBean = null;
    protected String[] _xpaths = new String[0];
    protected String[] _configXpaths = new String[0];
    protected ConfigBeanNode _configParent = null;
    protected DataEntryElement[] _attrElements = null;

    public ConfigBeanNode(DDBean stdBean, ConfigBeanNode parent) {
        this(stdBean, parent, null);
    }

    public ConfigBeanNode(DDBean stdBean, ConfigBeanNode parent, Node node) {
        super(parent, node);
        this._configParent = parent;
        this._stdBean = stdBean;
    }

    public ConfigBeanNode(DDBean stdBean) {
        this(stdBean, null, null);
    }

    public ConfigBeanNode(DDBean stdBean, Node node) {
        this(stdBean, null, node);
    }

    protected void setParent(ConfigBeanNode parent) {
        this._configParent = parent;
        super.setParent(parent);
    }

    public void putDDBean(DDBean bean) {
        this._stdBean = bean;
    }

    public DDBean fetchDDBean() {
        return this._stdBean;
    }

    public DataEntryElement[] fetchAttributeElements() {
        if (this._attrElements == null) {
            this._attrElements = DataEntryElementFactory.createJavaBeanDataElements(this);
        }
        return this._attrElements;
    }

    public boolean validatePropertyValue(String name, Object value) {
        return true;
    }

    public DDBean getDDBean() {
        return this._stdBean;
    }

    protected String key() {
        throw new UnsupportedOperationException();
    }

    protected String keyName() {
        return "name";
    }

    protected String beanKey() {
        throw new UnsupportedOperationException();
    }

    protected DConfigBean buildChild(String xpath, DDBean bean, ConfigBeanNode parent, Node node) throws ConfigurationException {
        if (xpath.equals("security-role-mapping")) {
            return new SecurityRoleMappingConfigBean(bean, parent, node);
        }
        if (xpath.equals("assembly-descriptor/security-role-mapping")) {
            return new SecurityRoleMappingConfigBean(bean, parent, node);
        }
        if (xpath.equals("enterprise-beans/session-deployment")) {
            return new SessionDeploymentConfigBean(bean, parent, node);
        }
        if (xpath.equals("enterprise-beans/entity-deployment")) {
            return new EntityDeploymentConfigBean(bean, parent, node);
        }
        if (xpath.equals("enterprise-beans/message-driven-deployment")) {
            return new MessageDrivenDeploymentConfigBean(bean, parent, node);
        }
        if (xpath.equals("resource-ref-mapping")) {
            return new ResourceRefMappingConfigBean(bean, parent, node);
        }
        if (xpath.equals("resource-env-ref-mapping")) {
            return new ResourceEnvRefMappingConfigBean(bean, parent, node);
        }
        if (xpath.equals("ejb-ref-mapping")) {
            return new EjbRefMappingConfigBean(bean, parent, node);
        }
        if (xpath.equals("env-entry-mapping")) {
            return new EnvEntryMappingConfigBean(bean, parent, node);
        }
        if (xpath.equals("context-param-mapping")) {
            return new ContextParamMappingType(bean, parent, node);
        }
        if (xpath.equals("service-ref-mapping")) {
            return new ServiceRefMappingConfigBean(bean, parent, node);
        }
        if (xpath.equals("webservice-description")) {
            return new WebServiceDescriptionConfigBean(bean, parent, node);
        }
        if (xpath.equals("port-component")) {
            return new PortComponentConfigBean(bean, parent, node);
        }
        if (xpath.equals("message-destination-ref-mapping")) {
            return new MessageDestinationRefMappingType(bean, parent, node);
        }
        if (xpath.equals("assembly-descriptor/message-destination-mapping")) {
            return new MessageDestinationMappingType(bean, parent, node);
        }
        throw new IllegalArgumentException(FormattingResourceBundle.DeploymentMessages.getString("getDConfigBeanArg", new String[]{bean.getXpath(), this._stdBean.getXpath()}));
    }

    public DConfigBean getDConfigBean(DDBean bean) throws ConfigurationException {
        int found = -1;
        if (this._xpaths != null) {
            for (int n = 0; n < this._xpaths.length; ++n) {
                if (!bean.getXpath().equals(this._stdBean.getXpath() + "/" + this._xpaths[n])) continue;
                found = n;
                break;
            }
        }
        if (found < 0) {
            throw new ExtendedConfigurationException(FormattingResourceBundle.DeploymentMessages.getString("getDConfigBeanArg", new String[]{bean.getXpath(), this._stdBean.getXpath()}));
        }
        String configXpath = this._configXpaths[found];
        try {
            Vector childMaps = this.getChildBean(configXpath);
            if (childMaps == null) {
                throw new ExtendedConfigurationException(FormattingResourceBundle.DeploymentMessages.getString("missingDConfigBean", new String[]{bean.getText(), configXpath}));
            }
            for (int n = 0; n < childMaps.size(); ++n) {
                ConfigBeanNode configBean = (ConfigBeanNode)childMaps.elementAt(n);
                if (configBean.beanKey() == null || configBean.beanKey().equals("")) continue;
                if (configBean.key() == null) {
                    throw new ExtendedConfigurationException(FormattingResourceBundle.DeploymentMessages.getString("missingDeploymentAttribute", new String[]{configXpath, configBean.keyName()}));
                }
                if (!configBean.key().equals(bean.getText(configBean.beanKey())[0])) continue;
                if (configBean.fetchDDBean() == null) {
                    configBean.putDDBean(bean);
                }
                return configBean;
            }
            DConfigBean configBean = this.buildChild(configXpath, bean, this, null);
            childMaps.add(configBean);
            return configBean;
        }
        catch (Throwable t) {
            throw new ExtendedConfigurationException(t);
        }
    }

    protected ConfigBeanNode getConfigParent() {
        return this._configParent;
    }

    public String[] getXpaths() {
        return this._xpaths;
    }

    public void removeDConfigBean(DConfigBean bean) throws BeanNotFoundException {
        ConfigBeanNode removedBean;
        Vector v;
        if (bean instanceof ConfigBeanNode && (v = this.getChildBean((removedBean = (ConfigBeanNode)bean).getXpath())) != null) {
            for (int n = 0; n < v.size(); ++n) {
                DConfigBean configBean;
                Object obj = v.elementAt(n);
                if (!(obj instanceof DConfigBean) || !(configBean = (DConfigBean)obj).equals(bean)) continue;
                v.removeElementAt(n);
                return;
            }
        }
        throw new BeanNotFoundException(FormattingResourceBundle.DeploymentMessages.getString("noDConfigBean"));
    }

    public void notifyDDChange(XpathEvent event) {
    }

    public ProprietaryTargetModuleID getProprietaryTargetModuleID(String appName) {
        Target tgt;
        DeplManager mgr;
        ProprietaryTargetModuleID proprietaryTargetModuleID = null;
        if (this.determineRoot() != null && (mgr = this.determineRoot().getDeploymentManager()) != null && mgr.isConnected() && (tgt = this.determineRoot().getTarget()) != null) {
            ProprietaryConnectedDeploymentManager connMgr = (ProprietaryConnectedDeploymentManager)mgr;
            proprietaryTargetModuleID = (ProprietaryTargetModuleID)connMgr.getTargetModuleIDForApplication(appName, tgt);
        }
        return proprietaryTargetModuleID;
    }

    public XmlType xml() {
        return new XmlType(this);
    }

    public XmlType defaultXml() {
        return new XmlType(this);
    }

    public boolean onlyOneAddAllowed() {
        return false;
    }

    public ViewableJTree[] subTrees() {
        return null;
    }

    public String getPropertyDoc(String propertyName) {
        return ConfigBeanRootNode.getPropertyDoc(this.getXpath(), propertyName);
    }

    public String getDoc() {
        return ConfigBeanRootNode.getDoc(this.getXpath());
    }
}

