/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.CommitOptionType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanNode;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.NonCmrFieldTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.NonCmrFieldType;
import oracle.oc4j.admin.deploy.spi.xml.OcaFieldMappingTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.OcaFieldMappingType;

public class CommitOptionTreeNode
extends ConfigTreeNode
implements ActionListener {
    private CommitOptionType _bean;
    private static final String ADD_OCA_FIELD_MAPPING_MENU_STRING = "Add Oca Field Mapping";
    private static final String ADD_NON_CMR_FIELD_MENU_STRING = "Add Non Cmr Field";
    private static final String REMOVE_COMMIT_OPTION_MENU_STRING = "Remove Commit Option";
    private JMenuItem _addOcaFieldMappingMenuItem;
    private JMenuItem _addNonCmrFieldMenuItem;
    private JMenuItem _removeCommitoptionMenuItem;

    public CommitOptionTreeNode(ConfigTreeNode rootNode, ConfigBeanNode bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = (CommitOptionType)bean;
        this._addOcaFieldMappingMenuItem = new JMenuItem(ADD_OCA_FIELD_MAPPING_MENU_STRING);
        this._addOcaFieldMappingMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addOcaFieldMappingMenuItem.setFont(CommitOptionTreeNode.getFont());
        this._addOcaFieldMappingMenuItem.addActionListener(this);
        if (this._bean.getOcaFieldMapping() != null) {
            this._addOcaFieldMappingMenuItem.setEnabled(false);
        }
        this._addNonCmrFieldMenuItem = new JMenuItem(ADD_NON_CMR_FIELD_MENU_STRING);
        this._addNonCmrFieldMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addNonCmrFieldMenuItem.setFont(CommitOptionTreeNode.getFont());
        this._addNonCmrFieldMenuItem.addActionListener(this);
        if (this._bean.getNonCmrField() != null) {
            this._addNonCmrFieldMenuItem.setEnabled(false);
        }
        this._removeCommitoptionMenuItem = new JMenuItem(REMOVE_COMMIT_OPTION_MENU_STRING);
        this._removeCommitoptionMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeCommitoptionMenuItem.setFont(CommitOptionTreeNode.getFont());
        this._removeCommitoptionMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addOcaFieldMappingMenuItem);
        this._popup.add(this._addNonCmrFieldMenuItem);
        this._popup.add(this._removeCommitoptionMenuItem);
    }

    public String viewHeaderString() {
        return "Commit Option";
    }

    public String toString() {
        return this.viewHeaderString();
    }

    protected void buildChildJTree() {
        NonCmrFieldType nonCmrField;
        OcaFieldMappingType ocaFieldMapping = this._bean.getOcaFieldMapping();
        if (ocaFieldMapping != null) {
            OcaFieldMappingTreeNode ocaFieldMappingTreeNode = new OcaFieldMappingTreeNode(this, ocaFieldMapping);
            this.addChild(ocaFieldMappingTreeNode);
        }
        if ((nonCmrField = this._bean.getNonCmrField()) != null) {
            NonCmrFieldTreeNode nonCmrFieldTreeNode = new NonCmrFieldTreeNode(this, nonCmrField);
            this.addChild(nonCmrFieldTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_OCA_FIELD_MAPPING_MENU_STRING)) {
                OcaFieldMappingType newOcaFieldMapping = this._bean.defaultOcaFieldMapping();
                if (this.showAddDialog(newOcaFieldMapping, ADD_OCA_FIELD_MAPPING_MENU_STRING)) {
                    this._bean.setOcaFieldMapping(newOcaFieldMapping);
                    OcaFieldMappingTreeNode newNode = new OcaFieldMappingTreeNode(this, newOcaFieldMapping);
                    this.insertNode(newNode);
                    this._addOcaFieldMappingMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_NON_CMR_FIELD_MENU_STRING)) {
                NonCmrFieldType newNonCmrField = this._bean.defaultNonCmrField();
                if (this.showAddDialog(newNonCmrField, ADD_NON_CMR_FIELD_MENU_STRING)) {
                    this._bean.setNonCmrField(newNonCmrField);
                    NonCmrFieldTreeNode newNode = new NonCmrFieldTreeNode(this, newNonCmrField);
                    this.insertNode(newNode);
                    this._addNonCmrFieldMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_COMMIT_OPTION_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof OcaFieldMappingTreeNode) {
            this._bean.removeOcaFieldMapping();
            this.removeNode(node);
            this._addOcaFieldMappingMenuItem.setEnabled(true);
        } else if (node instanceof NonCmrFieldTreeNode) {
            this._bean.removeNonCmrField();
            this.removeNode(node);
            this._addNonCmrFieldMenuItem.setEnabled(true);
        }
    }
}

