/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.xml;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.spi.xml.ClusterType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.FlowControlPolicyTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.FlowControlPolicyType;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.PropertyConfigType;
import oracle.oc4j.admin.deploy.spi.xml.ProtocolTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ProtocolType;
import oracle.oc4j.admin.deploy.spi.xml.ReplicationPolicyTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.ReplicationPolicyType;
import oracle.oc4j.admin.deploy.spi.xml.SynchronousReplicationTreeNode;
import oracle.oc4j.admin.deploy.spi.xml.SynchronousReplicationType;

public class ClusterTreeNode
extends ConfigTreeNode
implements ActionListener {
    private ClusterType _bean;
    private static final String ADD_PROPERTY_CONFIG__MENU_STRING = "Add Property Config";
    private static final String ADD_PROTOCOL_MENU_STRING = "Add Protocol";
    private static final String ADD_REPLICATION_POLICY_MENU_STRING = "Add Replication Policy";
    private static final String ADD_FLOW_CONTROL_POLICY_MENU_STRING = "Add Flow Control Policy";
    private static final String ADD_SYNCHRONOUS_REPLICATION_MENU_STRING = "Add Synchronous Replication";
    private static final String REMOVE_CLUSTER_MENU_STRING = "Remove Cluster";
    private JMenuItem _addPropertyConfigMenuItem;
    private JMenuItem _addProtocolMenuItem;
    private JMenuItem _addReplicationPolicyMenuItem;
    private JMenuItem _addFlowControlPolicyMenuItem;
    private JMenuItem _addSynchronousReplicationMenuItem;
    private JMenuItem _removeClusterMenuItem;

    public ClusterTreeNode(ConfigTreeNode rootNode, ClusterType bean) {
        super(bean);
        this.setRootNode(rootNode);
        this._bean = bean;
        this._addPropertyConfigMenuItem = new JMenuItem(ADD_PROPERTY_CONFIG__MENU_STRING);
        this._addPropertyConfigMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addPropertyConfigMenuItem.setFont(ClusterTreeNode.getFont());
        this._addPropertyConfigMenuItem.addActionListener(this);
        if (this._bean.getPropertyConfig() != null) {
            this._addPropertyConfigMenuItem.setEnabled(false);
        } else if (this._bean.getProtocol() != null) {
            this._addPropertyConfigMenuItem.setEnabled(false);
        }
        this._addProtocolMenuItem = new JMenuItem(ADD_PROTOCOL_MENU_STRING);
        this._addProtocolMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addProtocolMenuItem.setFont(ClusterTreeNode.getFont());
        this._addProtocolMenuItem.addActionListener(this);
        if (this._bean.getProtocol() != null) {
            this._addProtocolMenuItem.setEnabled(false);
        } else if (this._bean.getPropertyConfig() != null) {
            this._addProtocolMenuItem.setEnabled(false);
        }
        this._addReplicationPolicyMenuItem = new JMenuItem(ADD_REPLICATION_POLICY_MENU_STRING);
        this._addReplicationPolicyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addReplicationPolicyMenuItem.setFont(ClusterTreeNode.getFont());
        this._addReplicationPolicyMenuItem.addActionListener(this);
        if (this._bean.getReplicationPolicy() != null) {
            this._addReplicationPolicyMenuItem.setEnabled(false);
        }
        this._addFlowControlPolicyMenuItem = new JMenuItem(ADD_FLOW_CONTROL_POLICY_MENU_STRING);
        this._addFlowControlPolicyMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addFlowControlPolicyMenuItem.setFont(ClusterTreeNode.getFont());
        this._addFlowControlPolicyMenuItem.addActionListener(this);
        if (this._bean.getFlowControlPolicy() != null) {
            this._addFlowControlPolicyMenuItem.setEnabled(false);
        }
        this._addSynchronousReplicationMenuItem = new JMenuItem(ADD_SYNCHRONOUS_REPLICATION_MENU_STRING);
        this._addSynchronousReplicationMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._addSynchronousReplicationMenuItem.setFont(ClusterTreeNode.getFont());
        this._addSynchronousReplicationMenuItem.addActionListener(this);
        if (this._bean.getSynchronousReplication() != null) {
            this._addSynchronousReplicationMenuItem.setEnabled(false);
        }
        this._removeClusterMenuItem = new JMenuItem(REMOVE_CLUSTER_MENU_STRING);
        this._removeClusterMenuItem.setBackground(Deployer.TreeBackgroundColor);
        this._removeClusterMenuItem.setFont(ClusterTreeNode.getFont());
        this._removeClusterMenuItem.addActionListener(this);
        this._popup = new JPopupMenu();
        this._popup.add(this._addPropertyConfigMenuItem);
        this._popup.add(this._addProtocolMenuItem);
        this._popup.add(this._addReplicationPolicyMenuItem);
        this._popup.add(this._addFlowControlPolicyMenuItem);
        this._popup.add(this._addSynchronousReplicationMenuItem);
        this._popup.add(this._removeClusterMenuItem);
    }

    public String viewHeaderString() {
        return "Cluster";
    }

    public String toString() {
        return "Cluster";
    }

    protected void buildChildJTree() {
        SynchronousReplicationType synchronousReplication;
        FlowControlPolicyType flowControlPolicy;
        ReplicationPolicyType replicationPolicy;
        ProtocolType protocol;
        PropertyConfigType propertyConfig = this._bean.getPropertyConfig();
        if (propertyConfig != null) {
            PropertyConfigTreeNode propertyConfigTreeNode = new PropertyConfigTreeNode(this.getRootNode(), propertyConfig);
            this.addChild(propertyConfigTreeNode);
        }
        if ((protocol = this._bean.getProtocol()) != null) {
            ProtocolTreeNode protocolTreeNode = new ProtocolTreeNode(this.getRootNode(), protocol);
            this.addChild(protocolTreeNode);
        }
        if ((replicationPolicy = this._bean.getReplicationPolicy()) != null) {
            ReplicationPolicyTreeNode replicationPolicyTreeNode = new ReplicationPolicyTreeNode(this.getRootNode(), replicationPolicy);
            this.addChild(replicationPolicyTreeNode);
        }
        if ((flowControlPolicy = this._bean.getFlowControlPolicy()) != null) {
            FlowControlPolicyTreeNode flowControlPolicyTreeNode = new FlowControlPolicyTreeNode(this.getRootNode(), flowControlPolicy);
            this.addChild(flowControlPolicyTreeNode);
        }
        if ((synchronousReplication = this._bean.getSynchronousReplication()) != null) {
            SynchronousReplicationTreeNode synchronousReplicationTreeNode = new SynchronousReplicationTreeNode(this.getRootNode(), synchronousReplication);
            this.addChild(synchronousReplicationTreeNode);
        }
    }

    public void actionPerformed(ActionEvent event) {
        try {
            if (event.getActionCommand().equals(ADD_PROPERTY_CONFIG__MENU_STRING)) {
                PropertyConfigType newPropertyConfig = this._bean.defaultPropertyConfig();
                if (this.showAddDialog(newPropertyConfig, ADD_PROPERTY_CONFIG__MENU_STRING)) {
                    this._bean.setPropertyConfig(newPropertyConfig);
                    PropertyConfigTreeNode newNode = new PropertyConfigTreeNode(this, newPropertyConfig);
                    this.insertNode(newNode);
                    this._addPropertyConfigMenuItem.setEnabled(false);
                    this._addProtocolMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_PROTOCOL_MENU_STRING)) {
                ProtocolType newProtocol = this._bean.defaultProtocol();
                if (this.showAddDialog(newProtocol, ADD_PROTOCOL_MENU_STRING)) {
                    this._bean.setProtocol(newProtocol);
                    ProtocolTreeNode newNode = new ProtocolTreeNode(this, newProtocol);
                    this.insertNode(newNode);
                    this._addPropertyConfigMenuItem.setEnabled(false);
                    this._addProtocolMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_REPLICATION_POLICY_MENU_STRING)) {
                ReplicationPolicyType newReplicationPolicy = this._bean.defaultReplicationPolicy();
                if (this.showAddDialog(newReplicationPolicy, ADD_REPLICATION_POLICY_MENU_STRING)) {
                    this._bean.setReplicationPolicy(newReplicationPolicy);
                    ReplicationPolicyTreeNode newNode = new ReplicationPolicyTreeNode(this, newReplicationPolicy);
                    this.insertNode(newNode);
                    this._addReplicationPolicyMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_FLOW_CONTROL_POLICY_MENU_STRING)) {
                FlowControlPolicyType newFlowControlPolicy = this._bean.defaultFlowControlPolicy();
                if (this.showAddDialog(newFlowControlPolicy, ADD_FLOW_CONTROL_POLICY_MENU_STRING)) {
                    this._bean.setFlowControlPolicy(newFlowControlPolicy);
                    FlowControlPolicyTreeNode newNode = new FlowControlPolicyTreeNode(this, newFlowControlPolicy);
                    this.insertNode(newNode);
                    this._addFlowControlPolicyMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(ADD_SYNCHRONOUS_REPLICATION_MENU_STRING)) {
                SynchronousReplicationType newSynchronousReplication = this._bean.defaultSynchronousReplication();
                if (this.showAddDialog(newSynchronousReplication, ADD_SYNCHRONOUS_REPLICATION_MENU_STRING)) {
                    this._bean.setSynchronousReplication(newSynchronousReplication);
                    SynchronousReplicationTreeNode newNode = new SynchronousReplicationTreeNode(this, newSynchronousReplication);
                    this.insertNode(newNode);
                    this._addSynchronousReplicationMenuItem.setEnabled(false);
                }
            } else if (event.getActionCommand().equals(REMOVE_CLUSTER_MENU_STRING) && this.confirmRemove()) {
                this.getParentNode().remove(this);
            }
        }
        catch (Throwable ex) {
            throw new ExtendedRuntimeException(ex);
        }
    }

    public void remove(ConfigTreeNode node) throws ConfigurationException {
        if (node instanceof PropertyConfigTreeNode) {
            this._bean.removePropertyConfig();
            this.removeNode(node);
            if (this._bean.getProtocol() == null) {
                this._addPropertyConfigMenuItem.setEnabled(true);
                this._addProtocolMenuItem.setEnabled(true);
            }
        } else if (node instanceof ProtocolTreeNode) {
            this._bean.removeProtocol();
            this.removeNode(node);
            if (this._bean.getPropertyConfig() == null) {
                this._addPropertyConfigMenuItem.setEnabled(true);
                this._addProtocolMenuItem.setEnabled(true);
            }
        } else if (node instanceof ReplicationPolicyTreeNode) {
            this._bean.removeReplicationPolicy();
            this.removeNode(node);
            this._addReplicationPolicyMenuItem.setEnabled(true);
        } else if (node instanceof FlowControlPolicyTreeNode) {
            this._bean.removeFlowControlPolicy();
            this.removeNode(node);
            this._addFlowControlPolicyMenuItem.setEnabled(true);
        } else if (node instanceof SynchronousReplicationTreeNode) {
            this._bean.removeSynchronousReplication();
            this.removeNode(node);
            this._addSynchronousReplicationMenuItem.setEnabled(true);
        }
    }
}

