/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.status;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.ObjectName;
import oracle.oc4j.admin.deploy.spi.ClusterTargetImpl;
import oracle.oc4j.admin.deploy.spi.ClusterTargetModuleIDImpl;
import oracle.oc4j.admin.deploy.spi.ProprietaryTargetModuleID;
import oracle.oc4j.admin.deploy.spi.status.ClusterExtendedProgressEvent;
import oracle.oc4j.admin.deploy.spi.status.DeploymentStatusImpl;
import oracle.oc4j.admin.deploy.spi.status.ExtendedProgressEvent;
import oracle.oc4j.admin.deploy.spi.status.ProgressObjectImpl;
import oracle.oc4j.admin.deploy.spi.status.ProprietaryClusterProgressObject;
import oracle.oc4j.admin.deploy.spi.status.StaticProgressObjectImpl;
import oracle.oc4j.admin.jmx.client.ThreadPool;

public class ClusterProgressObjectImpl
implements ProprietaryClusterProgressObject {
    private DeploymentStatusImpl status_ = null;
    private Map listeners_ = null;
    protected Set resultTargetModuleIDs_ = null;
    private CommandType cmdType_;
    private Vector progressEvents_ = null;
    private HashSet completedConfigSetDeployments_ = null;
    private int configSetDeployments_ = 0;
    private long eventCnt_ = 0L;
    private Map individualConfigSetProgressObjects_ = null;
    private Map completedConfigSetProgressObjects_ = null;
    private Map failedConfigSetProgressObjects_ = null;

    public ClusterProgressObjectImpl(CommandType cmd, int targets) {
        this.cmdType_ = cmd;
        this.status_ = new DeploymentStatusImpl(cmd);
        this.listeners_ = new HashMap();
        this.resultTargetModuleIDs_ = new HashSet();
        this.progressEvents_ = new Vector();
        this.completedConfigSetDeployments_ = new HashSet();
        this.individualConfigSetProgressObjects_ = new HashMap();
        this.completedConfigSetProgressObjects_ = new HashMap();
        this.failedConfigSetProgressObjects_ = new HashMap();
        this.configSetDeployments_ = targets;
        new ConnectionMonitor();
    }

    public synchronized DeploymentStatus getDeploymentStatus() {
        return this.status_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getResultTargetModuleIDs() {
        Set set = this.resultTargetModuleIDs_;
        synchronized (set) {
            TargetModuleID[] res = new TargetModuleID[this.resultTargetModuleIDs_.size()];
            Iterator iter = this.resultTargetModuleIDs_.iterator();
            int index = 0;
            while (iter.hasNext()) {
                res[index++] = (TargetModuleID)iter.next();
            }
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getIndividualConfigSetProgressObjects() {
        HashMap res = null;
        Map map = this.individualConfigSetProgressObjects_;
        synchronized (map) {
            res = new HashMap(this.individualConfigSetProgressObjects_);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCompletedConfigSetProgressObjects() {
        HashMap res = null;
        Map map = this.completedConfigSetProgressObjects_;
        synchronized (map) {
            res = new HashMap(this.completedConfigSetProgressObjects_);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getFailedConfigSetProgressObjects() {
        HashMap res = null;
        Map map = this.failedConfigSetProgressObjects_;
        synchronized (map) {
            res = new HashMap(this.failedConfigSetProgressObjects_);
        }
        return res;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID id) {
        throw new UnsupportedOperationException("getClientConfiguration");
    }

    public boolean isCancelSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new UnsupportedOperationException("CANCEL");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void stop() throws OperationUnsupportedException {
        throw new UnsupportedOperationException("STOP");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressListener(ProgressListener pol) {
        Map map = this.listeners_;
        synchronized (map) {
            this.listeners_.put(pol, pol);
            if (this.progressEvents_.size() != 0) {
                for (int i = 0; i < this.progressEvents_.size(); ++i) {
                    pol.handleProgressEvent((ProgressEvent)this.progressEvents_.elementAt(i));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProgressListener(ProgressListener pol) {
        Map map = this.listeners_;
        synchronized (map) {
            this.listeners_.remove(pol);
        }
    }

    private synchronized void updateStatus() {
        if (this.configSetDeployments_ > 0 && this.configSetDeployments_ == this.completedConfigSetDeployments_.size()) {
            Iterator iter = this.completedConfigSetDeployments_.iterator();
            boolean success = true;
            DeploymentStatus depStat = null;
            while (iter.hasNext()) {
                ProgressObject progObj = (ProgressObject)iter.next();
                depStat = progObj.getDeploymentStatus();
                success &= !depStat.isFailed();
            }
            if (success) {
                this.status_.setState(StateType.COMPLETED);
            } else {
                this.status_.setState(StateType.FAILED);
            }
            this.status_.setDefaultApplicationRestartNeeded(((DeploymentStatusImpl)depStat).isDefaultApplicationRestartNeeded());
        }
    }

    public synchronized void addConfigSet(DeploymentManager depMan, Target tgt, ProgressObject progObj) {
        ClusterProgressListener clustListn = new ClusterProgressListener(depMan, tgt, progObj);
        this.individualConfigSetProgressObjects_.put(tgt, progObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addConfigSetForWhichConnectionCanNotBeObtained(Target tgt, String msg) {
        DeploymentStatusImpl failedStatus = new DeploymentStatusImpl(this.cmdType_);
        failedStatus.setMessage(msg);
        failedStatus.setState(StateType.FAILED);
        failedStatus.setAction(ActionType.EXECUTE);
        StaticProgressObjectImpl pobj = new StaticProgressObjectImpl(failedStatus);
        this.completedConfigSetDeployments_.add(pobj);
        Map map = this.failedConfigSetProgressObjects_;
        synchronized (map) {
            this.failedConfigSetProgressObjects_.put(tgt, pobj);
        }
        this.updateStatus();
        ObjectName source = null;
        try {
            source = new ObjectName("*:*");
        }
        catch (Exception exc) {
            // empty catch block
        }
        ExtendedProgressEvent exevent = new ExtendedProgressEvent(source, null, failedStatus, 0L, 0L);
        ClusterTargetModuleIDImpl clustptgid = new ClusterTargetModuleIDImpl((ClusterTargetImpl)tgt, null);
        ((DeploymentStatusImpl)this.getDeploymentStatus()).setMessage(msg);
        Map map2 = this.listeners_;
        synchronized (map2) {
            ClusterExtendedProgressEvent clusterEvent = new ClusterExtendedProgressEvent(exevent, this.eventCnt_++, tgt.toString(), clustptgid, this.getDeploymentStatus(), StateType.FAILED);
            Iterator iter = this.listeners_.values().iterator();
            while (iter.hasNext()) {
                ProgressListener listener = (ProgressListener)iter.next();
                listener.handleProgressEvent((ProgressEvent)clusterEvent);
            }
            this.progressEvents_.add(clusterEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void checkForLostConnections() {
        Map map = this.individualConfigSetProgressObjects_;
        synchronized (map) {
            Iterator it = this.individualConfigSetProgressObjects_.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                ProgressObjectImpl pobj = (ProgressObjectImpl)entry.getValue();
                if (pobj == null || pobj.getDeploymentStatus() == null || !pobj.getDeploymentStatus().isRunning() || pobj.getFailedConnection() == null) continue;
                ((DeploymentStatusImpl)pobj.getDeploymentStatus()).setState(StateType.FAILED);
                DeploymentStatusImpl failedStatus = new DeploymentStatusImpl(this.cmdType_);
                failedStatus.setMessage(pobj.getFailedConnection().getMessage());
                failedStatus.setState(StateType.FAILED);
                failedStatus.setAction(pobj.getDeploymentStatus().getAction());
                StaticProgressObjectImpl spobj = new StaticProgressObjectImpl(failedStatus);
                this.completedConfigSetDeployments_.add(spobj);
                Map map2 = this.failedConfigSetProgressObjects_;
                synchronized (map2) {
                    this.failedConfigSetProgressObjects_.put(entry.getKey(), spobj);
                }
                this.updateStatus();
                ObjectName source = null;
                try {
                    source = new ObjectName("*:*");
                }
                catch (Exception exc) {
                    // empty catch block
                }
                ExtendedProgressEvent exevent = new ExtendedProgressEvent(source, null, failedStatus, 0L, 0L);
                ClusterTargetModuleIDImpl clustptgid = new ClusterTargetModuleIDImpl((ClusterTargetImpl)entry.getKey(), null);
                ((DeploymentStatusImpl)this.getDeploymentStatus()).setMessage(pobj.getFailedConnection().getMessage());
                Map map3 = this.listeners_;
                synchronized (map3) {
                    ClusterExtendedProgressEvent clusterEvent = new ClusterExtendedProgressEvent(exevent, this.eventCnt_++, entry.getKey().toString(), clustptgid, this.getDeploymentStatus(), StateType.FAILED);
                    Iterator iter = this.listeners_.values().iterator();
                    while (iter.hasNext()) {
                        ProgressListener listener = (ProgressListener)iter.next();
                        listener.handleProgressEvent((ProgressEvent)clusterEvent);
                    }
                    this.progressEvents_.add(clusterEvent);
                }
            }
        }
    }

    public class ConnectionMonitor
    implements Runnable {
        ConnectionMonitor() {
            ThreadPool.getThread().start(this);
        }

        public void run() {
            Thread.currentThread().setName("ClusterProgressObject::ConnectionMonitor");
            try {
                while (ClusterProgressObjectImpl.this.status_.isRunning()) {
                    Thread.sleep(20000L);
                    ClusterProgressObjectImpl.this.checkForLostConnections();
                    Thread.yield();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class ClusterProgressListener
    implements ProgressListener {
        Target tgt_ = null;
        ProgressObject progObj_ = null;
        DeploymentManager depMan_ = null;

        ClusterProgressListener(DeploymentManager depMan, Target tgt, ProgressObject progObj) {
            this.tgt_ = tgt;
            this.progObj_ = progObj;
            this.depMan_ = depMan;
            progObj.addProgressListener((ProgressListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleProgressEvent(ProgressEvent event) {
            ClusterProgressObjectImpl clusterProgressObjectImpl = ClusterProgressObjectImpl.this;
            synchronized (clusterProgressObjectImpl) {
                ExtendedProgressEvent oevent = (ExtendedProgressEvent)event;
                ProprietaryTargetModuleID ptgid = (ProprietaryTargetModuleID)oevent.getTargetModuleID();
                ClusterTargetModuleIDImpl clustptgid = null;
                if (ptgid != null) {
                    clustptgid = new ClusterTargetModuleIDImpl((ClusterTargetImpl)this.tgt_, ptgid.getObjectName());
                }
                DeploymentStatus sts = event.getDeploymentStatus();
                DeploymentStatusImpl clustStatus = (DeploymentStatusImpl)ClusterProgressObjectImpl.this.getDeploymentStatus();
                clustStatus.setMessage(sts.getMessage());
                try {
                    Object object;
                    if (sts != null && (sts.isCompleted() || sts.isFailed())) {
                        ClusterProgressObjectImpl.this.completedConfigSetDeployments_.add(this.progObj_);
                        if (sts.isCompleted()) {
                            if (clustptgid != null) {
                                object = ClusterProgressObjectImpl.this.resultTargetModuleIDs_;
                                synchronized (object) {
                                    ClusterProgressObjectImpl.this.resultTargetModuleIDs_.add(clustptgid);
                                }
                            }
                            object = ClusterProgressObjectImpl.this.completedConfigSetProgressObjects_;
                            synchronized (object) {
                                ClusterProgressObjectImpl.this.completedConfigSetProgressObjects_.put(this.tgt_, this.progObj_);
                            }
                        }
                        if (sts.isFailed()) {
                            object = ClusterProgressObjectImpl.this.failedConfigSetProgressObjects_;
                            synchronized (object) {
                                ClusterProgressObjectImpl.this.failedConfigSetProgressObjects_.put(this.tgt_, this.progObj_);
                            }
                        }
                        ClusterProgressObjectImpl.this.updateStatus();
                    }
                    object = ClusterProgressObjectImpl.this.listeners_;
                    synchronized (object) {
                        DeploymentStatusImpl theStatus = new DeploymentStatusImpl(ClusterProgressObjectImpl.this.cmdType_);
                        theStatus.setMessage(sts.getMessage());
                        theStatus.setState(ClusterProgressObjectImpl.this.status_.getState());
                        theStatus.setDefaultApplicationRestartNeeded(ClusterProgressObjectImpl.this.status_.isDefaultApplicationRestartNeeded());
                        ClusterExtendedProgressEvent clusterEvent = new ClusterExtendedProgressEvent(oevent, ClusterProgressObjectImpl.this.eventCnt_++, this.tgt_.toString(), clustptgid, theStatus, sts.getState());
                        Iterator iter = ClusterProgressObjectImpl.this.listeners_.values().iterator();
                        while (iter.hasNext()) {
                            ProgressListener listener = (ProgressListener)iter.next();
                            listener.handleProgressEvent((ProgressEvent)clusterEvent);
                        }
                        ClusterProgressObjectImpl.this.progressEvents_.add(clusterEvent);
                    }
                    Object var15_17 = null;
                }
                catch (Throwable throwable) {
                    Object var15_18 = null;
                    if (sts != null && (sts.isCompleted() || sts.isFailed())) {
                        this.depMan_.release();
                    }
                    throw throwable;
                }
                if (sts != null && (sts.isCompleted() || sts.isFailed())) {
                    this.depMan_.release();
                }
            }
        }
    }
}

