/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi.factories;

import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.spi.Oc4jDeploymentManager;
import oracle.oc4j.admin.deploy.spi.factories.DeploymentFactoryBase;
import oracle.oc4j.admin.jmx.client.Oc4jDomainFactory;
import oracle.oc4j.admin.jmx.shared.Domain;

public class Oc4jDeploymentFactory
extends DeploymentFactoryBase {
    private static Logger logger_ = TraceLogger.getLogger((Class)Oc4jDeploymentFactory.class);

    public final boolean handlesURI(String uri) {
        if (super.handlesURI(uri)) {
            StringTokenizer strTok = new StringTokenizer(uri, ":");
            strTok.nextToken();
            if (strTok.hasMoreTokens() && "oc4j".equalsIgnoreCase(strTok.nextToken())) {
                return true;
            }
        }
        return false;
    }

    public final String getDisplayName() {
        return "Oracle's J2EE deployment factory for standalone OC4J";
    }

    public final DeploymentManager getDeploymentManager(String uri, String username, String password) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException("This deployment factory cannot handle uri: " + uri);
        }
        if (username == null || password == null) {
            throw new DeploymentManagerCreationException("username and password must be specified");
        }
        try {
            Domain domain = Oc4jDomainFactory.getDomainFromDeployerUrl(uri, username, password);
            return new Oc4jDeploymentManager(domain);
        }
        catch (DeploymentManagerCreationException de) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, de.getMessage(), de);
            }
            throw de;
        }
        catch (Throwable t) {
            if (logger_.isLoggable(Level.SEVERE)) {
                logger_.log(Level.SEVERE, t.getMessage(), t);
            }
            DeploymentManagerCreationException dmce = new DeploymentManagerCreationException(t.getMessage());
            dmce.initCause(t);
            throw dmce;
        }
    }
}

