/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import oracle.oc4j.admin.deploy.model.file.CarFile;
import oracle.oc4j.admin.deploy.model.file.EarFile;
import oracle.oc4j.admin.deploy.model.file.EjbFile;
import oracle.oc4j.admin.deploy.model.file.J2eeFile;
import oracle.oc4j.admin.deploy.model.file.RarFile;
import oracle.oc4j.admin.deploy.model.file.WarFile;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;
import oracle.oc4j.admin.deploy.spi.DeplConfiguration;
import oracle.oc4j.admin.deploy.spi.DeplManager;

public abstract class DeploymentManagerBase
implements DeplManager {
    private Locale currentLocale_ = Locale.getDefault();
    protected DeplConfiguration deplConfiguration_ = null;

    protected DeploymentManagerBase() {
    }

    public abstract Target[] getTargets() throws IllegalStateException;

    public abstract TargetModuleID[] getRunningModules(ModuleType var1, Target[] var2) throws TargetException, IllegalStateException;

    public abstract TargetModuleID[] getNonRunningModules(ModuleType var1, Target[] var2) throws TargetException, IllegalStateException;

    public abstract TargetModuleID[] getAvailableModules(ModuleType var1, Target[] var2) throws TargetException, IllegalStateException;

    public DeploymentConfiguration createConfiguration(DeployableObject dObj) throws InvalidModuleException {
        this.deplConfiguration_ = new DeplConfiguration(dObj, this);
        return this.deplConfiguration_;
    }

    public abstract ProgressObject distribute(Target[] var1, File var2, File var3) throws IllegalStateException;

    public abstract ProgressObject distribute(Target[] var1, InputStream var2, InputStream var3) throws IllegalStateException;

    public abstract ProgressObject start(TargetModuleID[] var1) throws IllegalStateException;

    public abstract ProgressObject stop(TargetModuleID[] var1) throws IllegalStateException;

    public abstract ProgressObject undeploy(TargetModuleID[] var1) throws IllegalStateException;

    public abstract boolean isRedeploySupported();

    public abstract ProgressObject redeploy(TargetModuleID[] var1, File var2, File var3) throws UnsupportedOperationException, IllegalStateException;

    public abstract ProgressObject redeploy(TargetModuleID[] var1, InputStream var2, InputStream var3) throws UnsupportedOperationException, IllegalStateException;

    public abstract void release();

    public Locale[] getSupportedLocales() {
        return Locale.getAvailableLocales();
    }

    public Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public Locale getCurrentLocale() {
        return this.currentLocale_;
    }

    public void setLocale(Locale locale) throws UnsupportedOperationException {
        this.currentLocale_ = locale;
        FormattingResourceBundle.setLocale(locale);
    }

    public boolean isLocaleSupported(Locale locale) {
        if (locale == null) {
            return false;
        }
        Locale[] locs = this.getSupportedLocales();
        for (int i = 0; i < locs.length; ++i) {
            if (!locs[i].equals(locale)) continue;
            return true;
        }
        return false;
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return DConfigBeanVersionType.V1_3;
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType version) {
        return true;
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType version) throws DConfigBeanVersionUnsupportedException {
        throw new UnsupportedOperationException("NOT IMPLEMENTED");
    }

    public boolean isConnected() {
        return false;
    }

    public void saveDeploymentPlan(Hashtable parsedConf, J2eeFile j2eeFile) throws ExtendedRuntimeException {
        File xmlFile = null;
        try {
            Hashtable attributes = (Hashtable)parsedConf.get("attributes");
            String moduleType = (String)attributes.get("moduleType");
            Hashtable docTypes = (Hashtable)parsedConf.get("docTypes");
            Hashtable modules = (Hashtable)parsedConf.get("modules");
            Enumeration moduleUris = modules.keys();
            while (moduleUris.hasMoreElements()) {
                String moduleUri = (String)moduleUris.nextElement();
                String xmlPath = (String)modules.get(moduleUri);
                String docType = (String)docTypes.get(moduleUri);
                xmlFile = new File(xmlPath);
                if (moduleUri.equals(".")) {
                    j2eeFile.includeEntry(DeplConfiguration.ModuleToDepEntry(moduleType), xmlFile);
                    continue;
                }
                File jar = j2eeFile.getEntryAsFile(moduleUri);
                File xml = new File(xmlPath);
                J2eeFile embeddedFile = null;
                if (docType.equals("orion-ejb-jar")) {
                    embeddedFile = new EjbFile(jar);
                } else if (docType.equals("orion-web-app")) {
                    embeddedFile = new WarFile(jar);
                } else if (docType.equals("orion-application-client")) {
                    embeddedFile = new CarFile(jar);
                } else if (docType.equals("connector-factory")) {
                    embeddedFile = new RarFile(jar);
                }
                embeddedFile.includeEntry(DeplConfiguration.DocTypeToDepEntry(docType), xmlFile);
                j2eeFile.updateEntry(moduleUri, jar);
                embeddedFile.close();
            }
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }

    public J2eeFile createTmpArchive(Hashtable parsedConf, InputStream archiveStrm) throws ExtendedRuntimeException {
        J2eeFile ret = null;
        try {
            Hashtable attributes = (Hashtable)parsedConf.get("attributes");
            String moduleType = (String)attributes.get("moduleType");
            if (moduleType.equals(ModuleType.EAR.toString())) {
                ret = EarFile.copy(archiveStrm);
            } else if (moduleType.equals(ModuleType.WAR.toString())) {
                ret = WarFile.copy(archiveStrm);
            } else if (moduleType.equals(ModuleType.EJB.toString())) {
                ret = EjbFile.copy(archiveStrm);
            } else if (moduleType.equals(ModuleType.CAR.toString())) {
                ret = CarFile.copy(archiveStrm);
            } else if (moduleType.equals(ModuleType.RAR.toString())) {
                ret = RarFile.copy(archiveStrm);
            }
            return ret;
        }
        catch (Throwable t) {
            throw new ExtendedRuntimeException(t);
        }
    }
}

