/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.spi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.management.j2ee.Management;
import oracle.ias.opmn.optic.OpmnProcess;
import oracle.ias.opmn.optic.OpmnQuery;
import oracle.ias.opmn.optic.OpticException;
import oracle.j2ee.util.TraceLogger;
import oracle.oc4j.admin.deploy.spi.exceptions.DeploymentRuntimeException;
import oracle.oc4j.admin.deploy.spi.factories.Oc4jDeploymentFactory;
import oracle.oc4j.admin.jmx.client.Oc4jDomainFactory;
import oracle.oc4j.admin.jmx.shared.ClusterDomain;
import oracle.oc4j.admin.jmx.shared.Domain;
import oracle.oc4j.admin.management.mejb.MEjbFactory;

public class ClusterHelper {
    private static Logger logger_ = TraceLogger.getLogger((Class)ClusterHelper.class);
    private static final String query_ = "cluster/dump?type=dms&dmsarg=[nountype=opmn_ias_instance&format=xml]";

    public static Set getConfigSetDeployerURLs(String opmnHost, int opmnPort, String clusterName, boolean secure) throws OpticException {
        HashSet<String> urls = new HashSet<String>();
        HashSet<String> configSets = new HashSet<String>();
        String baseUrl = null;
        baseUrl = secure ? "deployer:oc4j:ormis:opmn://" : "deployer:oc4j:opmn://";
        List procList = OpmnQuery.getProc((String)opmnHost, (int)opmnPort, (String)query_);
        for (int i = 0; i < procList.size(); ++i) {
            String configSetID;
            boolean pre1013;
            OpmnProcess p = (OpmnProcess)procList.get(i);
            if (!p.getType().equalsIgnoreCase("OC4J") || !p.getStatus().equalsIgnoreCase("Alive") || !p.getIasComponentName().equalsIgnoreCase(clusterName)) continue;
            boolean bl = pre1013 = p.getAppList() == null || p.getAppList().size() == 0;
            if (pre1013 && logger_.isLoggable(Level.FINE)) {
                logger_.fine("Found pre 10.1.3 AS instance: " + p);
            }
            if (pre1013 || configSets.contains(configSetID = p.getIasInstanceName() + "_" + p.getProcessTypeName())) continue;
            configSets.add(configSetID);
            String url = baseUrl + opmnHost + ":" + opmnPort + "/" + p.getIasInstanceName() + "/" + p.getProcessTypeName();
            urls.add(url);
            if (!logger_.isLoggable(Level.FINE)) continue;
            logger_.fine("Adding config Set url: " + url);
        }
        return urls;
    }

    public static Set getConfigSetDeployerURLs(String uri) throws OpticException {
        String opmnHost = null;
        int opmnPort = 6003;
        String clusterName = null;
        boolean secure = false;
        StringTokenizer strTok = new StringTokenizer(uri, ":");
        if (strTok.countTokens() < 3) {
            throw new IllegalArgumentException("Invalid deployer url: " + uri);
        }
        strTok.nextToken();
        String type = strTok.nextToken();
        if (!"cluster".equalsIgnoreCase(type)) {
            throw new IllegalArgumentException("Invalid cluster deployer url: " + uri);
        }
        opmnHost = strTok.nextToken();
        if ("rmis".equalsIgnoreCase(opmnHost) || "ormis".equalsIgnoreCase(opmnHost)) {
            secure = true;
            opmnHost = strTok.nextToken();
        } else if ("rmi".equalsIgnoreCase(opmnHost) || "ormi".equalsIgnoreCase(opmnHost)) {
            opmnHost = strTok.nextToken();
        }
        if (!"opmn".equalsIgnoreCase(opmnHost)) {
            throw new IllegalArgumentException("Invalid deployer url: " + uri);
        }
        opmnHost = strTok.nextToken();
        if (opmnHost == null || opmnHost.length() < 2) {
            throw new IllegalArgumentException("Invalid URL: " + uri);
        }
        opmnHost = opmnHost.substring(2);
        if (strTok.countTokens() > 0) {
            String portAndInstance = strTok.nextToken();
            StringTokenizer strTokb = new StringTokenizer(portAndInstance, "/");
            opmnPort = Integer.parseInt(strTokb.nextToken());
            clusterName = strTokb.nextToken();
        } else {
            StringTokenizer strTokb = new StringTokenizer(opmnHost, "/");
            opmnHost = strTokb.nextToken();
            clusterName = strTokb.nextToken();
        }
        if (opmnHost == null || opmnHost.length() == 0) {
            throw new IllegalArgumentException("Missing host parameter in URL: " + uri);
        }
        if (clusterName == null || clusterName.length() == 0) {
            throw new IllegalArgumentException("Missing Cluster Name parameter in URL: " + uri);
        }
        return ClusterHelper.getConfigSetDeployerURLs(opmnHost, opmnPort, clusterName, secure);
    }

    public static ClusterDomain[] getConfigSetClusterDomains(String uri, String username, String password, Locale loc) throws OpticException {
        ClusterDomain[] domains = null;
        Set configSetUrls = ClusterHelper.getConfigSetDeployerURLs(uri);
        domains = new ClusterDomain[configSetUrls.size()];
        Iterator iter = configSetUrls.iterator();
        int cnt = 0;
        while (iter.hasNext()) {
            String configSetDeployerURL = (String)iter.next();
            Domain domain = Oc4jDomainFactory.getDomainFromDeployerUrl(configSetDeployerURL, username, password);
            domain.setLocale(loc);
            domains[cnt++] = (ClusterDomain)((Object)domain);
        }
        return domains;
    }

    public static String getURIHost(String uri) {
        Map uriComponents = ClusterHelper.getDeployerURIComponents(uri);
        return (String)uriComponents.get("host");
    }

    public static Domain getLocalClusterDomain(String uri, String username, String password, Locale loc) {
        String url;
        String localHost = ClusterHelper.getURIHost(uri);
        Set urls = null;
        try {
            urls = ClusterHelper.getConfigSetDeployerURLs(uri);
        }
        catch (OpticException oe) {
            DeploymentRuntimeException de = new DeploymentRuntimeException("Error getting Cluster Config Set URLs for uri: " + uri, oe);
            throw de;
        }
        Iterator iter = urls.iterator();
        while (iter.hasNext()) {
            url = (String)iter.next();
            String host = ClusterHelper.getURIHost(url);
            if (!localHost.equals(host)) continue;
            if (logger_.isLoggable(Level.FINE)) {
                logger_.fine("Trying: " + url);
            }
            Domain dom = Oc4jDomainFactory.getDomainFromDeployerUrl(url, username, password);
            dom.setLocale(loc);
            try {
                Management mejb = MEjbFactory.getManagement(dom);
                mejb.remove();
                return dom;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.FINE)) {
                    logger_.log(Level.FINE, t.getMessage(), t);
                }
                if (!logger_.isLoggable(Level.FINE)) continue;
                logger_.fine(url + " FAILED");
            }
        }
        iter = urls.iterator();
        while (iter.hasNext()) {
            url = (String)iter.next();
            if (logger_.isLoggable(Level.FINE)) {
                logger_.fine("Trying: " + url);
            }
            Domain dom = Oc4jDomainFactory.getDomainFromDeployerUrl(url, username, password);
            dom.setLocale(loc);
            try {
                Management mejb = MEjbFactory.getManagement(dom);
                mejb.remove();
                return dom;
            }
            catch (Throwable t) {
                if (logger_.isLoggable(Level.FINE)) {
                    logger_.log(Level.FINE, t.getMessage(), t);
                }
                if (!logger_.isLoggable(Level.FINE)) continue;
                logger_.fine(url + " FAILED");
            }
        }
        throw new DeploymentRuntimeException("Cannot connect to any of the OC4J process(es) in the cluster");
    }

    public static Management[] getConfigSetManagements(String uri, String username, String password, Locale loc) {
        try {
            ClusterDomain[] domains = ClusterHelper.getConfigSetClusterDomains(uri, username, password, loc);
            Management[] mejbs = new Management[domains.length];
            for (int i = 0; i < domains.length; ++i) {
                mejbs[i] = MEjbFactory.getManagement((Domain)((Object)domains[i]));
            }
            return mejbs;
        }
        catch (Exception e) {
            DeploymentRuntimeException de = new DeploymentRuntimeException(e);
            throw de;
        }
    }

    public static DeploymentManager[] getConfigSetDeploymentManagers(String uri, String username, String password, Locale loc) {
        try {
            Set configSetUrls = ClusterHelper.getConfigSetDeployerURLs(uri);
            Iterator iter = configSetUrls.iterator();
            DeploymentManager[] depMans = new DeploymentManager[configSetUrls.size()];
            int cnt = 0;
            Oc4jDeploymentFactory deploymentManagerfactory = new Oc4jDeploymentFactory();
            while (iter.hasNext()) {
                String configSetUrl = (String)iter.next();
                depMans[cnt] = deploymentManagerfactory.getDeploymentManager(configSetUrl, username, password);
                depMans[cnt].setLocale(loc);
                ++cnt;
            }
            return depMans;
        }
        catch (Exception e) {
            DeploymentRuntimeException de = new DeploymentRuntimeException(e);
            throw de;
        }
    }

    public static DeploymentManager getConfigSetDeploymentManager(String uri, String username, String password, Locale loc) {
        try {
            Oc4jDeploymentFactory deploymentManagerfactory = new Oc4jDeploymentFactory();
            DeploymentManager depMan = deploymentManagerfactory.getDeploymentManager(uri, username, password);
            depMan.setLocale(loc);
            return depMan;
        }
        catch (Exception e) {
            DeploymentRuntimeException de = new DeploymentRuntimeException(e);
            throw de;
        }
    }

    public static Map getDeployerURIComponents(String uri) {
        String opmnHost = null;
        String opmnPort = "6003";
        String oc4jInstance = null;
        String asInstance = null;
        String type = null;
        String protocol = "ormi";
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer strTok = new StringTokenizer(uri, ":");
        if (strTok.countTokens() < 3) {
            throw new IllegalArgumentException("Invalid deployer url: " + uri);
        }
        strTok.nextToken();
        type = strTok.nextToken();
        if ("cluster".equalsIgnoreCase(type)) {
            result.put("type", "cluster");
        }
        if ("oc4j".equalsIgnoreCase(type)) {
            result.put("type", "install");
        }
        if ("rmis".equalsIgnoreCase(opmnHost = strTok.nextToken()) || "ormis".equalsIgnoreCase(opmnHost)) {
            protocol = "ormis";
            opmnHost = strTok.nextToken();
        } else if ("rmi".equalsIgnoreCase(opmnHost) || "ormi".equalsIgnoreCase(opmnHost)) {
            protocol = "ormi";
            opmnHost = strTok.nextToken();
        }
        result.put("protocol", protocol);
        if (!"opmn".equalsIgnoreCase(opmnHost)) {
            if (opmnHost.indexOf("//") == -1) {
                result.put("type", "instance");
                result.put("host", opmnHost);
                if (strTok.countTokens() > 0) {
                    result.put("port", strTok.nextToken());
                }
                return result;
            }
            throw new IllegalArgumentException("Invalid URL: " + uri);
        }
        opmnHost = strTok.nextToken();
        if (opmnHost == null || opmnHost.length() < 2) {
            throw new IllegalArgumentException("Invalid URL: " + uri);
        }
        opmnHost = opmnHost.substring(2);
        if (strTok.countTokens() > 0) {
            String portAndInstance = strTok.nextToken();
            StringTokenizer strTokb = new StringTokenizer(portAndInstance, "/");
            opmnPort = strTokb.nextToken();
            if (strTokb.countTokens() > 1) {
                asInstance = strTokb.nextToken();
                oc4jInstance = strTokb.nextToken();
            } else {
                oc4jInstance = strTokb.nextToken();
            }
        } else {
            StringTokenizer strTokb = new StringTokenizer(opmnHost, "/");
            opmnHost = strTokb.nextToken();
            if (strTokb.countTokens() > 1) {
                asInstance = strTokb.nextToken();
                oc4jInstance = strTokb.nextToken();
            } else {
                oc4jInstance = strTokb.nextToken();
            }
        }
        if (opmnHost == null || opmnHost.length() == 0) {
            throw new IllegalArgumentException("Missing host parameter in URL: " + uri);
        }
        if (oc4jInstance == null || oc4jInstance.length() == 0) {
            throw new IllegalArgumentException("Missing OC4J instance parameter in URL: " + uri);
        }
        result.put("host", opmnHost);
        result.put("port", opmnPort);
        result.put("oc4j_instance", oc4jInstance);
        if (asInstance != null) {
            result.put("as_instance", asInstance);
        }
        return result;
    }

    public static String getDeployerURITargetHost(String uri) {
        Map comps = ClusterHelper.getDeployerURIComponents(uri);
        String type = (String)comps.get("type");
        if ("cluster".equals(type)) {
            throw new IllegalArgumentException("Cluster URI does not specify a single target");
        }
        Domain domain = Oc4jDomainFactory.getDomainFromDeployerUrl(uri, "dummy", "dummy");
        return domain.getHost();
    }

    public static String getInstanceName(String targetName) {
        Map uriMap = ClusterHelper.getDeployerURIComponents(targetName);
        return (String)uriMap.get("as_instance");
    }

    public static String getTargetNameUniqueId(String targetName) {
        Map uriMap = ClusterHelper.getDeployerURIComponents(targetName);
        String as_instance = (String)uriMap.get("as_instance");
        String oc4j_instance = (String)uriMap.get("oc4j_instance");
        return as_instance + '/' + oc4j_instance;
    }
}

