/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import oracle.oc4j.admin.deploy.gui.ViewableJTreeNode;
import oracle.oc4j.admin.deploy.model.file.J2eeFile;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.ContextParamBean;
import oracle.oc4j.admin.deploy.model.xml.EjbRefBean;
import oracle.oc4j.admin.deploy.model.xml.EnvEntryBean;
import oracle.oc4j.admin.deploy.model.xml.ErrorPageBean;
import oracle.oc4j.admin.deploy.model.xml.IconBean;
import oracle.oc4j.admin.deploy.model.xml.LoginConfigBean;
import oracle.oc4j.admin.deploy.model.xml.MessageDestinationRefBean;
import oracle.oc4j.admin.deploy.model.xml.MimeMappingBean;
import oracle.oc4j.admin.deploy.model.xml.ResourceEnvRefBean;
import oracle.oc4j.admin.deploy.model.xml.ResourceRefBean;
import oracle.oc4j.admin.deploy.model.xml.SecurityConstraintBean;
import oracle.oc4j.admin.deploy.model.xml.SecurityRoleBean;
import oracle.oc4j.admin.deploy.model.xml.ServiceRefBean;
import oracle.oc4j.admin.deploy.model.xml.ServletBean;
import oracle.oc4j.admin.deploy.model.xml.ServletMappingBean;
import oracle.oc4j.admin.deploy.model.xml.SessionConfigBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.model.xml.TaglibBean;
import oracle.oc4j.admin.deploy.model.xml.WSStdXml;
import oracle.oc4j.admin.deploy.model.xml.WebBean;
import oracle.oc4j.admin.deploy.model.xml.WebServicesBean;
import oracle.oc4j.admin.deploy.model.xml.WelcomeFileListBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WarModuleBean
extends BeanNode {
    protected WebBean _webBean;

    public WarModuleBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDisplayName() {
        return this.nodeValue("display-name");
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getId() {
        if (this._webBean != null && this._webBean.getId() != null) {
            return this._webBean.getId();
        }
        return "";
    }

    public String getWebUri() {
        if (this._webBean != null) {
            return this._webBean.getWebUri();
        }
        return "";
    }

    public String getContextRoot() {
        if (this._webBean != null) {
            return this._webBean.getContextRoot();
        }
        return "";
    }

    public String getSmallIcon() {
        return this.nodeValue("icon/small-icon");
    }

    public String getLargeIcon() {
        return this.nodeValue("icon/large-icon");
    }

    public boolean isDistributable() {
        Vector v = this.resolveXpath("distributable");
        return v != null;
    }

    public String getWelcomeFileList() {
        return this.allNodesValue("welcome-file-list/welcome-file");
    }

    public void linkWebBean(WebBean webBean) {
        this._webBean = webBean;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "web-app" + ">");
        WarModuleBean.writeAll(this.getChildBean("icon"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("display-name"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("distributable"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("context-param"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("servlet"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("servlet-mapping"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("session-config"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("mime-mapping"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("welcome-file-list"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("error-page"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("taglib"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("service-ref"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("resource-ref"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("resource-env-ref"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("security-constraint"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("login-config"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("security-role"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("env-entry"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("ejb-ref"), out, indentation + "\t");
        WarModuleBean.writeAll(this.getChildBean("message-destination-ref"), out, indentation + "\t");
        out.println(indentation + "</" + "web-app" + ">");
    }

    protected String[] listJTreeChildPaths() {
        return new String[]{"session-config", "login-config", "servlet"};
    }

    protected Collection createSpecialJTreeChildren() {
        WSStdXml webServicesNode;
        Vector<ViewableJTreeNode> vec = new Vector<ViewableJTreeNode>();
        vec.add(new CollectionJTreeNode(this, "context-param", "Context Params", true));
        vec.add(new CollectionJTreeNode(this, "servlet-mapping", "Servlet Mappings", false));
        vec.add(new CollectionJTreeNode(this, "mime-mapping", "Mime Mappings", false));
        vec.add(new CollectionJTreeNode(this, "error-page", "Error Pages", false));
        vec.add(new CollectionJTreeNode(this, "taglib", "Taglibs", false));
        vec.add(new CollectionJTreeNode(this, "ejb-ref", "Ejb Refs", true));
        vec.add(new CollectionJTreeNode(this, "env-entry", "Env Entries", true));
        vec.add(new CollectionJTreeNode(this, "security-constraint", "Security Constraints", true));
        vec.add(new CollectionJTreeNode(this, "security-role", "Security Roles", true));
        vec.add(new CollectionJTreeNode(this, "service-ref", "Service Refs", true));
        vec.add(new CollectionJTreeNode(this, "resource-ref", "Resource Refs", true));
        vec.add(new CollectionJTreeNode(this, "resource-env-ref", "Resource Env Refs", true));
        vec.add(new CollectionJTreeNode(this, "message-destination-ref", "Message Destination Refs", true));
        DDBeanRoot myRoot = this.getRoot();
        DeployableObject myJarFile = myRoot.getDeployableObject();
        if (myJarFile instanceof J2eeFile && (webServicesNode = (WSStdXml)((J2eeFile)myJarFile).getWSStdXml()) != null) {
            WebServicesBean webServicesBean = (WebServicesBean)webServicesNode.getChildBean("/webservices")[0];
            if (webServicesNode != null) {
                vec.add(webServicesBean);
            }
        }
        return vec;
    }

    public String jtreeToolTip() {
        return "Web Module";
    }

    public String toString() {
        String val = this.getDisplayName();
        if (val == null || val.equals("")) {
            val = this.getWebUri();
        }
        return val;
    }

    private void init(Node rootNode) {
        this.setXpath("web-app");
        Vector<IconBean> icon = new Vector<IconBean>(1);
        Vector<IconBean> displayName = new Vector<IconBean>(1);
        Vector<IconBean> description = new Vector<IconBean>(1);
        Vector<IconBean> distributable = new Vector<IconBean>(1);
        Vector<IconBean> contextParams = new Vector<IconBean>();
        Vector<IconBean> servlets = new Vector<IconBean>();
        Vector<IconBean> servletMappings = new Vector<IconBean>();
        Vector<IconBean> sessionConfig = new Vector<IconBean>();
        Vector<IconBean> mimeMapping = new Vector<IconBean>();
        Vector<IconBean> welcomeFileList = new Vector<IconBean>();
        Vector<IconBean> errorPages = new Vector<IconBean>();
        Vector<IconBean> taglibs = new Vector<IconBean>();
        Vector<IconBean> resourceRefs = new Vector<IconBean>();
        Vector<IconBean> resourceEnvRefs = new Vector<IconBean>();
        Vector<IconBean> securityConstraints = new Vector<IconBean>();
        Vector<IconBean> loginConfig = new Vector<IconBean>();
        Vector<IconBean> serviceRefs = new Vector<IconBean>();
        Vector<IconBean> securityRoles = new Vector<IconBean>();
        Vector<IconBean> envEntries = new Vector<IconBean>();
        Vector<IconBean> ejbRefs = new Vector<IconBean>();
        Vector<IconBean> messageDestinationRefs = new Vector<IconBean>();
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("icon")) {
                bean = new IconBean(node, this);
                icon.add((IconBean)bean);
            } else if (name.equals("display-name")) {
                bean = new StringBean(node, this, "display-name");
                displayName.add((IconBean)bean);
            } else if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((IconBean)bean);
            } else if (name.equals("distributable")) {
                bean = new StringBean(node, this, "distributable");
                distributable.add((IconBean)bean);
            } else if (name.equals("context-param")) {
                bean = new ContextParamBean(node, this);
                contextParams.add((IconBean)bean);
            } else if (name.equals("servlet")) {
                bean = new ServletBean(node, this);
                servlets.add((IconBean)bean);
            } else if (name.equals("servlet-mapping")) {
                bean = new ServletMappingBean(node, this);
                servletMappings.add((IconBean)bean);
            } else if (name.equals("session-config")) {
                bean = new SessionConfigBean(node, this);
                sessionConfig.add((IconBean)bean);
            } else if (name.equals("mime-mapping")) {
                bean = new MimeMappingBean(node, this);
                mimeMapping.add((IconBean)bean);
            } else if (name.equals("welcome-file-list")) {
                bean = new WelcomeFileListBean(node, this);
                welcomeFileList.add((IconBean)bean);
            } else if (name.equals("error-page")) {
                bean = new ErrorPageBean(node, this);
                errorPages.add((IconBean)bean);
            } else if (name.equals("taglib")) {
                bean = new TaglibBean(node, this);
                taglibs.add((IconBean)bean);
            } else if (name.equals("resource-ref")) {
                bean = new ResourceRefBean(node, this);
                resourceRefs.add((IconBean)bean);
            } else if (name.equals("resource-env-ref")) {
                bean = new ResourceEnvRefBean(node, this);
                resourceEnvRefs.add((IconBean)bean);
            } else if (name.equals("security-constraint")) {
                bean = new SecurityConstraintBean(node, this);
                securityConstraints.add((IconBean)bean);
            } else if (name.equals("login-config")) {
                bean = new LoginConfigBean(node, this);
                loginConfig.add((IconBean)bean);
            }
            if (name.equals("service-ref")) {
                bean = new ServiceRefBean(node, this);
                serviceRefs.add((IconBean)bean);
                continue;
            }
            if (name.equals("security-role")) {
                bean = new SecurityRoleBean(node, this);
                securityRoles.add((IconBean)bean);
                continue;
            }
            if (name.equals("env-entry")) {
                bean = new EnvEntryBean(node, this);
                envEntries.add((IconBean)bean);
                continue;
            }
            if (name.equals("ejb-ref")) {
                bean = new EjbRefBean(node, this);
                ejbRefs.add((IconBean)bean);
                continue;
            }
            if (!name.equals("message-destination-ref")) continue;
            bean = new MessageDestinationRefBean(node, this);
            messageDestinationRefs.add((IconBean)bean);
        }
        this.recordXpathForBeans("icon", icon);
        this.recordXpathForBeans("display-name", displayName);
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("distributable", distributable);
        this.recordXpathForBeans("context-param", contextParams);
        this.recordXpathForBeans("servlet", servlets);
        this.recordXpathForBeans("servlet-mapping", servletMappings);
        this.recordXpathForBeans("session-config", sessionConfig);
        this.recordXpathForBeans("mime-mapping", mimeMapping);
        this.recordXpathForBeans("welcome-file-list", welcomeFileList);
        this.recordXpathForBeans("error-page", errorPages);
        this.recordXpathForBeans("taglib", taglibs);
        this.recordXpathForBeans("resource-ref", resourceRefs);
        this.recordXpathForBeans("resource-env-ref", resourceEnvRefs);
        this.recordXpathForBeans("security-constraint", securityConstraints);
        this.recordXpathForBeans("login-config", loginConfig);
        this.recordXpathForBeans("service-ref", serviceRefs);
        this.recordXpathForBeans("security-role", securityRoles);
        this.recordXpathForBeans("env-entry", envEntries);
        this.recordXpathForBeans("ejb-ref", ejbRefs);
        this.recordXpathForBeans("message-destination-ref", messageDestinationRefs);
    }
}

