/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.IconBean;
import oracle.oc4j.admin.deploy.model.xml.InitParamBean;
import oracle.oc4j.admin.deploy.model.xml.SecurityRoleRefBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServletBean
extends BeanNode {
    public ServletBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getSmallIcon() {
        return this.nodeValue("icon/small-icon");
    }

    public String getLargeIcon() {
        return this.nodeValue("icon/large-icon");
    }

    public String getServletName() {
        return this.nodeValue("servlet-name");
    }

    public String getDisplayName() {
        return this.nodeValue("display-name");
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getServletClass() {
        return this.nodeValue("servlet-class");
    }

    public String getJspFile() {
        return this.nodeValue("jsp-file");
    }

    public String getLoadOnStartup() {
        return this.nodeValue("load-on-startup");
    }

    public String jtreeToolTip() {
        return "Servlet";
    }

    public String toString() {
        String val = this.getDisplayName();
        if (val == null || val.equals("")) {
            val = this.getServletName();
        }
        return val;
    }

    protected Collection createSpecialJTreeChildren() {
        Vector<CollectionJTreeNode> vec = new Vector<CollectionJTreeNode>();
        vec.add(new CollectionJTreeNode(this, "init-param", "Init Params", false));
        vec.add(new CollectionJTreeNode(this, "security-role-ref", "Security Role Refs", true));
        return vec;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "servlet" + ">");
        ServletBean.writeAll(this.getChildBean("icon"), out, indentation + "\t");
        ServletBean.writeAll(this.getChildBean("servlet-name"), out, indentation + "\t");
        ServletBean.writeAll(this.getChildBean("display-name"), out, indentation + "\t");
        ServletBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        ServletBean.writeAll(this.getChildBean("servlet-class"), out, indentation + "\t");
        ServletBean.writeAll(this.getChildBean("jsp-file"), out, indentation + "\t");
        ServletBean.writeAll(this.getChildBean("init-param"), out, indentation + "\t");
        ServletBean.writeAll(this.getChildBean("load-on-startup"), out, indentation + "\t");
        ServletBean.writeAll(this.getChildBean("security-role-ref"), out, indentation + "\t");
        out.println(indentation + "</" + "servlet" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("servlet");
        Vector<IconBean> icon = new Vector<IconBean>(1);
        Vector<IconBean> servletName = new Vector<IconBean>(1);
        Vector<IconBean> displayName = new Vector<IconBean>(1);
        Vector<IconBean> description = new Vector<IconBean>(1);
        Vector<IconBean> servletClass = new Vector<IconBean>(1);
        Vector<IconBean> jspFile = new Vector<IconBean>(1);
        Vector<IconBean> initParams = new Vector<IconBean>();
        Vector<IconBean> loadOnStartup = new Vector<IconBean>(1);
        Vector<IconBean> securityRoleRefs = new Vector<IconBean>();
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("icon")) {
                bean = new IconBean(node, this);
                icon.add((IconBean)bean);
                continue;
            }
            if (name.equals("servlet-name")) {
                bean = new StringBean(node, this, "servlet-name");
                servletName.add((IconBean)bean);
                continue;
            }
            if (name.equals("display-name")) {
                bean = new StringBean(node, this, "display-name");
                displayName.add((IconBean)bean);
                continue;
            }
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((IconBean)bean);
                continue;
            }
            if (name.equals("servlet-class")) {
                bean = new StringBean(node, this, "servlet-class");
                servletClass.add((IconBean)bean);
                continue;
            }
            if (name.equals("jsp-file")) {
                bean = new StringBean(node, this, "jsp-file");
                jspFile.add((IconBean)bean);
                continue;
            }
            if (name.equals("init-param")) {
                bean = new InitParamBean(node, this);
                initParams.add((IconBean)bean);
                continue;
            }
            if (name.equals("load-on-startup")) {
                bean = new StringBean(node, this, "load-on-startup");
                loadOnStartup.add((IconBean)bean);
                continue;
            }
            if (!name.equals("security-role-ref")) continue;
            bean = new SecurityRoleRefBean(node, this);
            securityRoleRefs.add((IconBean)bean);
        }
        this.recordXpathForBeans("icon", icon);
        this.recordXpathForBeans("servlet-name", servletName);
        this.recordXpathForBeans("display-name", displayName);
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("servlet-class", servletClass);
        this.recordXpathForBeans("jsp-file", jspFile);
        this.recordXpathForBeans("init-param", initParams);
        this.recordXpathForBeans("load-on-startup", description);
        this.recordXpathForBeans("security-role-ref", securityRoleRefs);
    }
}

