/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.MethodBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MethodPermissionBean
extends BeanNode {
    public MethodPermissionBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    protected Collection createSpecialJTreeChildren() {
        Vector<CollectionJTreeNode> vec = new Vector<CollectionJTreeNode>();
        String childPath = "role-name";
        CollectionJTreeNode node = new CollectionJTreeNode(this, childPath, "Role Names", false);
        vec.add(node);
        childPath = "method";
        node = new CollectionJTreeNode(this, childPath, "Methods", true);
        vec.add(node);
        return vec;
    }

    public String toString() {
        return "Method Permission";
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "method-permission" + ">");
        MethodPermissionBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        MethodPermissionBean.writeAll(this.getChildBean("role-name"), out, indentation + "\t");
        MethodPermissionBean.writeAll(this.getChildBean("method"), out, indentation + "\t");
        out.println(indentation + "</" + "method-permission" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("method-permission");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> roleNames = new Vector<StringBean>();
        Vector<StringBean> methods = new Vector<StringBean>();
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((StringBean)bean);
            }
            if (name.equals("role-name")) {
                bean = new StringBean(node, this, "role-name");
                roleNames.add((StringBean)bean);
            }
            if (!name.equals("method")) continue;
            bean = new MethodBean(node, this);
            methods.add((StringBean)bean);
        }
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("role-name", roleNames);
        this.recordXpathForBeans("method", methods);
    }
}

