/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IconBean
extends BeanNode {
    public IconBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "icon" + ">");
        IconBean.writeAll(this.getChildBean("small-icon"), out, indentation + "\t");
        IconBean.writeAll(this.getChildBean("large-icon"), out, indentation + "\t");
        out.println(indentation + "</" + "icon" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("icon");
        Vector<StringBean> smallIcon = new Vector<StringBean>();
        Vector<StringBean> largeIcon = new Vector<StringBean>();
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("small-icon")) {
                bean = new StringBean(node, this, "small-icon");
                smallIcon.add(bean);
            }
            if (!name.equals("large-icon")) continue;
            bean = new StringBean(node, this, "large-icon");
            largeIcon.add(bean);
        }
        this.recordXpathForBeans("small-icon", smallIcon);
        this.recordXpathForBeans("large-icon", largeIcon);
    }
}

