/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ConfigPropertyBean
extends BeanNode {
    public ConfigPropertyBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getConfigPropertyName() {
        return this.nodeValue("config-property-name");
    }

    public String getConfigPropertyType() {
        return this.nodeValue("config-property-type");
    }

    public String getConfigPropertyValue() {
        return this.nodeValue("config-property-value");
    }

    public String toString() {
        return this.getConfigPropertyName();
    }

    protected boolean leaf() {
        return true;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "config-property" + ">");
        ConfigPropertyBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        ConfigPropertyBean.writeAll(this.getChildBean("config-property-name"), out, indentation + "\t");
        ConfigPropertyBean.writeAll(this.getChildBean("config-property-type"), out, indentation + "\t");
        ConfigPropertyBean.writeAll(this.getChildBean("config-property-value"), out, indentation + "\t");
        out.println(indentation + "</" + "config-property" + ">");
    }

    private void init(Node rootNode) {
        this.setXpath("config-property");
        Vector<StringBean> description = new Vector<StringBean>(1);
        Vector<StringBean> configPropertyName = new Vector<StringBean>(1);
        Vector<StringBean> configPropertyType = new Vector<StringBean>(1);
        Vector<StringBean> configPropertyValue = new Vector<StringBean>(1);
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            StringBean bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add(bean);
                continue;
            }
            if (name.equals("config-property-name")) {
                bean = new StringBean(node, this, "config-property-name");
                configPropertyName.add(bean);
                continue;
            }
            if (name.equals("config-property-type")) {
                bean = new StringBean(node, this, "config-property-type");
                configPropertyType.add(bean);
                continue;
            }
            if (!name.equals("config-property-value")) continue;
            bean = new StringBean(node, this, "config-property-value");
            configPropertyValue.add(bean);
        }
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("config-property-name", configPropertyName);
        this.recordXpathForBeans("config-property-type", configPropertyType);
        this.recordXpathForBeans("config-property-value", configPropertyValue);
    }
}

