/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.model.xml;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.CollectionJTreeNode;
import oracle.oc4j.admin.deploy.model.xml.EjbRefBean;
import oracle.oc4j.admin.deploy.model.xml.EnvEntryBean;
import oracle.oc4j.admin.deploy.model.xml.IconBean;
import oracle.oc4j.admin.deploy.model.xml.MessageDestinationRefBean;
import oracle.oc4j.admin.deploy.model.xml.ResourceEnvRefBean;
import oracle.oc4j.admin.deploy.model.xml.ResourceRefBean;
import oracle.oc4j.admin.deploy.model.xml.ServiceRefBean;
import oracle.oc4j.admin.deploy.model.xml.StringBean;
import oracle.oc4j.admin.deploy.shared.exceptions.ExtendedRuntimeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CarModuleBean
extends BeanNode {
    protected String _carUri;

    public CarModuleBean(Node node, DDBean parent) {
        super(node, parent);
        this.init(node);
    }

    public String getDisplayName() {
        return this.nodeValue("display-name");
    }

    public String getDescription() {
        return this.nodeValue("description");
    }

    public String getSmallIcon() {
        return this.nodeValue("icon/small-icon");
    }

    public String getLargeIcon() {
        return this.nodeValue("icon/large-icon");
    }

    public String getURI() {
        return this._carUri;
    }

    public void setURI(String carUri) {
        this._carUri = carUri;
    }

    public void writeXML(PrintWriter out, String indentation) throws ExtendedRuntimeException {
        out.println(indentation + "<" + "application-client" + ">");
        CarModuleBean.writeAll(this.getChildBean("description"), out, indentation + "\t");
        CarModuleBean.writeAll(this.getChildBean("display-name"), out, indentation + "\t");
        CarModuleBean.writeAll(this.getChildBean("small-icon"), out, indentation + "\t");
        CarModuleBean.writeAll(this.getChildBean("large-icon"), out, indentation + "\t");
        CarModuleBean.writeAll(this.getChildBean("env-entry"), out, indentation + "\t");
        CarModuleBean.writeAll(this.getChildBean("ejb-ref"), out, indentation + "\t");
        CarModuleBean.writeAll(this.getChildBean("service-ref"), out, indentation + "\t");
        CarModuleBean.writeAll(this.getChildBean("resource-ref"), out, indentation + "\t");
        CarModuleBean.writeAll(this.getChildBean("resource-env-ref"), out, indentation + "\t");
        CarModuleBean.writeAll(this.getChildBean("message-destination-ref"), out, indentation + "\t");
        out.println(indentation + "</" + "application-client" + ">");
    }

    protected Collection createSpecialJTreeChildren() {
        Vector<CollectionJTreeNode> vec = new Vector<CollectionJTreeNode>();
        vec.add(new CollectionJTreeNode(this, "env-entry", "Env Entries", true));
        vec.add(new CollectionJTreeNode(this, "ejb-ref", "Ejb Refs", true));
        vec.add(new CollectionJTreeNode(this, "service-ref", "Service Refs", true));
        vec.add(new CollectionJTreeNode(this, "resource-ref", "Resource Refs", true));
        vec.add(new CollectionJTreeNode(this, "resource-env-ref", "Resource Env Refs", true));
        vec.add(new CollectionJTreeNode(this, "message-destination-ref", "Message Destination Refs", true));
        return vec;
    }

    public String jtreeToolTip() {
        return "CAR Module";
    }

    public String toString() {
        String val = this.getDisplayName();
        if (val == null || val.equals("")) {
            val = this.getURI();
        }
        return val;
    }

    private void init(Node rootNode) {
        this.setXpath("application-client");
        Vector<IconBean> icon = new Vector<IconBean>(1);
        Vector<IconBean> displayName = new Vector<IconBean>(1);
        Vector<IconBean> description = new Vector<IconBean>(1);
        Vector<IconBean> envEntries = new Vector<IconBean>();
        Vector<IconBean> ejbRefs = new Vector<IconBean>();
        Vector<IconBean> serviceRefs = new Vector<IconBean>();
        Vector<IconBean> resourceRefs = new Vector<IconBean>();
        Vector<IconBean> resourceEnvRefs = new Vector<IconBean>();
        Vector<IconBean> messageDestinationRefs = new Vector<IconBean>();
        NodeList nodes = rootNode.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            BeanNode bean;
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.equals("icon")) {
                bean = new IconBean(node, this);
                icon.add((IconBean)bean);
            } else if (name.equals("display-name")) {
                bean = new StringBean(node, this, "display-name");
                displayName.add((IconBean)bean);
            } else if (name.equals("description")) {
                bean = new StringBean(node, this, "description");
                description.add((IconBean)bean);
            } else if (name.equals("env-entry")) {
                bean = new EnvEntryBean(node, this);
                envEntries.add((IconBean)bean);
            } else if (name.equals("ejb-ref")) {
                bean = new EjbRefBean(node, this);
                ejbRefs.add((IconBean)bean);
            }
            if (name.equals("service-ref")) {
                bean = new ServiceRefBean(node, this);
                serviceRefs.add((IconBean)bean);
                continue;
            }
            if (name.equals("resource-ref")) {
                bean = new ResourceRefBean(node, this);
                resourceRefs.add((IconBean)bean);
                continue;
            }
            if (name.equals("resource-env-ref")) {
                bean = new ResourceEnvRefBean(node, this);
                resourceEnvRefs.add((IconBean)bean);
                continue;
            }
            if (!name.equals("message-destination-ref")) continue;
            bean = new MessageDestinationRefBean(node, this);
            messageDestinationRefs.add((IconBean)bean);
        }
        this.recordXpathForBeans("display-name", displayName);
        this.recordXpathForBeans("description", description);
        this.recordXpathForBeans("icon", icon);
        this.recordXpathForBeans("env-entry", envEntries);
        this.recordXpathForBeans("ejb-ref", ejbRefs);
        this.recordXpathForBeans("service-ref", serviceRefs);
        this.recordXpathForBeans("resource-ref", resourceRefs);
        this.recordXpathForBeans("resource-env-ref", resourceEnvRefs);
        this.recordXpathForBeans("message-destination-ref", messageDestinationRefs);
    }
}

