/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import oracle.oc4j.admin.deploy.gui.DataElement;
import oracle.oc4j.admin.deploy.gui.DataElementPane;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.DynamicParentNode;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.SelfDescribingObject;

public class ElementSelectionPane
extends JPanel
implements ActionListener {
    private DynamicParentNode _dynamicNode;
    private JButton _addButton;
    private JButton _removeButton;
    private JComboBox _combo;
    private Hashtable _dataPanels = new Hashtable();
    private JPanel _elementsPanel;
    private static final String EMPTY_PANEL = "Empty Panel";
    private static String ADD_STRING = "ADD";
    private static String REMOVE_STRING = "REMOVE";

    public ElementSelectionPane(DynamicParentNode dpnode, String add, String remove) {
        this._dynamicNode = dpnode;
        Vector sdObjs = this._dynamicNode.sdChildren();
        this.setLayout(new BoxLayout(this, 1));
        this._combo = new JComboBox(sdObjs);
        this._combo.addActionListener(this);
        this._combo.setBackground(Deployer.TreeBackgroundColor);
        this._combo.setOpaque(true);
        this._combo.setFont(GuiUtil.getRegularFont());
        this.add(this._combo);
        this._addButton = new JButton(add);
        this._addButton.setActionCommand(ADD_STRING);
        this._addButton.addActionListener(this);
        this._removeButton = new JButton(remove);
        this._removeButton.setActionCommand(REMOVE_STRING);
        this._removeButton.addActionListener(this);
        this._elementsPanel = new JPanel();
        CardLayout cl = new CardLayout();
        this._elementsPanel.setLayout(cl);
        DataElement[] deElems = this._dynamicNode.childComponents();
        DataElementPane panel = new DataElementPane(deElems);
        this._elementsPanel.add((Component)panel, EMPTY_PANEL);
        if (sdObjs.size() > 0) {
            deElems = ((SelfDescribingObject)sdObjs.elementAt(0)).componentElements();
            panel = new DataElementPane(deElems);
            this._dataPanels.put(sdObjs.elementAt(0), panel);
            this._elementsPanel.add((Component)panel, sdObjs.elementAt(0).toString());
            cl.show(this._elementsPanel, sdObjs.elementAt(0).toString());
        } else {
            this._removeButton.setEnabled(false);
            this._combo.setEnabled(false);
            cl.show(this._elementsPanel, EMPTY_PANEL);
        }
        this.add(this._elementsPanel);
        this.add(Box.createVerticalStrut(5));
        JPanel buttonPane = new JPanel();
        buttonPane.setOpaque(false);
        buttonPane.add(this._addButton);
        buttonPane.add(Box.createHorizontalStrut(80));
        buttonPane.add(this._removeButton);
        this.add(buttonPane);
    }

    public void actionPerformed(ActionEvent event) {
        String actionCommand = event.getActionCommand();
        Object src = event.getSource();
        SelfDescribingObject node = null;
        if (src instanceof JComboBox) {
            node = (SelfDescribingObject)this._combo.getSelectedItem();
            if (node == null) {
                ((CardLayout)this._elementsPanel.getLayout()).show(this._elementsPanel, EMPTY_PANEL);
                return;
            }
            DataElementPane dataPanel = (DataElementPane)this._dataPanels.get(node);
            if (dataPanel == null) {
                dataPanel = new DataElementPane(node.componentElements());
                this._dataPanels.put(node, dataPanel);
                this._elementsPanel.add((Component)dataPanel, node.toString());
            }
            ((CardLayout)this._elementsPanel.getLayout()).show(this._elementsPanel, node.toString());
            return;
        }
        if (actionCommand.equals(ADD_STRING)) {
            node = this._dynamicNode.promptForNewChild();
            if (node == null) {
                return;
            }
            this._combo.insertItemAt(node, 0);
            this._combo.setSelectedIndex(0);
            this._removeButton.setEnabled(true);
            this._combo.setEnabled(true);
        } else {
            node = (SelfDescribingObject)this._combo.getSelectedItem();
            if (this._dynamicNode.promptForRemoveChild(node)) {
                this._combo.removeItem(node);
                if (this._combo.getItemCount() == 0) {
                    this._removeButton.setEnabled(false);
                    this._combo.setEnabled(false);
                } else {
                    this._combo.setSelectedIndex(0);
                }
            }
        }
        this._addButton.setEnabled(this._dynamicNode.canAddMoreChildren());
    }
}

