/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.enterprise.deploy.model.DDBean;
import javax.enterprise.deploy.model.DDBeanRoot;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.model.J2eeApplicationObject;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DConfigBean;
import javax.enterprise.deploy.spi.DConfigBeanRoot;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.ConfigurationException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import oracle.oc4j.admin.deploy.gui.AppInfoManager;
import oracle.oc4j.admin.deploy.gui.ClusterJTree;
import oracle.oc4j.admin.deploy.gui.ConfigJTree;
import oracle.oc4j.admin.deploy.gui.ConfirmDeployDialog;
import oracle.oc4j.admin.deploy.gui.ConfirmRedeployDialog;
import oracle.oc4j.admin.deploy.gui.ConnectDialog;
import oracle.oc4j.admin.deploy.gui.Controller;
import oracle.oc4j.admin.deploy.gui.ControllerListener;
import oracle.oc4j.admin.deploy.gui.DeployOptionsDialog;
import oracle.oc4j.admin.deploy.gui.DeployTargetInfo;
import oracle.oc4j.admin.deploy.gui.DeployTargetNode;
import oracle.oc4j.admin.deploy.gui.Deployer;
import oracle.oc4j.admin.deploy.gui.DialogListener;
import oracle.oc4j.admin.deploy.gui.GuiUtil;
import oracle.oc4j.admin.deploy.gui.J2eeArchiveFileFilter;
import oracle.oc4j.admin.deploy.gui.OperationStatus;
import oracle.oc4j.admin.deploy.gui.OperationStatusDialog;
import oracle.oc4j.admin.deploy.gui.ProgressDialog;
import oracle.oc4j.admin.deploy.gui.TargetModuleNode;
import oracle.oc4j.admin.deploy.gui.TargetSelectionListener;
import oracle.oc4j.admin.deploy.gui.TargetsDialog;
import oracle.oc4j.admin.deploy.gui.TextDialog;
import oracle.oc4j.admin.deploy.gui.UploadSharedLibOptionsDialog;
import oracle.oc4j.admin.deploy.gui.ViewableJTree;
import oracle.oc4j.admin.deploy.model.file.CarFile;
import oracle.oc4j.admin.deploy.model.file.EarFile;
import oracle.oc4j.admin.deploy.model.file.EjbFile;
import oracle.oc4j.admin.deploy.model.file.J2eeFile;
import oracle.oc4j.admin.deploy.model.file.RarFile;
import oracle.oc4j.admin.deploy.model.file.WarFile;
import oracle.oc4j.admin.deploy.model.xml.BeanNode;
import oracle.oc4j.admin.deploy.model.xml.BeanRootNode;
import oracle.oc4j.admin.deploy.spi.ClusterHelper;
import oracle.oc4j.admin.deploy.spi.ConnectedDeploymentManagerBase;
import oracle.oc4j.admin.deploy.spi.ProprietaryConnectedDeploymentManager;
import oracle.oc4j.admin.deploy.spi.ProprietaryTarget;
import oracle.oc4j.admin.deploy.spi.ProprietaryTargetModuleID;
import oracle.oc4j.admin.deploy.spi.exceptions.ExtendedDeploymentManagerCreationException;
import oracle.oc4j.admin.deploy.spi.status.ClusterExtendedProgressEvent;
import oracle.oc4j.admin.deploy.spi.xml.AppType;
import oracle.oc4j.admin.deploy.spi.xml.ConfigBeanRootNode;
import oracle.oc4j.admin.deploy.spi.xml.TabFilterOutputStream;
import oracle.oc4j.admin.deploy.spi.xml.WarDepXml;
import oracle.oc4j.admin.jmx.shared.util.JarTool;

public class ControllerImpl
implements Controller {
    protected boolean _connected;
    protected String _connectedHost;
    protected File _archiveFile;
    protected J2eeFile _j2eeArchiveFile;
    protected ViewableJTree _ddbeanTree;
    protected ViewableJTree _managementTree;
    protected DeployTargetInfo _deployTargetInfo;
    protected DeploymentManager _deployManager;
    protected DeploymentConfiguration _deployConfig;
    protected JFrame _parent = null;
    protected ControllerListener _controllerListener = null;
    protected DConfigBeanRoot _configRoot = null;
    protected DeployTargetNode _selectedTarget = null;
    protected Vector _targetListeners = new Vector();
    private static String _singletonLock = "Lock";
    private static ControllerImpl _singletonController = null;

    public ControllerImpl(Deployer parent) {
        this._parent = parent;
        this._controllerListener = parent;
    }

    public static Controller initSingleton(Deployer parent) {
        _singletonController = new ControllerImpl(parent);
        return _singletonController;
    }

    public static Controller getSingletonController() {
        return _singletonController;
    }

    public JFrame getParent() {
        return this._parent;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            this.connect();
        } else {
            this.disconnect(true);
        }
    }

    public void deploy() {
        DeployThread dt = new DeployThread(this._archiveFile);
        dt.start();
    }

    public void start(TargetModuleNode node) {
        OperationThread ut = new OperationThread(node, 0);
        ut.start();
    }

    public void stop(TargetModuleNode node) {
        OperationThread ut = new OperationThread(node, 1);
        ut.start();
    }

    public void undeploy(TargetModuleNode node) {
        String title = "Confirm Undeploy";
        String message = "Undeploy application " + node.getName() + "?";
        if (GuiUtil.showYesNoDialog("Confirm Undeploy", message) != 0) {
            return;
        }
        OperationThread ut = new OperationThread(node, 2);
        ut.start();
    }

    public boolean isDeployTargetSelected() {
        return this._selectedTarget != null;
    }

    public Target[] getSelectedTargets() {
        return this._selectedTarget.returnTargets();
    }

    public void addTargetSelectionListener(TargetSelectionListener lsnr) {
        this._targetListeners.add(lsnr);
        if (this._selectedTarget != null) {
            lsnr.targetSelected(this._selectedTarget);
        }
    }

    public void selectTarget(DeployTargetNode node) {
        if (this._selectedTarget != null && GuiUtil.showYesNoDialog("Confirm Target", "Replace current target " + this._selectedTarget.targetName() + " with " + node.targetName() + "?") == 1) {
            return;
        }
        if (this._selectedTarget != null) {
            this._selectedTarget.targeted(false);
        }
        node.targeted(true);
        this._selectedTarget = node;
        if (this._configRoot != null) {
            try {
                ((ConfigBeanRootNode)this._configRoot).setConfigTarget(this._selectedTarget.returnTargets()[0]);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        Enumeration e = this._targetListeners.elements();
        while (e.hasMoreElements()) {
            ((TargetSelectionListener)e.nextElement()).targetSelected(this._selectedTarget);
        }
    }

    public void deselectAllTargets() {
        if (this.isDeployTargetSelected()) {
            this.deselectTarget(this._selectedTarget);
        }
    }

    public void deselectTarget(DeployTargetNode node) {
        node.targeted(false);
        this._selectedTarget = null;
        Enumeration e = this._targetListeners.elements();
        while (e.hasMoreElements()) {
            ((TargetSelectionListener)e.nextElement()).targetDeselected(node);
        }
    }

    public boolean promptUserForDeployTarget() {
        DeployTargetNode[] targets = this._deployTargetInfo.getAllPossibleTargets();
        TargetsDialog targetsDialog = new TargetsDialog(this._parent, targets);
        if (!targetsDialog.showDialog()) {
            return false;
        }
        this.selectTarget(targetsDialog.getTarget());
        return true;
    }

    public void redeploy() {
        new Thread(){

            public void run() {
                String appName = (String)AppInfoManager.getStoredObject(ControllerImpl.this._archiveFile);
                DeployThread dt = new DeployThread(appName, ControllerImpl.this._archiveFile);
                dt.run();
            }
        }.start();
    }

    public void redeploy(TargetModuleNode node) {
        ConfirmRedeployDialog crDlg;
        File archive = (File)AppInfoManager.getStoredObject(node.getName());
        if (archive == null && this._archiveFile != null) {
            String title = "Specify Redeploy Archive";
            String message = "Do you want to use the currently open archive for the redeploy?";
            if (GuiUtil.showYesNoDialog("Specify Redeploy Archive", message) == 0) {
                archive = this._archiveFile;
            }
        }
        if (!(crDlg = new ConfirmRedeployDialog(this._parent, node.getName(), archive, true)).confirmRedeployment()) {
            return;
        }
        DeployThread dt = new DeployThread(node.getName(), crDlg.getArchiveFile());
        dt.start();
    }

    public void connect() {
        this.connect(null, false);
    }

    public void connect(String dlgTitle, boolean synchronous) {
        if (this._connected) {
            throw new IllegalStateException("Connect may not be called when already connected");
        }
        ConnectDialog dlg = new ConnectDialog(this._parent, dlgTitle);
        if (!dlg.showDialog()) {
            return;
        }
        boolean cluster = dlg.isClusterConnection();
        boolean opmn = dlg.isOpmnManaged();
        String oc4j = dlg.getOc4j();
        String host = dlg.getHost();
        int port = dlg.getPort();
        String user = dlg.getUsername();
        String pwd = dlg.getPassword();
        boolean ssl = dlg.isSsl();
        ConnectThread ct = new ConnectThread(cluster, opmn, oc4j, host, port, user, pwd, ssl);
        ct.showDialog();
        ct.start();
        if (synchronous) {
            ct.waitTilFinished();
        }
    }

    protected boolean connectForDeploy() {
        if (!this._connected) {
            this.connect("Enter login info for J2EE platform to deploy to:", true);
            if (!this._connected) {
                GuiUtil.errDialog("Cannot Deploy - not connected to server");
                return false;
            }
        }
        if (!this.isDeployTargetSelected()) {
            return this.promptUserForDeployTarget();
        }
        return true;
    }

    public void disconnect() {
        this.disconnect(true);
    }

    public void disconnect(boolean confirm) {
        if (!this._connected) {
            throw new IllegalStateException("Disonnect may not be called when not connected");
        }
        if (confirm) {
            String title = "Confirm Disconnect";
            String message = "Disconnect from " + this._connectedHost + "?";
            if (GuiUtil.showYesNoDialog("Confirm Disconnect", message) != 0) {
                return;
            }
        }
        this.deselectAllTargets();
        this._controllerListener.disconnectedFromServer();
        this._connected = false;
        this._connectedHost = null;
        if (this._deployManager != null) {
            this._deployManager.release();
        }
    }

    protected File promptUserToSpecifyArchive() {
        return this.promptUserToSpecifyArchive(null);
    }

    protected File promptUserToSpecifyArchive(String title) {
        return GuiUtil.promptUserToSpecifyFile(title, new J2eeArchiveFileFilter());
    }

    public synchronized boolean openDeploymentArchive(File archiveFile) {
        if (this._archiveFile != null && !this.closeDeploymentArchive(true)) {
            return false;
        }
        if (archiveFile == null && (archiveFile = this.promptUserToSpecifyArchive()) == null) {
            return false;
        }
        this._j2eeArchiveFile = this.getJ2eeArchiveFile(archiveFile);
        if (this._j2eeArchiveFile == null) {
            return false;
        }
        OpenArchiveThread oat = new OpenArchiveThread(archiveFile);
        oat.showDialog();
        oat.start();
        return true;
    }

    protected DeploymentManager getCurrentDeploymentManager() throws DeploymentManagerCreationException {
        DeploymentManager mgr = null;
        if (this._connected) {
            mgr = this._deployManager;
        } else {
            DeploymentFactoryManager factoryMgr = DeploymentFactoryManager.getInstance();
            mgr = factoryMgr.getDisconnectedDeploymentManager("deployer:oc4j");
        }
        return mgr;
    }

    protected J2eeFile getJ2eeArchiveFile(File archiveFile) {
        J2eeFile j2eeFile = null;
        try {
            String fileName = archiveFile.getName();
            String fileExtension = fileName.substring(fileName.indexOf(46));
            j2eeFile = fileExtension.equalsIgnoreCase(".jar") ? (this.isClientArchive(archiveFile) ? new CarFile(archiveFile) : new EjbFile(archiveFile)) : (fileExtension.equalsIgnoreCase(".war") ? new WarFile(archiveFile) : (fileExtension.equalsIgnoreCase(".rar") ? new RarFile(archiveFile) : new EarFile(archiveFile)));
        }
        catch (Throwable t) {
            GuiUtil.errDialog(ControllerImpl.composeError("Error creating J2eeFile: ", t));
            System.out.println("Error creating J2eeFile: " + t);
            t.printStackTrace();
        }
        return j2eeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isClientArchive(File archiveFile) throws IOException {
        JarTool jt = null;
        try {
            jt = new JarTool(archiveFile);
            if (jt.hasEntry("META-INF/application-client.xml")) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (jt != null) {
                jt.close();
            }
        }
        return false;
    }

    public ViewableJTree getManagementTree() {
        return this._managementTree;
    }

    public ViewableJTree getDeployTree() {
        return this._ddbeanTree;
    }

    public boolean closeDeploymentArchive(boolean allowCancel) {
        String title = "Save Deployment Plan";
        String message = "Do you want to save the currently open deployment plan?";
        int val = 0;
        this._controllerListener.maybeChangingArchiveStatus();
        if (allowCancel) {
            val = GuiUtil.showYesNoCancelDialog("Save Deployment Plan", "Do you want to save the currently open deployment plan?");
            if (val == 2) {
                return false;
            }
        } else {
            val = GuiUtil.showYesNoDialog("Save Deployment Plan", "Do you want to save the currently open deployment plan?");
        }
        if (val == 0) {
            this.saveDeploymentPlan();
        }
        this._j2eeArchiveFile = null;
        this._archiveFile = null;
        this._controllerListener.archiveClosed();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void saveDeploymentPlan() {
        block15: {
            File deplFile = GuiUtil.promptUserToSpecifyFile();
            if (deplFile != null) {
                FileOutputStream configOutputStream = null;
                configOutputStream = new FileOutputStream(deplFile);
                TabFilterOutputStream filterOutputStream = new TabFilterOutputStream(configOutputStream);
                this._deployConfig.save((OutputStream)filterOutputStream);
                Object var5_6 = null;
                try {
                    if (configOutputStream != null) {
                        configOutputStream.close();
                    }
                    break block15;
                }
                catch (IOException ioe) {
                    System.out.println("Error closing FileOutputStream on file " + deplFile.getName());
                    ioe.printStackTrace();
                }
                break block15;
                {
                    catch (ConfigurationException ce) {
                        GuiUtil.errDialog(ControllerImpl.composeError("Error saving configuration - ", ce));
                        ce.printStackTrace();
                        Object var5_7 = null;
                        try {
                            if (configOutputStream != null) {
                                configOutputStream.close();
                            }
                        }
                        catch (IOException ioe) {
                            System.out.println("Error closing FileOutputStream on file " + deplFile.getName());
                            ioe.printStackTrace();
                        }
                        return;
                    }
                    catch (Throwable t) {
                        GuiUtil.errDialog(ControllerImpl.composeError("Error: ", t));
                        t.printStackTrace();
                        Object var5_8 = null;
                        try {
                            if (configOutputStream != null) {
                                configOutputStream.close();
                            }
                        }
                        catch (IOException ioe) {
                            System.out.println("Error closing FileOutputStream on file " + deplFile.getName());
                            ioe.printStackTrace();
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    try {
                        if (configOutputStream != null) {
                            configOutputStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        System.out.println("Error closing FileOutputStream on file " + deplFile.getName());
                        ioe.printStackTrace();
                    }
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void restoreDeploymentPlan() {
        block19: {
            block16: {
                File deplFile = GuiUtil.promptUserToSpecifyFile();
                if (deplFile == null) break block19;
                FileInputStream configInputStream = null;
                this._j2eeArchiveFile = this.getJ2eeArchiveFile(this._archiveFile);
                DeploymentConfiguration deployConfig = this.getCurrentDeploymentManager().createConfiguration((DeployableObject)this._j2eeArchiveFile);
                configInputStream = new FileInputStream(deplFile);
                deployConfig.restore((InputStream)configInputStream);
                this._deployConfig = deployConfig;
                Object var5_7 = null;
                try {
                    if (configInputStream != null) {
                        configInputStream.close();
                    }
                    break block16;
                }
                catch (IOException ioe) {
                    System.out.println("Error closing FileInputStream on file " + deplFile.getName());
                    ioe.printStackTrace();
                }
                break block16;
                {
                    catch (ConfigurationException ce) {
                        GuiUtil.errDialog(ControllerImpl.composeError("Error restoring configuration - ", ce));
                        ce.printStackTrace();
                        Object var5_8 = null;
                        try {
                            if (configInputStream != null) {
                                configInputStream.close();
                            }
                        }
                        catch (IOException ioe) {
                            System.out.println("Error closing FileInputStream on file " + deplFile.getName());
                            ioe.printStackTrace();
                        }
                        return;
                    }
                    catch (Throwable t) {
                        GuiUtil.errDialog(ControllerImpl.composeError("Error: ", t));
                        t.printStackTrace();
                        Object var5_9 = null;
                        try {
                            if (configInputStream != null) {
                                configInputStream.close();
                            }
                        }
                        catch (IOException ioe) {
                            System.out.println("Error closing FileInputStream on file " + deplFile.getName());
                            ioe.printStackTrace();
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    try {
                        if (configInputStream != null) {
                            configInputStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        System.out.println("Error closing FileInputStream on file " + deplFile.getName());
                        ioe.printStackTrace();
                    }
                    throw throwable;
                }
            }
            this._ddbeanTree = new ViewableJTree(this._j2eeArchiveFile.getStdXml());
            try {
                this.integrateConfigBeansWithDDBeanTree();
            }
            catch (ConfigurationException ce) {
                ce.printStackTrace();
                GuiUtil.errDialog(ControllerImpl.composeError("Error creating configuration - ", ce));
                this.closeDeploymentArchive(false);
                return;
            }
            this._ddbeanTree.revalidate();
            this._controllerListener.archiveReopen();
        }
    }

    public void fetchDeploymentPlan() {
        if (this._connected) {
            if (!(this._deployManager instanceof ConnectedDeploymentManagerBase)) {
                return;
            }
            if (this._deployConfig != null && this._deployTargetInfo != null && this._ddbeanTree != null) {
                String appName = (String)AppInfoManager.getStoredObject(this._archiveFile);
                String[] apps = this._deployTargetInfo.getAppsForSelectedTargets();
                boolean webapp = this._j2eeArchiveFile instanceof WarFile;
                DeployOptionsDialog dod = new DeployOptionsDialog(this._parent, apps, null, 3, webapp);
                if (appName != null) {
                    dod.setDefaultAppsComboItem(appName);
                }
                if (!dod.showDialog()) {
                    return;
                }
                appName = dod.getApplication();
                ProprietaryTargetModuleID moduleId = (ProprietaryTargetModuleID)this._deployTargetInfo.getOneTargetModuleIDForApp(appName);
                if (appName != null && appName.length() > 0) {
                    try {
                        this._j2eeArchiveFile = this.getJ2eeArchiveFile(this._archiveFile);
                        ConnectedDeploymentManagerBase cdmb = (ConnectedDeploymentManagerBase)this._deployManager;
                        this._deployConfig = cdmb.createConfiguration(this._j2eeArchiveFile, moduleId);
                    }
                    catch (InvalidModuleException ime) {
                        ime.printStackTrace();
                        GuiUtil.errDialog(ControllerImpl.composeError("Error - invalid module: ", ime));
                        this.closeDeploymentArchive(false);
                        return;
                    }
                    try {
                        this._ddbeanTree = new ViewableJTree(this._j2eeArchiveFile.getStdXml());
                        this.integrateConfigBeansWithDDBeanTree();
                    }
                    catch (ConfigurationException ce) {
                        ce.printStackTrace();
                        GuiUtil.errDialog(ControllerImpl.composeError("Error creating configuration - ", ce));
                        this.closeDeploymentArchive(false);
                        return;
                    }
                    this._ddbeanTree.revalidate();
                    this._controllerListener.archiveReopen();
                    return;
                }
                GuiUtil.errDialog("Must choose an application");
            } else {
                GuiUtil.errDialog("Must open application first");
            }
        } else {
            GuiUtil.errDialog("Cannot fetch deployment plan - not connected to server");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void showDeploymentPlan() {
        block16: {
            ByteArrayOutputStream configOutputStream = null;
            configOutputStream = new ByteArrayOutputStream();
            TabFilterOutputStream filterOutputStream = new TabFilterOutputStream(configOutputStream);
            this._deployConfig.save((OutputStream)filterOutputStream);
            configOutputStream.close();
            String deplPlan = null;
            try {
                deplPlan = configOutputStream.toString("UTF-8");
            }
            catch (UnsupportedEncodingException unEx) {
                deplPlan = configOutputStream.toString();
            }
            TextDialog dialog = new TextDialog(this._parent, "Deployment Plan", deplPlan);
            dialog.showDialog();
            Object var6_8 = null;
            try {
                if (configOutputStream != null) {
                    configOutputStream.close();
                }
                break block16;
            }
            catch (IOException ioe) {
                System.out.println("Error closing ByteArrayOutputStream");
                ioe.printStackTrace();
            }
            break block16;
            {
                catch (ConfigurationException ce) {
                    GuiUtil.errDialog(ControllerImpl.composeError("Error showing configuration - ", ce));
                    ce.printStackTrace();
                    Object var6_9 = null;
                    try {
                        if (configOutputStream != null) {
                            configOutputStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        System.out.println("Error closing ByteArrayOutputStream");
                        ioe.printStackTrace();
                    }
                    return;
                }
                catch (Throwable t) {
                    GuiUtil.errDialog(ControllerImpl.composeError("Error: ", t));
                    t.printStackTrace();
                    Object var6_10 = null;
                    try {
                        if (configOutputStream != null) {
                            configOutputStream.close();
                        }
                    }
                    catch (IOException ioe) {
                        System.out.println("Error closing ByteArrayOutputStream");
                        ioe.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                try {
                    if (configOutputStream != null) {
                        configOutputStream.close();
                    }
                }
                catch (IOException ioe) {
                    System.out.println("Error closing ByteArrayOutputStream");
                    ioe.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public void verifyDeploymentConfiguration() {
    }

    public void uploadSharedLibrary() {
        UploadSharedLibOptionsDialog uod = new UploadSharedLibOptionsDialog(this._parent);
        if (!uod.showDialog()) {
            return;
        }
        Vector files = uod.getFiles();
        if (files == null || files.size() == 0) {
            return;
        }
        OperationThread thread = new OperationThread(null, 3);
        thread.setLibName(uod.getName());
        thread.setLibVersion(uod.getVersion());
        thread.setFiles(files);
        thread.start();
    }

    public void exit(int exitCode) {
        if (this._archiveFile != null && !this.closeDeploymentArchive(true)) {
            return;
        }
        AppInfoManager.saveToFile();
        this._parent.hide();
        if (this._connected) {
            this.disconnect(false);
        }
        System.exit(exitCode);
    }

    protected void integrateConfigBeansWithDDBeanTree() throws ConfigurationException {
        block12: {
            DConfigBeanRoot confRoot;
            BeanRootNode beanRoot;
            block11: {
                beanRoot = this._ddbeanTree.getRealRootNode();
                this._configRoot = this._deployConfig.getDConfigBeanRoot((DDBeanRoot)beanRoot);
                this.integrateConfigBeanWithDDBean((DConfigBean)this._configRoot, beanRoot);
                confRoot = null;
                if (!(this._j2eeArchiveFile instanceof J2eeApplicationObject)) break block11;
                DeployableObject[] deplObjs = ((J2eeApplicationObject)this._j2eeArchiveFile).getDeployableObjects();
                if (deplObjs == null) break block12;
                for (int n = 0; n < deplObjs.length; ++n) {
                    beanRoot = deplObjs[n].getDDBeanRoot();
                    confRoot = this._deployConfig.getDConfigBeanRoot((DDBeanRoot)beanRoot);
                    this.integrateConfigBeanWithDDBean((DConfigBean)confRoot, beanRoot);
                    if (deplObjs[n].getType().equals(ModuleType.EJB)) {
                        try {
                            beanRoot = deplObjs[n].getDDBeanRoot("META-INF/webservices.xml");
                            confRoot = this._deployConfig.getDConfigBeanRoot((DDBeanRoot)beanRoot);
                            this.integrateConfigBeanWithDDBean((DConfigBean)confRoot, beanRoot);
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                    if (!deplObjs[n].getType().equals(ModuleType.WAR)) continue;
                    try {
                        beanRoot = deplObjs[n].getDDBeanRoot("WEB-INF/webservices.xml");
                        confRoot = this._deployConfig.getDConfigBeanRoot((DDBeanRoot)beanRoot);
                        this.integrateConfigBeanWithDDBean((DConfigBean)confRoot, beanRoot);
                        continue;
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                break block12;
            }
            if (this._j2eeArchiveFile.getType().equals(ModuleType.EJB)) {
                try {
                    beanRoot = this._j2eeArchiveFile.getDDBeanRoot("META-INF/webservices.xml");
                    confRoot = this._deployConfig.getDConfigBeanRoot((DDBeanRoot)beanRoot);
                    this.integrateConfigBeanWithDDBean((DConfigBean)confRoot, beanRoot);
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (!this._j2eeArchiveFile.getType().equals(ModuleType.WAR)) break block12;
            try {
                beanRoot = this._j2eeArchiveFile.getDDBeanRoot("WEB-INF/webservices.xml");
                confRoot = this._deployConfig.getDConfigBeanRoot((DDBeanRoot)beanRoot);
                this.integrateConfigBeanWithDDBean((DConfigBean)confRoot, beanRoot);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void integrateConfigBeanWithDDBean(DConfigBean configBean, DDBean ddBean) throws ConfigurationException {
        String[] xpaths = configBean.getXpaths();
        if (xpaths == null) {
            return;
        }
        for (int x = 0; x < xpaths.length; ++x) {
            DDBean[] ddKids = ddBean.getChildBean(xpaths[x]);
            if (ddKids == null) continue;
            for (int dk = 0; dk < ddKids.length; ++dk) {
                DConfigBean configKid = configBean.getDConfigBean(ddKids[dk]);
                ((BeanNode)ddKids[dk]).setLinkedConfigBean(configKid);
                this.integrateConfigBeanWithDDBean(configKid, ddKids[dk]);
            }
        }
    }

    private static String composeError(String msg, Throwable t) {
        String errMsg = "";
        if (msg != null) {
            errMsg = msg;
        }
        errMsg = errMsg + t.getMessage() + "\n";
        while (t.getCause() != null) {
            t = t.getCause();
            errMsg = errMsg + t.getMessage();
        }
        return errMsg;
    }

    class ConnectThread
    extends Thread
    implements ActionListener {
        boolean _cluster;
        boolean _opmn;
        String _oc4j;
        String _host;
        int _port;
        String _user;
        String _pwd;
        boolean _ssl;
        String _url;
        boolean _finished = false;
        boolean _canceled = false;
        protected ProgressDialog _connectProgressDlg = null;

        public ConnectThread(boolean cluster, boolean opmn, String oc4j, String host, int port, String user, String pwd, boolean ssl) {
            this._cluster = cluster;
            this._opmn = opmn;
            this._oc4j = oc4j;
            this._host = host;
            this._port = port;
            this._user = user;
            this._pwd = pwd;
            this._ssl = ssl;
            this._url = "deployer:" + (this._cluster ? "cluster" : "oc4j") + (this._ssl ? ":ormis" : "") + (this._opmn ? ":opmn://" : ":") + this._host + ":" + this._port + (this._opmn ? "/" + this._oc4j : "");
            this._connectProgressDlg = new ProgressDialog(ControllerImpl.this._parent, "Connecting to URL " + this._url, "Connecting", this);
        }

        public void showDialog() {
            this._connectProgressDlg.showDialog();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (ControllerImpl.this._connected) {
                throw new IllegalStateException("Connect may not be called when already connected");
            }
            factoryMgr = DeploymentFactoryManager.getInstance();
            configOutStream = null;
            configInStream = null;
            savedConfigFile = null;
            try {
                block44: {
                    ControllerImpl.this._deployManager = factoryMgr.getDeploymentManager(this._url, this._user, this._pwd);
                    if (!this._canceled) break block44;
                    var7_5 = null;
                    var8_12 = this;
                    ** GOTO lbl170
                }
                this._connectProgressDlg.setCancelable(false);
                if (this._cluster) {
                    cltree = ClusterJTree.createClusterJTree(ControllerImpl.this._deployManager, this._oc4j, this._url);
                    ControllerImpl.this._managementTree = cltree;
                    ControllerImpl.this._deployTargetInfo = cltree;
                } else {
                    cotree = ConfigJTree.createConfigJTree(ControllerImpl.this._deployManager, this._host + ":" + this._port);
                    this._oc4j = ControllerImpl.this._deployManager.getTargets()[0].getName();
                    ControllerImpl.this._managementTree = cotree;
                    ControllerImpl.this._deployTargetInfo = cotree;
                }
                if (ControllerImpl.this._j2eeArchiveFile != null) {
                    configOutStream = new ByteArrayOutputStream();
                    ControllerImpl.this._deployConfig.save((OutputStream)configOutStream);
                    configOutStream.close();
                    ControllerImpl.this._deployConfig = ControllerImpl.this._deployManager.createConfiguration((DeployableObject)ControllerImpl.this._j2eeArchiveFile);
                    configInStream = new ByteArrayInputStream(configOutStream.toByteArray());
                    ControllerImpl.this._deployConfig.restore((InputStream)configInStream);
                    configInStream.close();
                    ControllerImpl.this.integrateConfigBeansWithDDBeanTree();
                }
                this._connectProgressDlg.finished("Connected.", 500);
                ControllerImpl.this._connected = true;
                ControllerImpl.this._connectedHost = this._host;
                ** GOTO lbl189
            }
            catch (ConfigurationException ce) {
                this._connectProgressDlg.dispose();
                GuiUtil.errDialog(ControllerImpl.access$000("Error creating configuration - ", ce));
                ce.printStackTrace();
                var7_7 = null;
                var8_14 = this;
                synchronized (var8_14) {
                    this._finished = true;
                    this.notifyAll();
                }
                try {
                    if (configOutStream != null) {
                        configOutStream.close();
                    }
                }
                catch (IOException ioe) {
                    System.out.println("Error closing FileOutputStream on file " + savedConfigFile.getName());
                    ioe.printStackTrace();
                }
                try {
                    if (configInStream == null) return;
                    configInStream.close();
                    return;
                }
                catch (IOException ioe) {
                    System.out.println("Error closing FileInputStream on file " + savedConfigFile.getName());
                    ioe.printStackTrace();
                }
                return;
            }
            catch (ExtendedDeploymentManagerCreationException edmce) {
                block45: {
                    this._connectProgressDlg.dispose();
                    GuiUtil.errDialog(ControllerImpl.access$000("Error creating deployment manager: ", (Throwable)edmce));
                    edmce.printStackTrace();
                    var7_8 = null;
                    var8_15 = this;
                    synchronized (var8_15) {
                        this._finished = true;
                        this.notifyAll();
                    }
                    ** try [egrp 3[TRYBLOCK] [17 : 491->502)] { 
lbl78:
                    // 1 sources

                    if (configOutStream != null) {
                        configOutStream.close();
                    }
                    break block45;
lbl81:
                    // 1 sources

                    catch (IOException ioe) {
                        System.out.println("Error closing FileOutputStream on file " + savedConfigFile.getName());
                        ioe.printStackTrace();
                    }
                }
                ** try [egrp 4[TRYBLOCK] [18 : 538->549)] { 
lbl86:
                // 1 sources

                if (configInStream == null) return;
                configInStream.close();
                return;
lbl89:
                // 1 sources

                catch (IOException ioe) {
                    System.out.println("Error closing FileInputStream on file " + savedConfigFile.getName());
                    ioe.printStackTrace();
                }
                return;
            }
            catch (DeploymentManagerCreationException de) {
                block46: {
                    this._connectProgressDlg.dispose();
                    GuiUtil.errDialog(ControllerImpl.access$000("Error creating deployment manager: ", de));
                    de.printStackTrace();
                    var7_9 = null;
                    var8_16 = this;
                    synchronized (var8_16) {
                        this._finished = true;
                        this.notifyAll();
                    }
                    ** try [egrp 3[TRYBLOCK] [17 : 491->502)] { 
lbl105:
                    // 1 sources

                    if (configOutStream != null) {
                        configOutStream.close();
                    }
                    break block46;
lbl108:
                    // 1 sources

                    catch (IOException ioe) {
                        System.out.println("Error closing FileOutputStream on file " + savedConfigFile.getName());
                        ioe.printStackTrace();
                    }
                }
                ** try [egrp 4[TRYBLOCK] [18 : 538->549)] { 
lbl113:
                // 1 sources

                if (configInStream == null) return;
                configInStream.close();
                return;
lbl116:
                // 1 sources

                catch (IOException ioe) {
                    System.out.println("Error closing FileInputStream on file " + savedConfigFile.getName());
                    ioe.printStackTrace();
                }
                return;
            }
            catch (Throwable t) {
                block47: {
                    this._connectProgressDlg.dispose();
                    GuiUtil.errDialog(ControllerImpl.access$000("Error: ", t));
                    t.printStackTrace();
                    var7_10 = null;
                    var8_17 = this;
                    synchronized (var8_17) {
                        this._finished = true;
                        this.notifyAll();
                    }
                    ** try [egrp 3[TRYBLOCK] [17 : 491->502)] { 
lbl132:
                    // 1 sources

                    if (configOutStream != null) {
                        configOutStream.close();
                    }
                    break block47;
lbl135:
                    // 1 sources

                    catch (IOException ioe) {
                        System.out.println("Error closing FileOutputStream on file " + savedConfigFile.getName());
                        ioe.printStackTrace();
                    }
                }
                ** try [egrp 4[TRYBLOCK] [18 : 538->549)] { 
lbl140:
                // 1 sources

                if (configInStream == null) return;
                configInStream.close();
                return;
lbl143:
                // 1 sources

                catch (IOException ioe) {
                    System.out.println("Error closing FileInputStream on file " + savedConfigFile.getName());
                    ioe.printStackTrace();
                }
                return;
            }
            {
                block50: {
                    block49: {
                        catch (Throwable var6_24) {
                            block48: {
                                var7_11 = null;
                                var8_18 = this;
                                synchronized (var8_18) {
                                    this._finished = true;
                                    this.notifyAll();
                                }
                                ** try [egrp 3[TRYBLOCK] [17 : 491->502)] { 
lbl155:
                                // 1 sources

                                if (configOutStream != null) {
                                    configOutStream.close();
                                }
                                break block48;
lbl158:
                                // 1 sources

                                catch (IOException ioe) {
                                    System.out.println("Error closing FileOutputStream on file " + savedConfigFile.getName());
                                    ioe.printStackTrace();
                                }
                            }
                            ** try [egrp 4[TRYBLOCK] [18 : 538->549)] { 
lbl163:
                            // 1 sources

                            if (configInStream == null) throw var6_24;
                            configInStream.close();
                            throw var6_24;
lbl166:
                            // 1 sources

                            catch (IOException ioe) {
                                System.out.println("Error closing FileInputStream on file " + savedConfigFile.getName());
                                ioe.printStackTrace();
                            }
                            throw var6_24;
                        }
lbl170:
                        // 1 sources

                        synchronized (var8_12) {
                            this._finished = true;
                            this.notifyAll();
                        }
                        ** try [egrp 3[TRYBLOCK] [17 : 491->502)] { 
lbl174:
                        // 1 sources

                        if (configOutStream != null) {
                            configOutStream.close();
                        }
                        break block49;
lbl177:
                        // 1 sources

                        catch (IOException ioe) {
                            System.out.println("Error closing FileOutputStream on file " + savedConfigFile.getName());
                            ioe.printStackTrace();
                        }
                    }
                    ** try [egrp 4[TRYBLOCK] [18 : 538->549)] { 
lbl182:
                    // 1 sources

                    if (configInStream == null) return;
                    configInStream.close();
                    return;
lbl185:
                    // 1 sources

                    catch (IOException ioe) {
                        System.out.println("Error closing FileInputStream on file " + savedConfigFile.getName());
                        ioe.printStackTrace();
                    }
                    return;
lbl189:
                    // 1 sources

                    var7_6 = null;
                    var8_13 = this;
                    synchronized (var8_13) {
                        this._finished = true;
                        this.notifyAll();
                    }
                    ** try [egrp 3[TRYBLOCK] [17 : 491->502)] { 
lbl195:
                    // 1 sources

                    if (configOutStream != null) {
                        configOutStream.close();
                    }
                    break block50;
lbl198:
                    // 1 sources

                    catch (IOException ioe) {
                        System.out.println("Error closing FileOutputStream on file " + savedConfigFile.getName());
                        ioe.printStackTrace();
                    }
                }
                ** try [egrp 4[TRYBLOCK] [18 : 538->549)] { 
lbl203:
                // 1 sources

                if (configInStream != null) {
                    configInStream.close();
                }
lbl207:
                // 1 sources

                catch (IOException ioe) {}
                System.out.println("Error closing FileInputStream on file " + savedConfigFile.getName());
                ioe.printStackTrace();
            }
            connectedRunnable = new Runnable(this){
                private final /* synthetic */ ConnectThread this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    String connectionString = "OC4J " + (this.this$1._cluster ? "cluster: " : "instance: ") + this.this$1._oc4j;
                    ConnectThread.access$100((ConnectThread)this.this$1)._controllerListener.connectedToServer(connectionString, this.this$1._cluster);
                }
            };
            SwingUtilities.invokeLater(connectedRunnable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitTilFinished() {
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                if (this._finished) {
                    return;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            this._canceled = true;
            this.interrupt();
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                this.notifyAll();
            }
            this._connectProgressDlg.dispose();
        }

        static /* synthetic */ ControllerImpl access$100(ConnectThread x0) {
            return x0.ControllerImpl.this;
        }
    }

    class OpenArchiveThread
    extends Thread {
        protected ProgressDialog _openProgressDlg;
        protected File _fileToOpen;

        public OpenArchiveThread(File archive) {
            this._fileToOpen = archive;
            this._openProgressDlg = new ProgressDialog(ControllerImpl.this._parent, "Opening File " + this._fileToOpen.getName() + "...", "Open File");
            this._openProgressDlg.setIndeterminate(false);
        }

        public void showDialog() {
            this._openProgressDlg.showDialog();
        }

        public void run() {
            ControllerImpl.this._ddbeanTree = new ViewableJTree(ControllerImpl.this._j2eeArchiveFile.getStdXml());
            DeploymentManager mgr = null;
            try {
                mgr = ControllerImpl.this.getCurrentDeploymentManager();
                if (mgr == null) {
                    ControllerImpl.this.closeDeploymentArchive(false);
                    this._openProgressDlg.dispose();
                    return;
                }
            }
            catch (DeploymentManagerCreationException de) {
                de.printStackTrace();
                GuiUtil.errDialog(ControllerImpl.composeError("Could not create Disconnected DeploymentManager: ", de));
                this._openProgressDlg.dispose();
                return;
            }
            try {
                ControllerImpl.this._deployConfig = mgr.createConfiguration((DeployableObject)ControllerImpl.this._j2eeArchiveFile);
            }
            catch (InvalidModuleException ime) {
                ime.printStackTrace();
                GuiUtil.errDialog(ControllerImpl.composeError("Error - invalid module: ", ime));
                ControllerImpl.this.closeDeploymentArchive(false);
                this._openProgressDlg.dispose();
                return;
            }
            try {
                ControllerImpl.this.integrateConfigBeansWithDDBeanTree();
            }
            catch (ConfigurationException ce) {
                ce.printStackTrace();
                GuiUtil.errDialog(ControllerImpl.composeError("Error creating configuration - ", ce));
                ControllerImpl.this.closeDeploymentArchive(false);
                this._openProgressDlg.dispose();
                return;
            }
            ControllerImpl.this._controllerListener.archiveOpen(this._fileToOpen);
            ControllerImpl.this._archiveFile = this._fileToOpen;
            this._openProgressDlg.finished("Done.", 500);
            this._openProgressDlg.dispose();
        }
    }

    class DeployThread
    extends Thread
    implements DialogListener,
    ProgressListener {
        protected boolean _redeploy;
        protected String _method;
        protected String _appName;
        protected File _deployArchiveFile;
        protected TargetModuleID _moduleID;
        protected String _contextRoot;
        protected OperationStatusDialog _statusDlg;
        protected ProgressObject _progressObject;

        DeployThread(File archive) {
            this._redeploy = false;
            this._deployArchiveFile = archive;
            this._method = "Deploy";
        }

        DeployThread(String appName, File archive) {
            this._appName = appName;
            this._deployArchiveFile = archive;
            this._redeploy = true;
            this._method = "Redeploy";
        }

        public void operationCompleted(OperationStatus status) {
            if (status.succeeded()) {
                ControllerImpl.this._deployTargetInfo.newAppDeployed(this._appName, this._moduleID, true);
                ControllerImpl.this._controllerListener.deployCompleted();
                AppInfoManager.storeObject(this._appName, this._deployArchiveFile);
                AppInfoManager.storeObject(this._deployArchiveFile, this._appName);
            }
            this._statusDlg.operationCompleted(status);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleProgressEvent(ProgressEvent event) {
            DeployThread deployThread = this;
            synchronized (deployThread) {
                DeploymentStatus status = event.getDeploymentStatus();
                String targetName = null;
                StateType state = null;
                if (event instanceof ClusterExtendedProgressEvent) {
                    targetName = ((ClusterExtendedProgressEvent)event).getTargetID();
                    state = ((ClusterExtendedProgressEvent)event).getSubTargetState();
                }
                this._statusDlg.updateStatus(status.getMessage(), targetName, state);
                if (status.isCompleted()) {
                    if (status.getAction() == ActionType.CANCEL) {
                        this.operationCompleted(OperationStatus.CANCELED);
                    } else {
                        ProprietaryTargetModuleID app = (ProprietaryTargetModuleID)event.getTargetModuleID();
                        if (ControllerImpl.this._j2eeArchiveFile instanceof EjbFile || ControllerImpl.this._j2eeArchiveFile instanceof WarFile || ControllerImpl.this._j2eeArchiveFile instanceof CarFile) {
                            ProprietaryConnectedDeploymentManager pcDeplMgr = (ProprietaryConnectedDeploymentManager)ControllerImpl.this._deployManager;
                            this._moduleID = pcDeplMgr.getTargetModuleIDForApplication(this._appName, ControllerImpl.this.getSelectedTargets()[0]);
                        } else {
                            this._moduleID = app;
                        }
                        this._appName = app.getObjectName().getKeyProperty("name");
                        this.operationCompleted(OperationStatus.SUCCESS);
                    }
                } else if (status.isFailed()) {
                    this.operationCompleted(OperationStatus.FAILURE);
                } else if (status.isRunning()) {
                    // empty if block
                }
            }
        }

        public void cancelButtonPressed() {
            try {
                if (this._progressObject != null) {
                    this._progressObject.cancel();
                }
            }
            catch (OperationUnsupportedException oue) {
                oue.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            if (!ControllerImpl.this.connectForDeploy()) {
                return;
            }
            webapp = ControllerImpl.this._j2eeArchiveFile instanceof WarFile;
            apps = ControllerImpl.this._deployTargetInfo.getAppsForSelectedTargets();
            deployTargets = ControllerImpl.this.getSelectedTargets();
            instanceNames = null;
            targetNames = null;
            if (deployTargets.length > 1) {
                instanceNames = new String[deployTargets.length];
                targetNames = new String[deployTargets.length];
                for (i = 0; i < targetNames.length; ++i) {
                    targetNames[i] = ((ProprietaryTarget)deployTargets[i]).getName();
                    uriMap = ClusterHelper.getDeployerURIComponents(targetNames[i]);
                    instanceNames[i] = (String)uriMap.get("as_instance");
                }
            }
            configOutputStream = null;
            if (this._redeploy) {
                dod = new DeployOptionsDialog(ControllerImpl.this._parent, apps, null, 2, webapp);
                if (this._appName != null) {
                    dod.setDefaultAppsComboItem(this._appName);
                }
                if (!dod.showDialog()) {
                    return;
                }
                this._appName = dod.getApplication();
                crDlg = new ConfirmRedeployDialog(ControllerImpl.this._parent, this._appName, ControllerImpl.this._archiveFile, false);
                if (!crDlg.confirmRedeployment()) {
                    return;
                }
                this._statusDlg = new OperationStatusDialog(ControllerImpl.this._parent, this, this._method, this._appName, targetNames, instanceNames);
                this._statusDlg.showDialog();
            } else {
                currentAppName = ((ConfigBeanRootNode)ControllerImpl.this._configRoot).getApplicationId();
                dod = new DeployOptionsDialog(ControllerImpl.this._parent, apps, null, 1, webapp, currentAppName);
                if (webapp) {
                    try {
                        this._contextRoot = ((WarDepXml)ControllerImpl.this._configRoot).getContextRoot();
                        if (this._contextRoot != null && this._contextRoot.length() > 0) {
                            dod.setContextRoot(this._contextRoot);
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (!dod.showDialog()) {
                    return;
                }
                this._appName = dod.getAppName();
                parentApp = dod.getApplication();
                try {
                    ((ConfigBeanRootNode)ControllerImpl.this._configRoot).setApplicationId(this._appName);
                    appType = new AppType((ConfigBeanRootNode)ControllerImpl.this._configRoot);
                    appType.setValue(parentApp);
                    ((ConfigBeanRootNode)ControllerImpl.this._configRoot).setParentApp(appType);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (webapp) {
                    this._contextRoot = dod.getContextRoot();
                    try {
                        ((WarDepXml)ControllerImpl.this._configRoot).setContextRoot(this._contextRoot);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (!(crDlg = new ConfirmDeployDialog(ControllerImpl.this._parent, this._appName, ControllerImpl.this._selectedTarget)).confirmDeployment()) {
                    return;
                }
                this._statusDlg = new OperationStatusDialog(ControllerImpl.this._parent, this, this._method, this._appName, targetNames, instanceNames);
                this._statusDlg.showDialog();
            }
            try {
                block37: {
                    block35: {
                        block36: {
                            config = null;
                            configBeanRoot = null;
                            if (!this._redeploy || this._deployArchiveFile == ControllerImpl.this._archiveFile) break block35;
                            j2eeFile = ControllerImpl.this.getJ2eeArchiveFile(this._deployArchiveFile);
                            if (j2eeFile != null) break block36;
                            this._statusDlg.operationFailed("Couldn't create J2eeFile, aborting Deployment");
                            var13_19 = null;
                            ** GOTO lbl141
                        }
                        new ViewableJTree(j2eeFile.getStdXml());
                        mgr = ControllerImpl.this.getCurrentDeploymentManager();
                        config = mgr.createConfiguration((DeployableObject)j2eeFile);
                        beanRoot = j2eeFile.getDDBeanRoot();
                        configBeanRoot = config.getDConfigBeanRoot(beanRoot);
                        break block37;
                    }
                    beanRoot = ControllerImpl.this._j2eeArchiveFile.getDDBeanRoot();
                    configBeanRoot = ControllerImpl.this._deployConfig.getDConfigBeanRoot(beanRoot);
                    config = ControllerImpl.this._deployConfig;
                }
                configOutputStream = new ByteArrayOutputStream();
                config.save((OutputStream)configOutputStream);
                configOutputStream.close();
                ** GOTO lbl149
            }
            catch (DeploymentManagerCreationException de) {
                this._statusDlg.operationFailed("Deployment Error - Could not create Disconnected DeploymentManager: " + de.getMessage());
                de.printStackTrace();
                var13_21 = null;
                try {
                    if (configOutputStream == null) return;
                    configOutputStream.close();
                    return;
                }
                catch (IOException ioe) {
                    System.out.println("Error closing ByteArrayOutputStream");
                    ioe.printStackTrace();
                }
                return;
            }
            catch (ConfigurationException ce) {
                this._statusDlg.operationFailed("ConfigurationException occured while deploying: " + ce.getMessage());
                ce.printStackTrace();
                var13_22 = null;
                ** try [egrp 5[TRYBLOCK] [15 : 869->882)] { 
lbl110:
                // 1 sources

                if (configOutputStream == null) return;
                configOutputStream.close();
                return;
lbl113:
                // 1 sources

                catch (IOException ioe) {
                    System.out.println("Error closing ByteArrayOutputStream");
                    ioe.printStackTrace();
                }
                return;
            }
            catch (Throwable t) {
                this._statusDlg.operationFailed("Exception occured while deploying: " + t.getMessage());
                t.printStackTrace();
                var13_23 = null;
                ** try [egrp 5[TRYBLOCK] [15 : 869->882)] { 
lbl123:
                // 1 sources

                if (configOutputStream == null) return;
                configOutputStream.close();
                return;
lbl126:
                // 1 sources

                catch (IOException ioe) {
                    System.out.println("Error closing ByteArrayOutputStream");
                    ioe.printStackTrace();
                }
                return;
            }
            {
                catch (Throwable var12_32) {
                    var13_24 = null;
                    ** try [egrp 5[TRYBLOCK] [15 : 869->882)] { 
lbl134:
                    // 1 sources

                    if (configOutputStream == null) throw var12_32;
                    configOutputStream.close();
                    throw var12_32;
lbl137:
                    // 1 sources

                    catch (IOException ioe) {
                        System.out.println("Error closing ByteArrayOutputStream");
                        ioe.printStackTrace();
                    }
                    throw var12_32;
                }
lbl141:
                // 1 sources

                ** try [egrp 5[TRYBLOCK] [15 : 869->882)] { 
lbl142:
                // 1 sources

                if (configOutputStream == null) return;
                configOutputStream.close();
                return;
lbl145:
                // 1 sources

                catch (IOException ioe) {
                    System.out.println("Error closing ByteArrayOutputStream");
                    ioe.printStackTrace();
                }
                return;
lbl149:
                // 1 sources

                var13_20 = null;
                ** try [egrp 5[TRYBLOCK] [15 : 869->882)] { 
lbl151:
                // 1 sources

                if (configOutputStream != null) {
                    configOutputStream.close();
                }
lbl155:
                // 1 sources

                catch (IOException ioe) {}
                System.out.println("Error closing ByteArrayOutputStream");
                ioe.printStackTrace();
            }
            try {
                pcDeplMgr = (ProprietaryConnectedDeploymentManager)ControllerImpl.this._deployManager;
                this._progressObject = this._redeploy != false ? pcDeplMgr.redeploy(ControllerImpl.this._deployTargetInfo.getAllTargetModuleIDsForApp(this._appName), new File(this._deployArchiveFile.getAbsolutePath()), new ByteArrayInputStream(configOutputStream.toByteArray())) : pcDeplMgr.distribute(deployTargets, new File(this._deployArchiveFile.getAbsolutePath()), new ByteArrayInputStream(configOutputStream.toByteArray()));
                this._progressObject.addProgressListener((ProgressListener)this);
                if (this._progressObject.isCancelSupported() == false) return;
                this._statusDlg.enableCancelButton();
                return;
            }
            catch (Throwable t) {
                this._statusDlg.operationFailed("ERROR: " + t.getMessage());
                t.printStackTrace();
            }
        }
    }

    class OperationThread
    extends Thread
    implements ProgressListener,
    DialogListener {
        protected static final int START = 0;
        protected static final int STOP = 1;
        protected static final int UNDEPLOY = 2;
        protected static final int UPLOAD_SHARED_LIB = 3;
        protected int _method;
        protected String _appName;
        protected String _methodName;
        protected TargetModuleNode _appNode;
        protected OperationStatusDialog _statusDlg;
        protected ProgressObject _progressObject;
        protected Vector _files;
        protected int _file;
        protected String _name;
        protected String _version;
        protected String _codeSource;
        protected Target[] _targets;

        OperationThread(TargetModuleNode node, int method) {
            if (node != null) {
                this._appNode = node;
                this._appName = this._appNode.getName();
            }
            this._method = method;
            if (this._method == 0) {
                this._methodName = "Start";
            } else if (this._method == 1) {
                this._methodName = "Stop";
            } else if (this._method == 2) {
                this._methodName = "Undeploy";
            } else if (this._method == 3) {
                this._methodName = "Upload Shared Library";
                this._file = 0;
            }
        }

        public void setFiles(Vector files) {
            this._files = files;
        }

        public void setLibName(String name) {
            this._name = name;
        }

        public void setLibVersion(String version) {
            this._version = version;
        }

        public void cancelButtonPressed() {
            try {
                if (this._progressObject != null) {
                    this._progressObject.cancel();
                }
            }
            catch (OperationUnsupportedException oue) {
                oue.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleProgressEvent(ProgressEvent event) {
            OperationThread operationThread = this;
            synchronized (operationThread) {
                DeploymentStatus status = event.getDeploymentStatus();
                String targetName = null;
                StateType state = null;
                if (event instanceof ClusterExtendedProgressEvent) {
                    targetName = ((ClusterExtendedProgressEvent)event).getTargetID();
                    state = ((ClusterExtendedProgressEvent)event).getSubTargetState();
                }
                this._statusDlg.updateStatus(status.getMessage(), targetName, state);
                if (status.isCompleted()) {
                    if (status.getAction() == ActionType.CANCEL) {
                        this._statusDlg.operationCompleted(OperationStatus.CANCELED);
                    } else {
                        if (this._method == 2) {
                            ControllerImpl.this._deployTargetInfo.appUnDeployed(this._appNode, event.getTargetModuleID());
                        }
                        if (this._method == 3) {
                            ++this._file;
                            if (this._file < this._files.size()) {
                                this._codeSource = ((File)this._files.elementAt(this._file)).getName();
                                ProprietaryConnectedDeploymentManager pcDeplMgr = (ProprietaryConnectedDeploymentManager)ControllerImpl.this._deployManager;
                                return;
                            }
                        }
                        this._statusDlg.operationCompleted(OperationStatus.SUCCESS);
                    }
                } else if (status.isFailed()) {
                    this._statusDlg.operationCompleted(OperationStatus.FAILURE);
                } else if (status.isRunning()) {
                    // empty if block
                }
            }
        }

        public void run() {
            if (this._method == 3) {
                if (!ControllerImpl.this.connectForDeploy()) {
                    return;
                }
                this._appName = this._name + " " + this._version;
                this._targets = ControllerImpl.this.getSelectedTargets();
            }
            TargetModuleID[] ids = null;
            if (this._appNode != null) {
                ids = this._appNode.getAllTargetModuleIDs();
            }
            String[] instanceNames = null;
            Object[] targetNames = null;
            if (ids != null && ids.length > 1) {
                instanceNames = new String[ids.length];
                targetNames = new String[ids.length];
                for (int i = 0; i < targetNames.length; ++i) {
                    targetNames[i] = ((ProprietaryTarget)ids[i].getTarget()).getName();
                    Map uriMap = ClusterHelper.getDeployerURIComponents((String)targetNames[i]);
                    instanceNames[i] = (String)uriMap.get("as_instance");
                }
            }
            this._statusDlg = new OperationStatusDialog(ControllerImpl.this._parent, this, this._methodName, this._appName, targetNames, instanceNames);
            this._statusDlg.showDialog();
            try {
                ProprietaryConnectedDeploymentManager pcDeplMgr = (ProprietaryConnectedDeploymentManager)ControllerImpl.this._deployManager;
                switch (this._method) {
                    case 0: {
                        this._progressObject = pcDeplMgr.start(ids, (ProgressListener)this);
                        break;
                    }
                    case 1: {
                        this._progressObject = pcDeplMgr.stop(ids, (ProgressListener)this);
                        break;
                    }
                    case 2: {
                        this._progressObject = pcDeplMgr.undeploy(ids, this);
                        break;
                    }
                    case 3: {
                        this._codeSource = ((File)this._files.elementAt(this._file)).getName();
                    }
                }
                if (this._progressObject.isCancelSupported()) {
                    this._statusDlg.enableCancelButton();
                }
            }
            catch (Throwable t) {
                this._statusDlg.operationFailed(t);
                t.printStackTrace();
            }
        }
    }
}

