/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class UnbindWebAppCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-unbindWebApp";
    public static final String COMMANDMENU = "-unbindWebApp -appName <appname> -webModuleName <name> [options]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -unbindWebApp  [<switch>]\n   - Unbinds a web module from web site.\n\nValid switches are: \n   -appName <name>             - Required  The application name.\n   -webModuleName <name>       - Required  The Web module name.\n   -webSiteName <name>         - Optional  The website name. If omitted, \n                                           defaults to 'default-web-site'.\n\n";
    private String _appName;
    private String _webName;
    private String _siteName;

    public UnbindWebAppCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("unbindWebApp subcommand");
            if (command.equalsIgnoreCase("-appName")) {
                this._appName = this.getNextArgument("appName");
                continue;
            }
            if (command.equalsIgnoreCase("-webmodulename")) {
                this._webName = this.getNextArgument("webModuleName");
                continue;
            }
            if (command.equalsIgnoreCase("-websitename")) {
                this._siteName = this.getNextArgument("webSiteName");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_unbindwebapp_switch", new String[]{command}), COMMANDNAME);
        }
        if (this._siteName == null) {
            this._siteName = "default-web-site";
        }
        this.checkArgIsNull(this._appName, "-appName");
        this.checkArgIsNull(this._webName, "-webModuleName");
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.unbindWebApp(this._appName, this._webName, this._siteName);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("unbindwebapp_error", new String[]{e.getMessage()}), e);
        }
    }
}

