/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class RemoveSharedLibraryCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-removeSharedLibrary";
    public static final String COMMANDMENU = "-removeSharedLibrary -name <name> -version <version>";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -removeSharedLibrary [<switch>]\n   - Removes an existing shared library in the OC4J instance.\n\nValid switches are: \n   -name <name>         - Required  The name of the shared library.\n   -version <version>   - Required  The version of the shared library.\n\n";
    private String _name;
    private String _version;

    public RemoveSharedLibraryCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("removeSharedLibrary subcommand");
            Object nextArg = null;
            if (command.equalsIgnoreCase("-name")) {
                this._name = this.getNextArgument("removeSharedLibrary -name name");
                continue;
            }
            if (command.equalsIgnoreCase("-version")) {
                this._version = this.getNextArgument("version");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_removesharedlibrary_switch", new String[]{command}), "-removeshSharedLibrary");
        }
        this.checkArgIsNull(this._name, "-name");
        this.checkArgIsNull(this._version, "-version");
    }

    protected void doExecute() throws AdminCommandException {
        try {
            if (!this._j2eeDeplMgr.checkSharedLibraryExists(this._name, this._version)) {
                throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("shared_library_not_exist", new String[]{this._name, this._version}));
            }
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("removesharedlibrary_error", new String[]{e.getMessage()}), e);
        }
        try {
            this._j2eeDeplMgr.removeSharedLibrary(this._name, this._version);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("removesharedlibrary_error", new String[]{e.getMessage()}), e);
        }
        System.out.println("");
        System.out.println(FormattingResourceBundle.DeploymentMessages.getString("command_successful", new String[]{"removeSharedLibrary"}));
        System.out.println("");
    }
}

