/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import java.util.Map;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.cmdline.util.CommandOutputHelper;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class ListWebBindingsCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-listWebBindings";
    public static final String COMMANDMENU = "-listWebBindings [-webSiteName <web-site-name>] [-verbose]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -listWebBindings [-webSiteName <web-site-name>] [-verbose]\n   - Displays web bindings for web sites in OC4J instances.\n\nValid switches are: \n   -webSiteName <web-site-name> - Optional  Web site name.\n   -verbose                     - Optional  Verbose info for web bindings.\n\n ";
    private String _webSiteName = null;
    private boolean _verbose = false;

    public ListWebBindingsCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("listWebBindings subcommand");
            if (command.equalsIgnoreCase("-webSiteName")) {
                this._webSiteName = this.getNextArgument("webSiteName");
                continue;
            }
            if (command.equalsIgnoreCase("-verbose")) {
                this._verbose = true;
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_listwebbindings_switch", new String[]{command}), COMMANDNAME);
        }
    }

    protected void doExecute() throws AdminCommandException {
        try {
            Map bindings = this._j2eeDeplMgr.getWebBindings(this._webSiteName, this._verbose);
            CommandOutputHelper.printMap(bindings, "listWebBindings", this._webSiteName, this._verbose);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("listwebbindings_error", new String[]{e.getMessage()}), e);
        }
    }
}

