/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.Iterator;
import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class GetJMSConnectionFactoriesCommand
extends AdminCommandBase {
    static final String COMMANDNAME = "-getJMSConnectionFactories";
    static final String COMMANDMENU = "-getJMSConnectionFactories";
    static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -getJMSConnectionFactories\n   - Returns a list containing a map of attibutes for each of the OC4J JMS connection factories.\n\n";

    public GetJMSConnectionFactoriesCommand(List args) throws AdminCommandException {
        super(args);
    }

    protected void doExecute() throws AdminCommandException {
        try {
            List list = this._j2eeDeplMgr.getConnectionFactories();
            if (list.isEmpty()) {
                System.out.println(" No JMS connection factories found");
            } else if (list.get(0) instanceof List) {
                System.out.println("________________________________________________");
                Iterator clusterIterator = list.iterator();
                while (clusterIterator.hasNext()) {
                    Iterator instanceIterator = ((List)clusterIterator.next()).iterator();
                    while (instanceIterator.hasNext()) {
                        System.out.println(instanceIterator.next() + "\n");
                    }
                    System.out.println("________________________________________________");
                }
            } else {
                Iterator instanceIterator = list.iterator();
                while (instanceIterator.hasNext()) {
                    System.out.println(instanceIterator.next() + "\n");
                }
            }
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("getConnectionFactories_error", new String[]{e.getMessage()}), e);
        }
    }
}

