/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class DeleteImportSharedLibraryCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-deleteImportSharedLibrary";
    public static final String COMMANDMENU = "-deleteImportSharedLibrary -appName <app> -name <name>";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -deleteImportSharedLibrary [<switch>]\n   - Deletes an existing shared library import for an application.\n\nValid switches are: \n   -appName <app>       - Required  The application's name.\n   -name <name>         - Required  The name of the shared library.\n\n";
    private String _appName;
    private String _name;

    public DeleteImportSharedLibraryCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("deleteImportSharedLibrary subcommand");
            if (command.equalsIgnoreCase("-appName")) {
                this._appName = this.getNextArgument("deployment name");
                continue;
            }
            if (command.equalsIgnoreCase("-name")) {
                this._name = this.getNextArgument("shared library name");
                continue;
            }
            String msg = FormattingResourceBundle.DeploymentMessages.getString("unknown_deleteimportsharedlibrary_switch", new String[]{command});
            throw new AdminCommandUsageException(msg, COMMANDNAME);
        }
        this.checkArgIsNull(this._appName, "-appName");
        this.checkArgIsNull(this._name, "-name");
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.deleteImportSharedLibrary(this._appName, this._name);
        }
        catch (Exception e) {
            String msg = FormattingResourceBundle.DeploymentMessages.getString("deleteimportsharedlibrary_error", new String[]{e.getMessage()});
            throw new AdminCommandException(msg, e);
        }
        System.out.println("");
        System.out.println(FormattingResourceBundle.DeploymentMessages.getString("command_successful_app_needs_restart", new String[]{"deleteImportSharedLibrary"}));
        System.out.println("");
    }
}

