/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.HashMap;
import java.util.List;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class BindAllWebAppsCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-bindAllWebApps";
    public static final String COMMANDMENU = "-bindAllWebApps -appName <appname> [options]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -bindAllWebApps [<switch>]\n   - Binds all WAR files within the EAR to the specified Web site.\n\nValid switches are:\n   -appName <appName>          - Required  The application name.\n   -webSiteName <siteName>     - Optional  The website name. If omitted, \n                                           defaults to 'default-web-site'.\n   -shared <true/false>        - Optional  Allows application to be shared\n                                           between HTTP/HTTPS, defaults to\n                                           'false'.\n   -loadOnStartup <true/false> - Optional  Allows application to be loaded\n                                           on startup, defaults to 'true'.\n   -accessLog <true/false>     - Optional  Allows application to enable access\n                                           logging, defaults to 'true'.\n\n";
    private String _appName;
    private String _siteName;
    private HashMap _optionalParams = null;

    public BindAllWebAppsCommand(List args) throws AdminCommandException {
        super(args);
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("bindAllWebApps subcommand");
            if (command.equalsIgnoreCase("-appname")) {
                this._appName = this.getNextArgument("appName");
                continue;
            }
            if (command.equalsIgnoreCase("-websitename")) {
                this._siteName = this.getNextArgument("webSiteName");
                continue;
            }
            if (command.equalsIgnoreCase("-loadOnStartup")) {
                this.putOptionalParams("loadOnStartup", this.getNextArgument("loadOnStartup"));
                continue;
            }
            if (command.equalsIgnoreCase("-accessLog")) {
                this.putOptionalParams("accessLog", this.getNextArgument("accessLog"));
                continue;
            }
            if (command.equalsIgnoreCase("-shared")) {
                this.putOptionalParams("shared", this.getNextArgument("shared"));
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_bindallwebapps_switch", new String[]{command}), COMMANDNAME);
        }
        if (this._siteName == null) {
            this._siteName = "default-web-site";
        }
        this.checkArgIsNull(this._appName, "-appName");
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.bindWebApp(this._appName, this._siteName, this._optionalParams);
        }
        catch (Exception e) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("bindallwebapps_error", new String[]{e.getMessage()}), e);
        }
    }

    private void putOptionalParams(String key, String value) {
        if (this._optionalParams == null) {
            this._optionalParams = new HashMap();
        }
        this._optionalParams.put(key, value);
    }
}

