/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import java.util.Map;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandBase;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUsageException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUtils;
import oracle.oc4j.admin.deploy.cmdline.ApplicationCommandInputValidator;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public class ApplicationRestartCommand
extends AdminCommandBase {
    public static final String COMMANDNAME = "-restartApp";
    public static final String COMMANDMENU = "-restartApp <appname> [-timeout <time in seconds>] [-graceful true|false]";
    public static final String COMMANDUSAGE = "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -restartApp <appname> [-timeout <time in seconds>] [-graceful true|false]\n\n   - Restarts the specified application and its child application(s). \n   - Timeout represents the amount of time for the application to shutdown gracefully. \n   - Once timeout is reached the application will be stopped forcefully. \n   - Set graceful to false to forcefully stop the application. By default graceful is set to true.\n\n";
    private String _appName;
    private Map _params;

    public ApplicationRestartCommand(List args) throws AdminCommandException {
        super(args);
        this._appName = AdminCommandUtils.getNextArgument(args, "application name");
        String timeout = null;
        String graceful = null;
        while (!this.isArgsEmpty()) {
            String command = this.getNextArgument("restartApp options");
            if (command.equalsIgnoreCase("-timeout")) {
                timeout = AdminCommandUtils.getNextArgument(args, " the value for the -timeout");
                continue;
            }
            if (command.equalsIgnoreCase("-graceful")) {
                graceful = AdminCommandUtils.getNextArgument(args, " the value for the -graceful");
                continue;
            }
            throw new AdminCommandUsageException(FormattingResourceBundle.DeploymentMessages.getString("unknown_restartapp_switch", new String[]{command}), COMMANDNAME);
        }
        this.validateInputs(timeout, graceful);
        this._params = ApplicationCommandInputValidator.addToParamsMap(timeout, graceful);
    }

    private void validateInputs(String timeout, String graceful) throws AdminCommandException {
        ApplicationCommandInputValidator.validateTimeout(timeout, COMMANDNAME);
        ApplicationCommandInputValidator.validateGracefulMode(graceful, COMMANDNAME);
    }

    protected void doExecute() throws AdminCommandException {
        try {
            this._j2eeDeplMgr.restartApplication(this._appName, this._params);
        }
        catch (Exception e) {
            throw new AdminCommandException(e.getMessage());
        }
    }
}

