/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.Hashtable;
import oracle.oc4j.admin.deploy.shared.util.DeploymentUtils;

public class AdminCommandUsage {
    private static Hashtable _usages = new Hashtable();

    private static void putInUsagesMap(String key, Object value) {
        _usages.put(key.toLowerCase(), value);
        _usages.put(key.replaceFirst("-", "").toLowerCase(), value);
    }

    public static String getUsage() {
        return AdminCommandUsage.getUsage("all");
    }

    public static String getUsage(String command) {
        String result = (String)_usages.get(command.toLowerCase());
        if (result == null) {
            System.err.println("\nError: Invalid -usage switch: " + command);
            System.err.println();
            result = (String)_usages.get("all");
        }
        return result;
    }

    public static boolean isExistingCommand(String command) {
        return _usages.get(command.toLowerCase()) != null;
    }

    static {
        String _allMsg = "\nUsage: \n   java -jar admin_client.jar <connection_uri> <username> <password> <command>\n\n\nValid commands are:\n -shutdown\n -restart\n\n -deploy -file <filename> -deploymentName <appname> [options]\n -redeploy -file <filename> -deploymentName <appname> [options]\n -undeploy <appname> [options]\n -bindWebApp -appName <appname> -webModuleName <name> [options]\n -unbindWebApp -appName <appname> -webModuleName <name> [options]\n -bindAllWebApps -appName <appname> [options]\n -unbindAllWebApps -appName <appname> [options]\n -start <appname>\n -stop <appname> [-timeout <time in seconds>] [-graceful true|false]\n -restartApp <appname> [-timeout <time in seconds>] [-graceful true|false]\n -listApplications [-verbose]\n -listWebBindings [-webSiteName <web-site-name>] [-verbose]\n -updateEJBModule -appName <appname> -ejbModuleName <name> -file <path>\n -listSharedLibraries\n -describeSharedLibrary -name <name> -version <version>\n -publishSharedLibrary -name <name> -version <version> [options]\n -modifySharedLibrary -name <name> -version <version> [options]\n -removeSharedLibrary -name <name> -version <version>\n -addImportSharedLibrary -appName <app> -name <name> [options]\n -deleteImportSharedLibrary -appName <app> -name <name>\n -addRemoveInheritedSharedLibrary -appName <app> -name <name>\n -deleteRemoveInheritedSharedLibrary -appName <app> -name <name>\n -validateURI\n -script <filename>\n \n -addDataSourceConnectionPool  -name <name> -factoryClass <factoryClass> \n                              -dbUser <user> -dbPassword <password> -url <url> [options]\n -removeDataSourceConnectionPool -name <name>\n -addManagedDataSource -name <name> -jndiLocation <jndiLocation> \n                          -connectionPoolName <connectionPoolName> [options]\n -removeManagedDatasource -name <dataSourceName>\n -addNativeDataSource -name <name>  -dbUser <user> -dbPassword <password> \n                         -jndiLocation <jndiLocation> -loginTimeout <loginTimeout> \n                         -dataSourceClass <dataSourceClass> -url <url> [options]\n -removeNativeDataSource -name <name>\n -testDatabaseConnection -factoryClass <factoryClass> -dbUser <dbUser> -dbPassword <dbPassword> \n                         -url <url> -sqlStatement <sqlStatement>\n -testDataSource -datasourceName <datasourceName> -sqlStatement <sqlStatement>\n -testDataSourceConnectionPool -name <name> -sqlStatement <sqlStatement> \n -getDataSourcesDescriptor\n -listDataSources\n -listDataSourceConnectionPools\n\n -addJMSConnectionFactory -domain <domain> -jndiLocation <jndiLocation> [options]\n -removeJMSConnectionFactory -jndiLocation <jndiLocation>\n -getJMSConnectionFactories\n -addDestination -domain <domain> -name <name> -jndiLocation <jndiLocation> [options]\n -removeDestination -name <name> [options]\n -getDestinations\n\n -addWebSite -webSiteName <site-name> -protocol <protocol> -port <port> [options]\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n" + "For detailed help on a particular command, use: \n" + "[java -jar admin_client.jar -usage <command>]\n\n";
        AdminCommandUsage.putInUsagesMap("-shutdown", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -shutdown\n   - Shuts the entire server down.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-restart", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -restart\n   - Restarts the entire server.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-deploy", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -deploy [<switch>]\n   - (Re)deploys an EAR, WAR, RAR or EJB JAR file. \n\nValid switches are:\n   -file <path>           - Required  The file path of the archive or\n                                      application directory to be deployed.\n   -deploymentName <name> - Required  The name to assign to the deployed \n                                      application. \n   -targetPath <path>     - Optional  The directory to deploy the archive to.\n                                      Default is the application-directory \n                                      defined in server.xml.\n   -parent <name>         - Optional  The name of the archive's parent \n                                      application. If omitted, sets the \n                                      'default' application as the parent.\n   -deploymentDirectory <path> \n                          - Optional  The directory containing the \n                                      OC4J-specific deployment descriptors\n                                      and generated files. Default is the \n                                      deployment-directory defined in \n                                      server.xml.\n   -removeArchive         - Optional  Enable removing the archive after the \n                                      application is deployed.\n   -enableIIOP            - Optional  Enable interoperability (IIOP) for the\n                                      application deployed.\n   -iiopClientJar <path>  - Optional  The client path to place the IIOP \n                                      client stubs for EJBs.\n   -nativeLibPath <path>  - Optional  Used for standalone RAR file deployment\n                                      only. The path to the native libraries\n                                      within the RAR.\n   -grantAllPermissions   - Optional  Used for standalone RAR file deployment\n                                      only. Grant all runtime permissions.\n   -contextRoot <root>    - Optional  Used for standalone WAR file deployment\n                                      only. The context root for the Web \n                                      module. If omitted, the -deploymentName\n                                      value is used.\n   -sequential [waitsec]  - Optional  Deploy the archive to each OC4J instance\n                                      within the cluster in sequence. If you\n                                      specify waitsec, admin_client waits waitsec\n                                      between deployments to the different \n                                      instances. If not included, the archive \n                                      is simultaneously deployed to all instances.\n   -bindAllWebApps [<web_site_name>]\n                          - Optional  Binds all WAR files within the EAR to\n                                      specified Web site. If omitted, modules\n                                      are bound to the 'default-web-site'.\n   -deploymentPlan <path> - Optional  Local deployment plan to config the app\n                                      when it is deployed.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-redeploy", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -redeploy [<switch>]\n   - Redeploys an application, standalone WAR or standalone RAR.\n\nValid switches are:\n   -file <path>           - Required  The file path of the archive or\n                                      application directory to be redeployed.\n   -deploymentName <name>\n                        - Required  The name to assign to the redeployed \n                                    application.\n   -removeArchive       - Optional  Enable removing the archive after the \n                                    application is redeployed.\n   -bindAllWebApps [<web_site_name>]\n                        - Optional  Binds all WAR files within the EAR to\n                                    specified Web site. If omitted, modules\n                                    are bound to the 'default-web-site'.\n                                    This option has higher priority than\n                                    -keepsettings.\n   -keepsettings        - Optional  Retain current settings the application\n                                    has on the server.\n   -sequential [waitsec]  - Optional  Deploy the archive to each OC4J instance\n                                      within the cluster in sequence. If you\n                                      specify waitsec, admin_client waits waitsec\n                                      between deployments to the different \n                                      instances. If not included, the archive \n                                      is simultaneously deployed to all instances.\n   -contextRoot <root>    - Optional  Used for standalone WAR file redeployment\n                                      only. The context root for the Web \n                                      module. If omitted, the -deploymentName\n                                      value is used.\n   -failureRecovery       - Optional  Enable recovery from a failed redeployment.\n                                      The previous archive is redeployed if possible.\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-undeploy", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -undeploy <appname> [<switch>]\n   - Undeploys an application, standalone WAR or standalone RAR.\n\nValid switches are:\n   -isConnector         - Optional  Required to undeploy a standalone RAR.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-bindWebApp", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -bindWebApp  [<switch>]\n   - Binds the specified WAR to a specified Web site and/or context root.\n\nValid switches are: \n   -appName <name>             - Required  The application name.\n   -webModuleName <name>       - Required  The Web module name.\n   -webSiteName <name>         - Optional  The website name. If omitted, \n                                           defaults to 'default-web-site'.\n   -contextRoot <contextRoot>  - Optional  Context root for the WAR file. \n                                           If omitted, the context root in \n                                           the parent application's \n                                           application.xml is used.\n   -shared <true/false>        - Optional  Allows application to be shared\n                                           between HTTP/HTTPS, defaults to\n                                           'false'.\n   -loadOnStartup <true/false> - Optional  Allows application to be loaded\n                                           on startup, defaults to 'true'.\n   -accessLog <true/false>     - Optional  Allows application to enable access\n                                           logging, defaults to 'true'.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-unbindWebApp", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -unbindWebApp  [<switch>]\n   - Unbinds a web module from web site.\n\nValid switches are: \n   -appName <name>             - Required  The application name.\n   -webModuleName <name>       - Required  The Web module name.\n   -webSiteName <name>         - Optional  The website name. If omitted, \n                                           defaults to 'default-web-site'.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-bindAllWebApps", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -bindAllWebApps [<switch>]\n   - Binds all WAR files within the EAR to the specified Web site.\n\nValid switches are:\n   -appName <appName>          - Required  The application name.\n   -webSiteName <siteName>     - Optional  The website name. If omitted, \n                                           defaults to 'default-web-site'.\n   -shared <true/false>        - Optional  Allows application to be shared\n                                           between HTTP/HTTPS, defaults to\n                                           'false'.\n   -loadOnStartup <true/false> - Optional  Allows application to be loaded\n                                           on startup, defaults to 'true'.\n   -accessLog <true/false>     - Optional  Allows application to enable access\n                                           logging, defaults to 'true'.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-unbindAllWebApps", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -unbindAllWebApps  [<switch>]\n   - Unbinds all web modules from web site.\n\nValid switches are: \n   -appName <name>             - Required  The application name.\n   -webSiteName <name>         - Optional  The website name. If omitted, \n                                           defaults to 'default-web-site'.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-start", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -start <appname>\n   - Starts the specified application and its child application(s). \n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-restartApp", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -restartApp <appname> [-timeout <time in seconds>] [-graceful true|false]\n\n   - Restarts the specified application and its child application(s). \n   - Timeout represents the amount of time for the application to shutdown gracefully. \n   - Once timeout is reached the application will be stopped forcefully. \n   - Set graceful to false to forcefully stop the application. By default graceful is set to true.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-stop", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -stop <appname> [-timeout <time in seconds>] [-graceful true|false]\n\n- Stops the specified application and its child application(s).\n- Timeout represents the amount of time for the application to shutdown gracefully. \n- Once timeout is reached the application will be stopped forcefully. \n- graceful by default is true. If set to false, application will not wait for in-flight requests to complete.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-listApplications", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -listApplications [-verbose]\n   - Displays the status of current deployed applications on OC4J instances.\n\nwhere the -verbose option is for displaying more details for applications.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-listWebBindings", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -listWebBindings [-webSiteName <web-site-name>] [-verbose]\n   - Displays web bindings for web sites in OC4J instances.\n\nValid switches are: \n   -webSiteName <web-site-name> - Optional  Web site name.\n   -verbose                     - Optional  Verbose info for web bindings.\n\n " + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-updateEJBModule", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -updateEJBModule [<switch>]\n   - Replaces an existing EJB module with a new EJB JAR in the specified\n     application.\n\nValid switches are: \n   -appName <name>             - Required  The application name.\n   -ejbModuleName <name>       - Required  The name of the EJB JAR as defined\n                                           in application.xml.\n   -file <path>                - Required  The path of the new EJB JAR.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-publishSharedLibrary", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -publishSharedLibrary [<switch>]\n   - Creates and publishes a new shared library in the OC4J instance(s).\n   - At least one code source or one import library is required.\n\nValid switches are: \n   -name <name>                    - Required  The name of the shared library.\n   -version <version>              - Required  The version of the shared library.\n   -parentName <name>              - Optional  The name of the parent library.\n   -parentVersion <version>        - Optional  The version of the parent library.\n\n   -libraryCompatible <true/false> - Optional  Whether the shared library is library compatible.\n\n   -installCodeSources <jar_file_path>...<jar_file_path_n>\n         - Optional   |   Specifies local jar/zip files to be uploaded to\n                      |   the server and added to the shared library.  For\n                      |   multiple archives, separate each jar_file_path \n                      |   with a space.\n\n   -addCodeSources <jar_file_path>...<jar_file_path_n>\n         - Optional   |   Specifies existing jar/zip files on the server to\n                      |   be added to the shared library. For multiple\n                      |   archives, separate each jar_file_path with a space.\n\n   -imports <shared_library>...<shared_library_n>\n         - Optional   |   Shared libraries to be imported into this library.\n                      |   For multiple imports, separate each shared_library\n                      |   with a space.\n                      |   \n                      |   <shared_library> must be of format \n                      |        <library name>[:[min-version][,max-version]]\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-describeSharedLibrary", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -describeSharedLibrary [<switch>]\n   - Lists all of the code sources and imports of the specified shared library.\n\nValid switches are: \n   -name <name>         - Required  The name of the shared library.\n   -version <version>   - Required  The version of the shared library.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-listSharedLibraries", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -listSharedLibraries\n   - Lists all of the shared libraries in the OC4J instance(s).\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-modifySharedLibrary", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -modifySharedLibrary [<switch>]\n   - Modifies an existing shared library in the OC4J instance(s).\n\nValid switches are: \n   -name <name>         - Required  The name of the shared library.\n   -version <version>   - Required  The version of the shared library.\n\n   -libraryCompatible <true/false> - Optional  Whether the shared library is library compatible.\n\n   -installCodeSources <jar_file_path>...<jar_file_path_n>\n         - Optional   |   Specifies local jar/zip files to be uploaded to\n                      |   the server and added to the shared library.  For\n                      |   multiple archives, separate each jar_file_path\n                      |   with a space.\n\n   -addCodeSources <jar_file_path>...<jar_file_path_n>\n         - Optional   |   Specifies existing jar/zip files on the server to\n                      |   be added to the shared library. For multiple\n                      |   archives, separate each jar_file_path with a space.\n\n   -removeCodeSources <jar_file_path>...<jar_file_path_n>\n         - Optional   |   Code sources to be removed from the library.  For\n                      |   multiple code sources, separate each jar_file_path\n                      |   with a space.\n\n   -addImports <shared_library>...<shared_library_n>\n         - Optional   |   Shared libraries to be imported into this library.\n                      |   For multiple imports, separate each shared_library\n                      |   with a space.\n                      |   \n                      |   <shared_library> must be of format \n                      |        <library name>[:[min-version][,max-version]]\n\n   -removeImports <shared_library_name>...<shared_library_name_n>\n         - Optional   |   Names of shared library imports to be removed from\n                      |   this library. For multiple imports, separate each\n                      |   shared_library_name with a space.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-removeSharedLibrary", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -removeSharedLibrary [<switch>]\n   - Removes an existing shared library in the OC4J instance.\n\nValid switches are: \n   -name <name>         - Required  The name of the shared library.\n   -version <version>   - Required  The version of the shared library.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-addImportSharedLibrary", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addImportSharedLibrary [<switch>]\n   - Adds an existing shared library import to an application.\n\nValid switches are: \n   -appName <app>       - Required  The application's name.\n   -name <name>         - Required  The name of the shared library.\n   -minVer <minVersion> - Optional  Minimum version number required by an application.\n   -maxVer <maxVersion> - Optional  Maximum version number required by an application.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-deleteImportSharedLibrary", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -deleteImportSharedLibrary [<switch>]\n   - Deletes an existing shared library import for an application.\n\nValid switches are: \n   -appName <app>       - Required  The application's name.\n   -name <name>         - Required  The name of the shared library.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-addRemoveInheritedSharedLibrary", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addRemoveInheritedSharedLibrary [<switch>]\n   - Add a <remove-inherited> shared library element for this application.\n\nValid switches are: \n   -appName <app>       - Required  The application's name.\n   -name <name>         - Required  The name of the remove-inherited shared library element.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-deleteRemoveInheritedSharedLibrary", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -deleteRemoveInheritedSharedLibrary [<switch>]\n   - Delete a <remove-inherited> shared library element from this application.\n\nValid switches are: \n   -appName <app>       - Required  The application's name.\n   -name <name>         - Required  The name of the remove-inherited shared library element.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-validateURI", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -validateURI\n   - Validates the connection uri.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-script", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -script <filename>\n   - Runs multiple commands specified by the user via a script file.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-addDataSourceConnectionPool".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addDataSourceConnectionPool\n   - Add a JDBC Connection Pool.\n\nValid switches are: \n   -applicationName <applicationName>                        - Required  The name of the application to deploy to.\n   -name <name>                                              - Required  The connection pool name.\n   -factoryClass <factoryClass>                              - Required  The fully qualified path of the conection factory implementation.\n   -dbUser <user>                                            - Required  The default user to use to get connections.\n   -dbPassword <password>                                    - Required  The default passwor to use to get connections.\n   -url <url>                                                - Required  The connection factory url to get connections.\n   -factoryProperties <name1> <value1> <name2> <value2> [..] - Optional  Property(ies) to set on the connection factory definition.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-removeDataSourceConnectionPool".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -removeDataSourceConnectionPool\n   - Remove a JDBC Connection Pool.\n\nValid switches are: \n   -name <name>                                        - Required  The connection pool name.\n   -applicationName <applicationName>                  - Optional  The name of the application to deploy to.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-addManagedDatasource".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addManagedDataSource\n   - Add a new Managed Data Source.\n\nValid switches are: \n   -applicationName <applicationName>                  - Required  The name of the application to deploy the datasource to.\n   -name <name>                                        - Required  The name of the new data source.\n   -jndiLocation <jndiLocation>                        - Required  The location to use to bind the new data source into JNDI.\n   -connectionPoolName <connectionPoolName>            - Required  The name of the connection pool with which the data source interacts.\n   -dbUser <dbUser>                                    - Optional  The default user for the new data source.\n   -dbPassword <dbPassword>                            - Optional  The default password for the new data source.\n   -loginTimeout <loginTimeout>                        - Optional  The login timeout for the new data source.\n   -txLevel <txLevel>                                  - Optional  The transaction level ('local' or 'global').\n   -dbSchema <dbSchema>                                - Optional  The db schema to use if the EJB CMP implementation being used is Orion CMP (TopLink CMP is the default.).\n   -manageLocalTransactions <manageLocalTransactions>  - Optional  Indicates whether or not OC4J should manage local transactions. Default value is true.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-removeManagedDatasource".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -removeManagedDataSource\n   - Remove a Managed Data Source.\n\nValid switches are: \n   -name <name>                                        - Required  The name of the data source to remove.\n   -applicationName <applicationName>                  - Optional  The name of the application to remove the datasource from .\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-addNativeDataSource".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addNativeDataSource\n   - Add a new Native Data Source.\n\nValid switches are: \n   -name <name>                                        - Required  The name of the new data source.\n   -dbUser <dbUser>                                    - Required  The default user for the new data source.\n   -dbPassword <dbPassword>                            - Required  The default password for the new data source.\n   -jndiLocation <jndiLocation>                        - Required  The location to use to bind the new data source into JNDI.\n   -loginTimeout <loginTimeout>                        - Required  The login timeout for the new data source.\n   -dataSourceClass <dataSourceClass>                  - Required  The fully-pathed class of the new data source.\n   -url <url>                                          - Required  The url used by the new data source to connect to the database.\n   -applicationName <applicationName>                  - Optional  The name of the application.\n   -properties <name1> <value1> <name2> <value2> [...] - Optional  The properties for the new data source.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-removeNativeDataSource".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -removeNativeDataSource \n   - Remove a Native Data Source.\n\nValid switches are: \n   -name <name>                                        - Required  The name of the data source to remove.\n   -applicationName <applicationName>                  - Optional  The name of the application.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-testDatabaseConnection".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -testDatabaseConnection\n   - Test a JDBC connection.\n\nValid switches are: \n   -sqlStatement <sqlStatement>                        - Required  The sql statement to use to test the connection.\n   -factoryClass <factoryClass>                        - Required  The JDBC factory to test (instance of Driver, DataSource, ConnectionPoolDataSource, or XADataSource.\n   -dbUser <user>                                      - Required  The user to use.\n   -dbPassword <password>                              - Required  The password to use.\n   -url <url>                                          - Required  The URL to set on the JDBC factory.\n   -applicationName <applicationName>                  - Optional  The name of the application.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-testDataSource".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -testDataSource\n   - Test a datasource connection.\n\nValid switches are: \n   -datasourceName <datasourceName>                    - Required  The datasource to test.\n   -sqlStatement <sqlStatement>                        - Required  The sql statement to use to test the connection.\n   -applicationName <applicationName>                  - Optional  The name of the application.\n   -dbUser <dbUser>                                    - Optional  The user to use.\n   -dbPassword <dbPassword>                            - Optional  The password to use.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-testDataSourceConnectionPool".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -testDataSourceConnectionPool\n   - Test a datasource connection pool connection.\n\nValid switches are: \n   -name <name>                                        - Required  The name of the connection pool.\n   -sqlStatement <sqlStatement>                        - Required  The sql statement to use to test the connection.\n   -applicationName <applicationName>                  - Optional  The name of the application.\n   -dbUser <user>                                      - Optional  The user to use.\n   -dbPassword <password>                              - Optional  The password to use.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-getDataSourcesDescriptor".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -getDataSourcesDescriptor\n   - Get the application's data sources as data-sources.xml.\n\nValid switches are: \n   -applicationName <applicationName>                        - Optional  The name of the application the descriptor belongs to.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-listDataSources".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -listDataSources\n   - List the application's data sources.\n\nValid switches are: \n   -applicationName <applicationName>                        - Optional  The name of the application for which to list the data sources.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-listDataSourceConnectionPools".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -listDataSourceConnectionPools\n   - List the application's data source connection pools.\n\nValid switches are: \n   -applicationName <applicationName>                        - Optional  The name of the application for which to list the data sources.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-addJMSConnectionFactory".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addJMSConnectionFactory\n   - Create a new OC4J JMS connection factory.\n\nValid switches are: \n   -domain <domain>                                    - Required  JMS domain of this connection factory (`QUEUE', `TOPIC', or `UNIFIED').\n   -jndiLocation <jndiLocation>                        - Required  JNDI location this connection factory will be bound to.\n   -host <host>                                        - Optional  The host name associated with this connection factory. (defaults to the containing OC4J JMS server host).\n   -port <port>                                        - Optional  The port number associated with this connection factory. (defaults to the containing OC4J JMS server port).\n   -username <username>                                - Optional  The user name associated with this connection factory. (defaults to the anonymous user).\n   -password <password>                                - Optional  The password associated with this connection factory. (defaults to null).\n   -clientID <clientID>                                - Optional  The JMS client ID associated with this connection factory. (defaults to null).\n   -isXA <isXA>                                        - Optional  Is this connection factory of an XA-flavor? (defaults to false).\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-removeJMSConnectionFactory".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -removeJMSConnectionFactory\n   - Delete an existing OC4J JMS connection factory.\n\nValid switches are: \n   -jndiLocation <jndiLocation>                            - Required  The JNDI location of the connection factory to remove.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-getJMSConnectionFactories".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -getJMSConnectionFactories\n   - Returns a list containing a map of attibutes for each of the OC4J JMS connection factories.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-addDestination".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addDestination\n   - Create a new OC4J JMS destination.\n\nValid switches are: \n   -domain <domain>                                    - Required  JMS domain of this destination (`QUEUE' or `TOPIC').\n   -name <name>                                        - Required  The OC4J JMS provider-specific name of the destination.\n   -jndiLocation <jndiLocation>                        - Required  JNDI location this destination will be bound to.\n   -persistenceFile <persistenceFile>                  - Optional  The persistence-file associated with this destination. (defaults to null)\n   -description <description>                          - Optional  A textual description of this destination. (defaults to null).\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-removeDestination".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -removeDestination\n   - Delete an existing OC4J JMS destination.\n\nValid switches are: \n   -name <name>                                        - Required  The OC4J JMS provider-specific name of the destination to remove.\n   -force <force>                                      - Optional  Remove regardless of whether messages or consumers exist on the destination. (defaults to false).\n   -removePFile <removePFile>                          - Optional  Remove the persistence file from the filesystem. (defaults to false).\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-getDestinations".toLowerCase(), "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -getDestinations\n   - Returns a list containing a map of attibutes for each of the OC4J JMS destinations.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        AdminCommandUsage.putInUsagesMap("-addWebSite", "\nUsage:\njava -jar admin_client.jar <connection_uri> <username> <password> -addWebSite [<switch>]\n   - Add a new web site.\n\nValid switches are: \n  -webSiteName <site-name>     -Required The name of the new web site.\n  -protocol <protocol>         -Required The protocol of the new web site.\n  -port <port>                 -Required The port number of the web site.\n  -keystorePath <path>         -Optional filename including path of the keystore file.\n  -keystorePassword <password> -Optional password of the keystore file.\n  -sslProvider <class-name>    -Optional the third-party SSLServerSocketFactory\n                                         implementation if not use default.\n\n" + DeploymentUtils.getValidURIMsg() + "\n\n");
        _usages.put("all", _allMsg);
    }
}

