/*
 * Decompiled with CFR 0.152.
 */
package oracle.oc4j.admin.deploy.cmdline;

import java.util.List;
import oracle.oc4j.admin.deploy.api.J2EEDeploymentException;
import oracle.oc4j.admin.deploy.api.J2EEDeploymentManager;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandException;
import oracle.oc4j.admin.deploy.cmdline.AdminCommandUtils;
import oracle.oc4j.admin.deploy.shared.util.FormattingResourceBundle;

public abstract class AdminCommandBase {
    protected J2EEDeploymentManager _j2eeDeplMgr;
    private List _args;

    public AdminCommandBase(List args) throws AdminCommandException {
        this._args = args;
    }

    public void execute(String url, String usr, String pwd) throws AdminCommandException {
        try {
            this._j2eeDeplMgr = new J2EEDeploymentManager(url, usr, pwd);
        }
        catch (J2EEDeploymentException je) {
            throw new AdminCommandException(je.getMessage());
        }
        try {
            this.doExecute();
            Object var6_6 = null;
            if (this._j2eeDeplMgr != null) {
                this._j2eeDeplMgr.release();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (this._j2eeDeplMgr != null) {
                this._j2eeDeplMgr.release();
            }
            throw throwable;
        }
    }

    public void execute(J2EEDeploymentManager deplMgr) throws AdminCommandException {
        this._j2eeDeplMgr = deplMgr;
        this.doExecute();
    }

    protected abstract void doExecute() throws AdminCommandException;

    protected boolean isArgsEmpty() {
        return this._args.isEmpty();
    }

    protected String getNextArgument(String description) throws AdminCommandException {
        return AdminCommandUtils.getNextArgument(this._args, description);
    }

    protected String readNextArgument() {
        return AdminCommandUtils.readNextArgument(this._args);
    }

    protected void checkArgIsNull(String arg, String option) throws AdminCommandException {
        if (arg == null) {
            throw new AdminCommandException(FormattingResourceBundle.DeploymentMessages.getString("not_specified", new String[]{option}));
        }
    }
}

