/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockManager;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.ExecutionContext;
import oracle.dms.instrument.InstrumentationException;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.PhaseEventIntf;
import oracle.dms.instrument.Sensor;
import oracle.dms.instrument.Tracer;
import oracle.dms.instrument.TransTrace;
import oracle.dms.spy.ErrorObject;
import oracle.dms.spy.Metric;
import oracle.dms.util.DMSUtil;

public class PhaseEvent
extends Sensor
implements PhaseEventIntf {
    private long _duration = 0L;
    private long _exclTime = 0L;
    private int _active = 0;
    private int _maxActive = 0;
    private int _updateCount = 0;
    private long _min = Long.MAX_VALUE;
    private long _max = Long.MIN_VALUE;
    private static Clock _clock = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhaseEvent create(Noun noun, String string, String string2) {
        if (noun == null || string2 == null || string == null) {
            throw new InstrumentationException("PhaseEvent.create(): bad parameters");
        }
        PhaseEvent phaseEvent = (PhaseEvent)noun.getSensor(string);
        if (phaseEvent != null) {
            return phaseEvent;
        }
        String string3 = DMSUtil.sanitize(string, 511, true, true);
        Noun noun2 = noun;
        synchronized (noun2) {
            phaseEvent = (PhaseEvent)noun.getSensor(string3);
            if (phaseEvent != null) {
                return phaseEvent;
            }
            return new PhaseEvent(false, noun, string3, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PhaseEvent create(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new InstrumentationException("PhaseEvent.create(): bad parameters");
        }
        PhaseEvent phaseEvent = (PhaseEvent)Sensor.lookupCache(string);
        if (phaseEvent != null) {
            return phaseEvent;
        }
        Noun noun = Sensor.createParent(string);
        String string3 = DMSUtil.getLeafFromPath(string);
        Noun noun2 = noun;
        synchronized (noun2) {
            String string4 = DMSUtil.sanitize(string3, 511, true, true);
            phaseEvent = (PhaseEvent)noun.getSensor(string4);
            if (phaseEvent != null) {
                phaseEvent.addToCache(string);
                return phaseEvent;
            }
            return new PhaseEvent(false, noun, string4, string2);
        }
    }

    public static PhaseEvent create(String string, String string2, int n) {
        PhaseEvent phaseEvent = PhaseEvent.create(string, string2);
        phaseEvent.deriveMetric(n);
        return phaseEvent;
    }

    public PhaseEvent(Noun noun, String string, String string2) {
        this(true, noun, string, string2);
    }

    private PhaseEvent(boolean bl, Noun noun, String string, String string2) {
        super(bl, noun, string, string2);
        this._metrics[0] = new Metric(this._name + ".time", this._description, ClockManager.getUnits(DMSConsole.UNITS), this, false, 2, 0);
        this.setUpdateTime(0L);
        if (_clock == null) {
            _clock = DMSConsole.getClock();
        }
    }

    public synchronized void deriveMetric(int n) {
        if (!this._alive) {
            return;
        }
        String string = ClockManager.getUnits(DMSConsole.UNITS);
        boolean bl = false;
        if ((n & 2) > 0 && this._metrics[1] == null) {
            this._metrics[1] = new Metric(this._name + ".completed", this._description, "ops", this, false, 3, 1);
            bl = true;
        }
        if ((n & 8) > 0 && this._metrics[3] == null) {
            this._metrics[3] = new Metric(this._name + ".maxTime", this._description, string, this, false, 2, 3);
            bl = true;
        }
        if ((n & 4) > 0 && this._metrics[2] == null) {
            this._metrics[2] = new Metric(this._name + ".minTime", this._description, string, this, false, 2, 2);
            bl = true;
        }
        if ((n & 0x20) > 0 && this._metrics[5] == null) {
            this._metrics[5] = new Metric(this._name + ".avg", this._description, string, this, false, 1, 5);
            bl = true;
        }
        if ((n & 0x40) > 0 && this._metrics[6] == null) {
            this._metrics[6] = new Metric(this._name + ".active", this._description, "threads", this, false, 3, 6);
            bl = true;
        }
        if ((n & 0x80) > 0 && this._metrics[7] == null) {
            this._metrics[7] = new Metric(this._name + ".maxActive", this._description, "threads", this, false, 3, 7);
            bl = true;
        }
        if (TransTrace._isEnabled() && (n & 0x100) > 0 && this._metrics[8] == null) {
            this._metrics[8] = new Metric(this._name + ".exclTime", this._description, "msecs", this, false, 2, 8);
            bl = true;
        }
        if (bl) {
            this.setUpdateTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(Metric metric) {
        if (metric == null) {
            throw new InstrumentationException("Metric: " + metric + " does not belong to PhaseEvent " + this);
        }
        if (!metric.isAlive()) {
            return new ErrorObject();
        }
        byte by = metric.getIndex();
        if (this._metrics[by] != metric) {
            throw new InstrumentationException("Metric: " + metric + " does not belong to PhaseEvent " + this);
        }
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            if (!this._alive) {
                return new ErrorObject();
            }
            switch (by) {
                case 1: {
                    return new Integer(this._updateCount);
                }
                case 2: {
                    if (this._min == Long.MAX_VALUE) {
                        return new Long(0L);
                    }
                    return new Long(_clock.convertTime(this._min, DMSConsole.UNITS));
                }
                case 3: {
                    if (this._max == Long.MIN_VALUE) {
                        return new Long(0L);
                    }
                    return new Long(_clock.convertTime(this._max, DMSConsole.UNITS));
                }
                case 0: {
                    return new Long(_clock.convertTime(this._duration, DMSConsole.UNITS));
                }
                case 5: {
                    long l = _clock.convertTime(this._duration, DMSConsole.UNITS);
                    return new Double(this._updateCount != 0 && l != 0L ? (double)l / (double)this._updateCount : 0.0);
                }
                case 6: {
                    return new Integer(this._active);
                }
                case 7: {
                    return new Integer(this._maxActive);
                }
                case 8: {
                    this._exclTime = this._duration;
                    return new Long(this._exclTime);
                }
            }
        }
        throw new InstrumentationException("Metric: " + metric + " does not belong to PhaseEvent " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long start() {
        Tracer tracer;
        if (this.isTraceable() && (tracer = ExecutionContext.get().getTracer()) != null) {
            tracer.append((Sensor)this, 1);
        }
        if (this.isLoggable()) {
            this.logActivation("Start");
        }
        long l = _clock.getTime();
        long l2 = _clock.convertTime(l, 1000L);
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            ++this._active;
            if (this._active > this._maxActive) {
                this._maxActive = this._active;
            }
            if (this._lastUpdate < l2) {
                this._lastUpdate = l2;
            }
        }
        return l;
    }

    public static long start(String string) {
        return ((PhaseEvent)Sensor.get(string)).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(long l) {
        long l2 = _clock.convertTime(l, 1000L);
        Sensor sensor = this;
        synchronized (sensor) {
            ++this._active;
            if (this._active > this._maxActive) {
                this._maxActive = this._active;
            }
            if (this._lastUpdate < l2) {
                this._lastUpdate = l2;
            }
        }
        if (this.isTraceable() && (sensor = ExecutionContext.get().getTracer()) != null) {
            ((Tracer)sensor).append(this, 1);
        }
        if (this.isLoggable()) {
            this.logActivation("Start");
        }
    }

    public static void stop(String string, long l) {
        ((PhaseEvent)Sensor.get(string)).stop(l);
    }

    public void stop(long l) {
        this.stop2(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long stop2(long l) {
        long l2 = _clock.getTime();
        long l3 = l2 - l;
        if (l3 < 0L) {
            l3 = 0L;
            l2 = l;
        }
        long l4 = _clock.convertTime(l2, 1000L);
        Object object = this;
        synchronized (object) {
            this._duration += l3;
            if (this._max < l3) {
                this._max = l3;
            }
            if (this._min > l3) {
                this._min = l3;
            }
            --this._active;
            ++this._updateCount;
            if (this._lastUpdate < l4) {
                this._lastUpdate = l4;
            }
        }
        if (this.isTraceable() && (object = ExecutionContext.get().getTracer()) != null) {
            ((Tracer)object).append((Sensor)this, 2);
        }
        if (this.isLoggable()) {
            object = new StringBuffer("Stop: [");
            ((StringBuffer)object).append(l);
            ((StringBuffer)object).append(", ");
            ((StringBuffer)object).append(l2);
            ((StringBuffer)object).append(", ");
            ((StringBuffer)object).append(this._updateCount);
            ((StringBuffer)object).append(" ops, ");
            ((StringBuffer)object).append(this._duration);
            ((StringBuffer)object).append(" " + _clock.getUnits() + "]");
            this.logActivation(((StringBuffer)object).toString());
        }
        return l2;
    }

    public long stopElapsed(long l) {
        long l2 = this.stop2(l);
        return l2 - l;
    }

    public static void stop(String string, long l, long l2) {
        ((PhaseEvent)Sensor.get(string)).stop(l, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(long l, long l2) {
        long l3;
        long l4 = l2 - l;
        if (l4 < 0L) {
            l4 = 0L;
            l3 = _clock.convertTime(l, 1000L);
        } else {
            l3 = _clock.convertTime(l2, 1000L);
        }
        Object object = this;
        synchronized (object) {
            this._duration += l4;
            if (this._max < l4) {
                this._max = l4;
            }
            if (this._min > l4) {
                this._min = l4;
            }
            --this._active;
            ++this._updateCount;
            if (this._lastUpdate < l3) {
                this._lastUpdate = l3;
            }
        }
        if (this.isTraceable() && (object = ExecutionContext.get().getTracer()) != null) {
            ((Tracer)object).append((Sensor)this, 2);
        }
        if (this.isLoggable()) {
            object = new StringBuffer("Stop: [");
            ((StringBuffer)object).append(l);
            ((StringBuffer)object).append(", ");
            ((StringBuffer)object).append(l2);
            ((StringBuffer)object).append(", ");
            ((StringBuffer)object).append(this._updateCount);
            ((StringBuffer)object).append(" ops, ");
            ((StringBuffer)object).append(this._duration);
            ((StringBuffer)object).append(" msecs]");
            this.logActivation(((StringBuffer)object).toString());
        }
    }

    public static void abort(String string, long l) {
        ((PhaseEvent)Sensor.get(string)).abort(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(long l) {
        long l2 = System.currentTimeMillis();
        Sensor sensor = this;
        synchronized (sensor) {
            --this._active;
            this.setUpdateTime(l2);
        }
        if (this.isTraceable() && (sensor = ExecutionContext.get().getTracer()) != null) {
            ((Tracer)sensor).append(this, 3);
        }
        if (this.isLoggable()) {
            this.logActivation("Abort");
        }
    }

    public static long getToken() {
        return _clock.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        long l = System.currentTimeMillis();
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            this._duration = 0L;
            this._updateCount = 0;
            this._min = Long.MAX_VALUE;
            this._max = Long.MIN_VALUE;
            this._maxActive = this._active;
            this.setUpdateTime(l);
            this.setResetTime(l);
        }
    }

    PhaseEvent getCousin(Noun noun) {
        PhaseEvent phaseEvent = null;
        Noun noun2 = this.getParent().getCousin(noun);
        if (noun2 != null) {
            phaseEvent = PhaseEvent.create(noun2, this._name, "cousin");
            int n = 0;
            n |= 1;
            n |= 2;
            if (this._metrics[3] != null) {
                n |= 8;
            }
            if (this._metrics[2] != null) {
                n |= 4;
            }
            if (this._metrics[8] != null) {
                n |= 0x100;
            }
            phaseEvent.deriveMetric(n);
        }
        return phaseEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addExclTime(long l) {
        long l2 = System.currentTimeMillis();
        PhaseEvent phaseEvent = this;
        synchronized (phaseEvent) {
            this._exclTime += l;
            this.setUpdateTime(l2);
        }
    }

    public boolean isInitialized() {
        return this._updateCount > 0 || this._active > 0;
    }

    static synchronized void shutdown() {
        _clock = null;
    }
}

