/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.http;

import java.util.StringTokenizer;
import oracle.core.ojdl.LogMessage;
import oracle.dms.util.DMSUtil;

public abstract class Request {
    public static final String OPERATION = "operation";
    public static final String NAME = "name";
    public static final String NOUNTYPE = "nountype";
    public static final String TABLE = "table";
    public static final String VALUE = "value";
    public static final String UNITS = "units";
    public static final String DESCRIPTION = "description";
    public static final String RECURSE = "recurse";
    public static final String FORMAT = "format";
    public static final String NEW_VALUE = "newvalue";
    public static final String ORDERBY = "orderby";
    public static final String ADDRESS = "address";
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String RESET = "reset";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String XML = "xml";
    public static final String PDML = "pdml";
    public static final String TBML = "tbml";
    public static final String HTML = "html";
    public static final String RAW = "raw";
    public static final String TARGET_META_DATA = "targetmetadata";
    public static final String METRIC_TABLE = "metrictable";
    public static final String METRIC_LIST = "metriclist";
    public static final String METRIC_HELP = "metrichelp";
    public static final String TRANSTRACE = "transtrace";
    public static final String SPY_TABLE = "spytable";
    public static final String SPY = "spy";
    public static final String CHILDREN = "children";
    public static final String ALL = "all";
    public static final String NONE = "none";
    protected String m_userPasswd = null;
    protected LogMessage.InstanceId m_instanceId = null;
    protected boolean m_setInstId = false;
    protected String[] m_names = null;
    protected String[] m_tables = null;
    protected Boolean m_includeUnit = null;
    protected Boolean m_includeValue = null;
    protected Boolean m_includeDescription = null;
    protected String m_newValue = null;
    protected String m_orderBy = null;
    protected String m_format = null;
    protected String m_operation = null;
    protected String m_includeDescendents = null;
    protected String m_requestURL = null;

    public abstract String getMethod();

    public abstract String getHeader(String var1);

    public abstract String getParameter(String var1);

    public abstract String[] getParameterValues(String var1);

    public abstract String getServerName();

    public abstract int getServerPort();

    public abstract String getRequestedSessionId();

    public abstract String getRequestURI();

    public String[] getNames() {
        if (this.m_names != null) {
            return this.m_names;
        }
        this.m_names = this.getParameterValues(NAME);
        if (this.m_names == null) {
            return this.m_names;
        }
        for (int i = 0; i < this.m_names.length; ++i) {
            if (this.m_names[i] == null) continue;
            this.m_names[i] = DMSUtil.xssEscape(this.m_names[i]);
        }
        return this.m_names;
    }

    public String[] getTables() {
        if (this.m_tables != null) {
            return this.m_tables;
        }
        this.m_tables = this.getParameterValues(TABLE);
        if (this.m_tables == null) {
            this.m_tables = this.getParameterValues(NOUNTYPE);
        }
        if (this.m_tables == null) {
            return this.m_tables;
        }
        for (int i = 0; i < this.m_tables.length; ++i) {
            if (this.m_tables[i] == null) continue;
            this.m_tables[i] = DMSUtil.xssEscape(this.m_tables[i]);
        }
        return this.m_tables;
    }

    public boolean includeUnits() {
        if (this.m_includeUnit != null) {
            return this.m_includeUnit;
        }
        String string = this.getParameter(UNITS);
        boolean bl = TRUE.equalsIgnoreCase(string);
        this.m_includeUnit = new Boolean(bl);
        return bl;
    }

    public boolean includeValues() {
        if (this.m_includeValue != null) {
            return this.m_includeValue;
        }
        String string = this.getParameter(VALUE);
        boolean bl = !FALSE.equalsIgnoreCase(string);
        this.m_includeValue = new Boolean(bl);
        return bl;
    }

    public boolean includeDescription() {
        if (this.m_includeDescription != null) {
            return this.m_includeDescription;
        }
        String string = this.getParameter(DESCRIPTION);
        boolean bl = TRUE.equalsIgnoreCase(string);
        this.m_includeDescription = new Boolean(bl);
        return bl;
    }

    public String getNewValue() {
        if (this.m_newValue != null) {
            return this.m_newValue;
        }
        this.m_newValue = this.getParameter(NEW_VALUE);
        if (this.m_newValue == null) {
            this.m_newValue = "";
        }
        return this.m_newValue;
    }

    public String getOrderBy() {
        if (this.m_orderBy != null) {
            return this.m_orderBy;
        }
        this.m_orderBy = this.getParameter(ORDERBY);
        if (this.m_orderBy == null) {
            this.m_orderBy = "";
        }
        this.m_orderBy = DMSUtil.xssEscape(this.m_orderBy);
        return this.m_orderBy;
    }

    public String getBasicAuthorization() {
        if (this.m_userPasswd != null) {
            return this.m_userPasswd;
        }
        String string = this.getHeader("authorization");
        if (string == null) {
            this.m_userPasswd = "";
            return this.m_userPasswd;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = null;
        if (stringTokenizer.hasMoreTokens()) {
            if (!"basic".equalsIgnoreCase(stringTokenizer.nextToken())) {
                this.m_userPasswd = "";
                return this.m_userPasswd;
            }
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
        }
        this.m_userPasswd = string2 == null ? "" : string2;
        return this.m_userPasswd;
    }

    public LogMessage.InstanceId getInstanceID() {
        if (this.m_instanceId != null) {
            return this.m_instanceId;
        }
        if (this.m_setInstId) {
            return null;
        }
        this.m_setInstId = true;
        String string = this.getHeader("oracle-ecid");
        if (string == null) {
            return null;
        }
        int n = string.indexOf(44);
        if (n > 0) {
            int n2;
            String string2 = string.substring(0, n);
            try {
                n2 = Integer.parseInt(string.substring(n + 2));
            }
            catch (Exception exception) {
                n2 = -1;
            }
            if (n2 >= 0) {
                this.m_instanceId = new LogMessage.InstanceId(string2, n2 + 1);
                return this.m_instanceId;
            }
        }
        return null;
    }

    public boolean isFormat(String string) {
        if (string == null) {
            return false;
        }
        if (this.m_format == null) {
            this.m_format = this.getParameter(FORMAT);
            if (this.m_format == null) {
                this.m_format = "";
            }
        }
        return string.equalsIgnoreCase(this.m_format);
    }

    public boolean isOperation(String string) {
        if (string == null) {
            return false;
        }
        if (this.m_operation == null) {
            this.m_operation = this.getParameter(OPERATION);
            if (this.m_operation == null) {
                this.m_operation = "";
            }
        }
        return string.equalsIgnoreCase(this.m_operation);
    }

    public boolean includeDescendents(String string) {
        if (string == null) {
            return false;
        }
        if (this.m_includeDescendents == null) {
            this.m_includeDescendents = this.getParameter(RECURSE);
            if (this.m_includeDescendents == null) {
                this.m_includeDescendents = "";
            }
        }
        return string.equalsIgnoreCase(this.m_includeDescendents);
    }

    public String getRequestURL() {
        if (this.m_requestURL != null) {
            return this.m_requestURL;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getServerName());
        int n = this.getServerPort();
        if (n != 80 && n != 0) {
            stringBuffer.append(':');
            stringBuffer.append(n);
        }
        stringBuffer.append(this.getRequestURI());
        this.m_requestURL = stringBuffer.toString();
        return this.m_requestURL;
    }
}

