/*
 * Decompiled with CFR 0.152.
 */
package oracle.core.ojdl;

import java.util.Date;
import java.util.Map;
import oracle.core.ojdl.DateFormat;
import oracle.core.ojdl.LogFormatter;
import oracle.core.ojdl.LogManager;
import oracle.core.ojdl.LogMessage;
import oracle.core.ojdl.util.XMLUtil;

public class XMLFormatter
implements LogFormatter {
    private static final String LSEP = System.getProperty("line.separator");
    private static final String TAB = "  ";
    private static final String TAB2 = "    ";
    private static final String TAB3 = "      ";
    private boolean m_escapeChars = true;
    private boolean m_useHeadAndTail = false;
    private DateFormat m_dateFmt = new DateFormat();
    private Date m_date = new Date(0L);

    public XMLFormatter(boolean bl) {
        String string = LogManager.getLogManager().getProperty("XMLFormatter.escapeChars", "true");
        this.m_escapeChars = string.equals("true");
        this.m_useHeadAndTail = bl;
    }

    public XMLFormatter() {
        this(false);
    }

    public String format(LogMessage logMessage) {
        Object object;
        Object object2;
        Map map;
        StringBuffer stringBuffer = new StringBuffer(2000);
        stringBuffer.append("<MESSAGE>");
        stringBuffer.append(LSEP);
        stringBuffer.append(TAB);
        stringBuffer.append("<HEADER>");
        stringBuffer.append(LSEP);
        stringBuffer.append(TAB2);
        stringBuffer.append("<TSTZ_ORIGINATING>");
        this.m_date.setTime(logMessage.getTimestamp());
        this.m_dateFmt.format(this.m_date, stringBuffer);
        stringBuffer.append("</TSTZ_ORIGINATING>");
        stringBuffer.append(LSEP);
        if (logMessage.getOrganizationId() != null) {
            stringBuffer.append("    <ORG_ID>" + logMessage.getOrganizationId() + "</ORG_ID>" + LSEP);
        }
        if (logMessage.getComponentId() != null) {
            stringBuffer.append("    <COMPONENT_ID>" + logMessage.getComponentId() + "</COMPONENT_ID>" + LSEP);
        } else {
            stringBuffer.append("    <COMPONENT_ID>null</COMPONENT_ID>" + LSEP);
        }
        if (logMessage.getInstanceId() != null) {
            stringBuffer.append("    <INSTANCE_ID>" + logMessage.getInstanceId() + "</INSTANCE_ID>" + LSEP);
        }
        if (logMessage.getMessageId() != null) {
            stringBuffer.append("    <MSG_ID>" + logMessage.getMessageId() + "</MSG_ID>" + LSEP);
        }
        if (logMessage.getHostingClientId() != null) {
            stringBuffer.append("    <HOSTING_CLIENT_ID>" + logMessage.getHostingClientId() + "</HOSTING_CLIENT_ID>" + LSEP);
        }
        if (logMessage.getMessageType() != null) {
            stringBuffer.append("    <MSG_TYPE TYPE=\"" + logMessage.getMessageType().toString() + "\"></MSG_TYPE>" + LSEP);
        } else {
            stringBuffer.append("    <MSG_TYPE TYPE=\"UNKNOWN\"></MSG_TYPE>" + LSEP);
        }
        if (logMessage.getMessageGroup() != null) {
            stringBuffer.append("    <MSG_GROUP>" + logMessage.getMessageGroup() + "</MSG_GROUP>" + LSEP);
        }
        stringBuffer.append("    <MSG_LEVEL>" + logMessage.getMessageLevel() + "</MSG_LEVEL>" + LSEP);
        if (logMessage.getHostId() != null) {
            stringBuffer.append("    <HOST_ID>" + logMessage.getHostId() + "</HOST_ID>" + LSEP);
        }
        if (logMessage.getHostNwAddr() != null) {
            stringBuffer.append("    <HOST_NWADDR>" + logMessage.getHostNwAddr() + "</HOST_NWADDR>" + LSEP);
        }
        if (logMessage.getModuleId() != null) {
            stringBuffer.append("    <MODULE_ID>" + logMessage.getModuleId() + "</MODULE_ID>" + LSEP);
        }
        if (logMessage.getProcessId() != null) {
            stringBuffer.append("    <PROCESS_ID>" + logMessage.getProcessId() + "</PROCESS_ID>" + LSEP);
        }
        if (logMessage.getThreadId() != null) {
            stringBuffer.append("    <THREAD_ID>" + logMessage.getThreadId() + "</THREAD_ID>" + LSEP);
        }
        if (logMessage.getUserId() != null) {
            stringBuffer.append("    <USER_ID>" + logMessage.getUserId() + "</USER_ID>" + LSEP);
        }
        if ((map = logMessage.getSupplAttrs()) != null && !map.isEmpty()) {
            stringBuffer.append("    <SUPPL_ATTRS>" + LSEP);
            object2 = map.keySet().iterator();
            while (object2.hasNext()) {
                object = (LogMessage.MessageArgument[])object2.next();
                stringBuffer.append("      <ATTR NAME=\"" + (String)object + "\">");
                Object v = map.get(object);
                if (v != null) {
                    stringBuffer.append(v.toString());
                }
                stringBuffer.append("</ATTR>" + LSEP);
            }
            stringBuffer.append("    </SUPPL_ATTRS>" + LSEP);
        }
        stringBuffer.append("  </HEADER>" + LSEP);
        if (logMessage.getUpstreamCompId() != null || logMessage.getDownstreamCompId() != null || logMessage.getExecContextId() != null || logMessage.getErrorInstanceId() != null) {
            stringBuffer.append("  <CORRELATION_DATA>" + LSEP);
            if (logMessage.getUpstreamCompId() != null) {
                stringBuffer.append("    <UPSTREAM_COMPONENT_ID>" + logMessage.getUpstreamCompId() + "</UPSTREAM_COMPONENT_ID>" + LSEP);
            }
            if (logMessage.getDownstreamCompId() != null) {
                stringBuffer.append("    <DOWNSTREAM_COMPONENT_ID>" + logMessage.getDownstreamCompId() + "</DOWNSTREAM_COMPONENT_ID>" + LSEP);
            }
            if (logMessage.getExecContextId() != null) {
                stringBuffer.append("    <EXEC_CONTEXT_ID><UNIQUE_ID>" + logMessage.getExecContextId().getUniqueId() + "</UNIQUE_ID><SEQ>" + logMessage.getExecContextId().getSequenceNumber() + "</SEQ></EXEC_CONTEXT_ID>" + LSEP);
            }
            if (logMessage.getErrorInstanceId() != null) {
                stringBuffer.append("    <EID><UNIQUE_ID>" + logMessage.getErrorInstanceId().getUniqueId() + "</UNIQUE_ID><SEQ>" + logMessage.getErrorInstanceId().getSequenceNumber() + "</SEQ></EID>" + LSEP);
            }
            stringBuffer.append("  </CORRELATION_DATA>" + LSEP);
        }
        stringBuffer.append("  <PAYLOAD>" + LSEP);
        object2 = logMessage.getMessageText();
        stringBuffer.append("    <MSG_TEXT>");
        if (this.m_escapeChars) {
            XMLUtil.escapeXMLchars((String)object2, stringBuffer);
        } else {
            stringBuffer.append((String)object2);
        }
        stringBuffer.append("</MSG_TEXT>" + LSEP);
        if (logMessage.getMessageArgs() != null) {
            object = logMessage.getMessageArgs();
            for (int i = 0; i < ((LogMessage.MessageArgument[])object).length; ++i) {
                stringBuffer.append("    <MSG_ARGS>" + LSEP);
                if (((LogMessage.MessageArgument)object[i]).getName() != null) {
                    stringBuffer.append("      <NAME>" + ((LogMessage.MessageArgument)object[i]).getName() + "</NAME>" + LSEP);
                }
                stringBuffer.append("      <VALUE>" + ((LogMessage.MessageArgument)object[i]).getValue() + "</VALUE>" + LSEP);
                stringBuffer.append("    </MSG_ARGS>" + LSEP);
            }
        }
        if (logMessage.getDetailLocation() != null) {
            stringBuffer.append("    <DETAIL_PATH>" + logMessage.getDetailLocation() + "</DETAIL_PATH>" + LSEP);
        }
        if ((object = logMessage.getSupplDetail()) != null) {
            stringBuffer.append("    <SUPPL_DETAIL>");
            if (((String)object).indexOf("]]>") < 0) {
                stringBuffer.append("<![CDATA[");
                stringBuffer.append((String)object);
                stringBuffer.append("]]>");
            } else if (this.m_escapeChars) {
                XMLUtil.escapeXMLchars((String)object, stringBuffer);
            } else {
                stringBuffer.append((String)object);
            }
            stringBuffer.append("</SUPPL_DETAIL>" + LSEP);
        }
        stringBuffer.append("  </PAYLOAD>" + LSEP + "</MESSAGE>" + LSEP);
        return stringBuffer.toString();
    }

    public String header() {
        if (this.m_useHeadAndTail) {
            return "<?xml version='1.0'?>" + LSEP + "<LOG>" + LSEP;
        }
        return "";
    }

    public String tail() {
        if (this.m_useHeadAndTail) {
            return "</LOG>" + LSEP;
        }
        return "";
    }
}

