/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm.util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UrlParamMaskHelper {
    private static int options = 10;
    private static Pattern URLParamsPattern = Pattern.compile("(?:\\?|&|;)([^=]+)=([^&|;]+)", 2);
    private static Pattern staticResourcePattern = Pattern.compile("(.*/)?(.*).(css|js|tiff|gif|png|ico|bmp|jpg|jpeg|webp|svg|svgz)$", options);
    private static Pattern tidyUriMatcherPattern = Pattern.compile("\\d+", options);

    public static String maskURLParams(String string) {
        Matcher matcher = URLParamsPattern.matcher(string);
        StringBuilder stringBuilder = new StringBuilder().append("");
        int n = 0;
        if (matcher.find()) {
            stringBuilder.append(string.substring(0, matcher.start() + 1));
            stringBuilder.append(matcher.group(1));
            stringBuilder.append("=?");
            n = matcher.end();
        }
        while (matcher.find()) {
            stringBuilder.append(matcher.group().split("=")[0]);
            stringBuilder.append("=?");
            n = matcher.end();
        }
        stringBuilder.append(string.substring(n));
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return string;
    }

    public static String normalizeURI(String string) {
        Object object;
        Matcher matcher;
        if ("/".equals(string)) {
            return string;
        }
        if (string.startsWith("/")) {
            string = string.substring(string.indexOf(47) + 1);
        }
        if ((matcher = staticResourcePattern.matcher(string)).matches()) {
            object = new StringBuilder();
            ((StringBuilder)object).append(matcher.group(1).trim()).append("*.").append(matcher.group(3));
            string = ((StringBuilder)object).toString();
        }
        object = tidyUriMatcherPattern.matcher(string);
        string = ((Matcher)object).replaceAll("*");
        return string;
    }

    public static String normalizeAndMaskURL(String string) {
        return UrlParamMaskHelper.maskURLParams(UrlParamMaskHelper.normalizeURI(string));
    }

    public static void main(String[] stringArray) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader("D:\\Backup\\SpringBootWebstore\\WebStore-UI\\d-sqlparser\\urlList.txt"));
            String string = bufferedReader.readLine();
            while (string != null) {
                System.out.println(" Masked URL   = " + UrlParamMaskHelper.maskURLParams(string));
                string = bufferedReader.readLine();
                System.out.println("----------------------------------------------------------------------------------------------------");
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

