/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.AgentStartupLogger;
import com.eg.apm.NodeClientSocketHandler;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;

public final class NodeClientSocketListener
implements Runnable {
    private ServerSocket serverSocket;
    private static final String logPrefix = " [" + NodeClientSocketListener.class.getName() + "] ";
    private ArrayList handlerList = new ArrayList();

    public NodeClientSocketListener(ServerSocket serverSocket) {
        try {
            this.serverSocket = serverSocket;
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Unable to initialize ClientSocketListener object ", (Object)logPrefix, (Object)e);
        }
    }

    public void run() {
        Socket clientSocket = null;
        boolean acceptClientConnection = true;
        while (acceptClientConnection) {
            try {
                if (this.serverSocket.isClosed()) {
                    AgentStartupLogger.logger.warn("{} NodeJS Server socket is closed :{} ", (Object)logPrefix, (Object)this.serverSocket.isClosed());
                    acceptClientConnection = false;
                }
                if ((clientSocket = this.serverSocket.accept()) == null) continue;
                clientSocket.setTcpNoDelay(true);
                clientSocket.setKeepAlive(true);
                NodeClientSocketHandler socketHandler = new NodeClientSocketHandler(clientSocket);
                Thread socketHandlerThread = new Thread(socketHandler);
                socketHandlerThread.setName("ClientSocketHandler");
                socketHandlerThread.setDaemon(true);
                socketHandlerThread.start();
                this.handlerList.add(socketHandler);
            }
            catch (SocketTimeoutException ste) {
                System.err.println("Client socket connection has been timedout " + ste.getMessage());
                AgentStartupLogger.logger.error("{} Client socket connection has been timedout {} ", (Object)logPrefix, (Object)ste);
                this.closeClientSocket(clientSocket);
                acceptClientConnection = false;
            }
            catch (IOException ioe) {
                System.err.println("IO Exception while waiting for client socket connection " + ioe.getMessage());
                AgentStartupLogger.logger.error("{} IO Exception while waiting for client socket connection {}", (Object)logPrefix, (Object)ioe);
                this.closeClientSocket(clientSocket);
                acceptClientConnection = false;
            }
            catch (SecurityException se) {
                System.err.println("Security Manager settings not allowing to accept client socket connection " + se.getMessage());
                AgentStartupLogger.logger.error("{} Security Manager settings not allowing to accept client socket connection {}", (Object)logPrefix, (Object)se);
                this.closeClientSocket(clientSocket);
                acceptClientConnection = false;
            }
            catch (Exception e) {
                System.err.println("Unable to get client socket connection ... " + e.getMessage());
                AgentStartupLogger.logger.error("{} Unable to get client socket connection ... {}", (Object)logPrefix, (Object)e);
                this.closeClientSocket(clientSocket);
                acceptClientConnection = false;
            }
        }
        if (!acceptClientConnection) {
            this.closeAllClientHandlers();
        }
    }

    private void closeAllClientHandlers() {
        if (this.handlerList != null && this.handlerList.size() > 0) {
            AgentStartupLogger.logger.info("{}  Closing all Client Socket Handler ", (Object)logPrefix);
            int len = this.handlerList.size();
            AgentStartupLogger.logger.info("{} Current handlerList size : {} , {} ", new Object[]{logPrefix, len, this.handlerList});
            int i = 0;
            while (i < len) {
                NodeClientSocketHandler handler = (NodeClientSocketHandler)this.handlerList.get(i);
                handler.setRunThis(false);
                ++i;
            }
        }
        this.handlerList = new ArrayList();
    }

    private void closeClientSocket(Socket clientSocket) {
        if (clientSocket != null) {
            try {
                if (!clientSocket.isClosed()) {
                    clientSocket.close();
                    clientSocket = null;
                }
            }
            catch (IOException ioe) {
                AgentStartupLogger.logger.error("{} Exception while closing the client socket {} , {}", new Object[]{logPrefix, clientSocket.toString(), ioe});
            }
        }
    }

    private void sleepMethod(long sleeptime) {
        try {
            Thread.sleep(sleeptime);
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Unable to sleep: {}", (Object)logPrefix, (Object)e);
        }
    }
}

