/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgSSL;
import com.eg.MyHostnameVerifier;
import com.eg.MyX509TrustManager;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.ApmDemoInfo;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class KubernetesAPI {
    private boolean isSsl = false;
    private String serviceToken = "";
    private String ip = "";
    private int kuberPortNo = 443;
    String isKuberSslBased = "";
    private static final String logPrefix = "[KubernetesAPI] ";
    HashMap servicData = new HashMap();
    private static boolean isContainerClusterMasterReachable = true;

    public KubernetesAPI(String string, int n, String string2, boolean bl) {
        this.ip = string;
        this.kuberPortNo = n;
        this.serviceToken = string2;
        this.isSsl = bl;
        this.init();
    }

    private void init() {
        if (this.isSsl) {
            this.isKuberSslBased = "https";
            this.installSSL();
        } else {
            this.isKuberSslBased = "http";
        }
    }

    public void installSSL() {
        try {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var3_4 = null;
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing installSSL() : {}", (Object)logPrefix, (Object)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeCommands(String string) {
        String string2;
        block13: {
            string2 = "";
            try {
                HttpResponse httpResponse = null;
                CloseableHttpClient closeableHttpClient = null;
                HttpGet httpGet = null;
                HttpHost httpHost = null;
                String string3 = this.ip;
                if (string3 == null) return string2;
                if (string3.trim().length() == 0) {
                    return string2;
                }
                try {
                    httpHost = new HttpHost(string3, this.kuberPortNo, this.isKuberSslBased);
                    HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
                    Object object = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                        public boolean isTrusted(X509Certificate[] x509CertificateArray, String string) {
                            return true;
                        }
                    }).build();
                    httpClientBuilder.setSslcontext((SSLContext)object);
                    Object object2 = SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER;
                    Object object3 = new SSLConnectionSocketFactory((SSLContext)object, (X509HostnameVerifier)object2);
                    Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", object3).build();
                    PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager(registry);
                    httpClientBuilder.setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager);
                    RequestConfig.Builder builder = RequestConfig.custom();
                    int n = 2000;
                    builder.setConnectTimeout(n);
                    builder.setConnectionRequestTimeout(n);
                    builder.setSocketTimeout(n);
                    httpClientBuilder.setDefaultRequestConfig(builder.build());
                    closeableHttpClient = httpClientBuilder.build();
                    httpGet = new HttpGet(string);
                    httpGet.setHeader("Authorization", "Bearer " + this.serviceToken);
                    httpResponse = closeableHttpClient.execute(httpHost, (HttpRequest)httpGet);
                    if (string != null && string.trim().length() > 0 && string.indexOf("namespaces") > -1) {
                        int n2 = httpResponse.getStatusLine().getStatusCode();
                    }
                    if ((httpClientBuilder = httpResponse.getEntity()) == null) break block13;
                    object = httpClientBuilder.getContent();
                    object2 = null;
                    try {
                        try {
                            object2 = new BufferedReader(new InputStreamReader((InputStream)object));
                            object3 = "";
                            while ((object3 = ((BufferedReader)object2).readLine()) != null) {
                                object3 = ((String)object3).trim();
                                string2 = string2 + "" + (String)object3;
                            }
                            Object var17_22 = null;
                        }
                        catch (IOException iOException) {
                            throw iOException;
                        }
                        catch (RuntimeException runtimeException) {
                            httpGet.abort();
                            throw runtimeException;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var17_23 = null;
                        ((BufferedReader)object2).close();
                        ((InputStream)object).close();
                        closeableHttpClient.getConnectionManager().shutdown();
                        throw throwable;
                    }
                    ((BufferedReader)object2).close();
                    ((InputStream)object).close();
                    closeableHttpClient.getConnectionManager().shutdown();
                }
                catch (Exception exception) {
                    isContainerClusterMasterReachable = false;
                    APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing executeCommands() : {}", (Object)logPrefix, (Object)exception);
                }
            }
            catch (Exception exception) {
                String string4 = "You are not giving correct Ip address for Kubernetes. Please give correct Ip address..";
                APMDiscoveryLogger.discoveryLogger.warn("{} {} : ", new Object[]{logPrefix, string4, exception});
                isContainerClusterMasterReachable = false;
            }
        }
        if (string2 != null) {
            if (string2.trim().length() != 0) return string2.trim();
        }
        string2 = "";
        return string2.trim();
    }

    public boolean isKubeMasterReachable() {
        return isContainerClusterMasterReachable;
    }

    public ArrayList getJsonPathsValue(String string, String string2) {
        Configuration configuration = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).build();
        ArrayList arrayList = null;
        if (string != null && string.length() > 4) {
            try {
                arrayList = (ArrayList)JsonPath.using((Configuration)configuration).parse(string).read(string2, new Predicate[0]);
            }
            catch (PathNotFoundException pathNotFoundException) {
                APMDiscoveryLogger.discoveryLogger.debug("{} No path found : {}", (Object)logPrefix, (Object)string2);
                return arrayList;
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get JSON paths from JSON Data {}:{}", new Object[]{logPrefix, exception.getMessage(), exception.getCause()});
                return arrayList;
            }
        }
        return arrayList;
    }

    public Object getJsonValue(String string, String string2) {
        Object object = null;
        if (string != null && string.length() > 4) {
            try {
                object = JsonPath.read((String)string, (String)string2, (Predicate[])new Predicate[0]);
                object.toString();
            }
            catch (PathNotFoundException pathNotFoundException) {
                APMDiscoveryLogger.discoveryLogger.debug("{} No path found : {}", (Object)logPrefix, (Object)string2);
                return object;
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to get JSON paths[{}] from JSON Data {}:{}", new Object[]{logPrefix, string2, exception.getMessage(), exception.getCause()});
                return object;
            }
        }
        return object;
    }

    public String getServicename(String string, String string2) {
        String string3 = null;
        try {
            String string4 = "/api/v1/namespaces/" + string + "/services";
            String string5 = this.executeCommands(string4);
            APMDiscoveryLogger.discoveryLogger.trace("{}  serviceCmd : {}", (Object)logPrefix, (Object)string4);
            APMDiscoveryLogger.discoveryLogger.trace("{}  serviceCmdOutputs : {}", (Object)logPrefix, (Object)string5);
            ArrayList arrayList = this.getJsonPathsValue(string5, "$.items[*]");
            APMDiscoveryLogger.discoveryLogger.trace("{}  paths : {}", (Object)logPrefix, (Object)arrayList);
            HashMap hashMap = this.processServiceApiData(string, arrayList, string5);
            this.servicData.put(string, hashMap);
            APMDiscoveryLogger.discoveryLogger.trace("{}  tempserviceData : {}", (Object)logPrefix, (Object)hashMap);
            string3 = (String)hashMap.get(string2);
            APMDiscoveryLogger.discoveryLogger.trace("{}  labelKeyValue : {} , servicename : {}", new Object[]{logPrefix, string2, string3});
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing getServicename() : {}", (Object)logPrefix, (Object)exception);
        }
        return string3;
    }

    public HashMap getCachedServiceCopy(String string) {
        return (HashMap)this.servicData.get(string);
    }

    private HashMap processServiceApiData(String string, ArrayList arrayList, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (arrayList != null && arrayList.size() > 0) {
            try {
                for (int i = 0; i < arrayList.size(); ++i) {
                    try {
                        LinkedHashMap linkedHashMap;
                        String string3 = (String)arrayList.get(i);
                        String string4 = (String)this.getJsonValue(string2, string3 + "['metadata']['name']");
                        if (string4 == null || string4.length() <= 0 || (linkedHashMap = (LinkedHashMap)this.getJsonValue(string2, string3 + "['spec']['selector']")) == null) continue;
                        for (String string5 : linkedHashMap.keySet()) {
                            String string6 = (String)linkedHashMap.get(string5);
                            hashMap.put(string5 + ":" + string6, string4);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing processServiceApiData() : {}", (Object)logPrefix, (Object)exception);
                    }
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing processServiceApiData() : {}", (Object)logPrefix, (Object)exception);
            }
        }
        return hashMap;
    }

    public ArrayList getLabelNameFromPod(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string3 = "/api/v1/namespaces/" + string + "/pods/" + string2;
            String string4 = this.executeCommands(string3);
            Object object = this.getJsonValue(string4, "$.metadata.labels");
            APMDiscoveryLogger.discoveryLogger.trace("{}  podCommand : {}", (Object)logPrefix, (Object)string3);
            APMDiscoveryLogger.discoveryLogger.trace("{}  podCmdOutputs : {}", (Object)logPrefix, (Object)string4);
            APMDiscoveryLogger.discoveryLogger.trace("{}  value : {}", (Object)logPrefix, object);
            if (object != null && object instanceof LinkedHashMap) {
                LinkedHashMap linkedHashMap = (LinkedHashMap)object;
                for (String string5 : linkedHashMap.keySet()) {
                    String string6 = (String)linkedHashMap.get(string5);
                    arrayList.add(string5 + ":" + string6);
                }
                APMDiscoveryLogger.discoveryLogger.trace("{}  Map : {}", (Object)logPrefix, linkedHashMap.keySet());
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while processing getLabelNameFromPod() : {}", (Object)logPrefix, (Object)exception);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        String string = "/api/v1/namespaces";
        String string2 = "eyJhbGciOiJSUzI1NiIsImtpZCI6InhqTkpuZkpRcFphcmRIYVgtNFUya2x0RWZnVy1uMFJHcW5XVkJmY2ZPWDQifQ.eyJpc3MiOiJrdWJlcm5ldGVzL3NlcnZpY2VhY2NvdW50Iiwia3ViZXJuZXRlcy5pby9zZXJ2aWNlYWNjb3VudC9uYW1lc3BhY2UiOiJkZWZhdWx0Iiwia3ViZXJuZXRlcy5pby9zZXJ2aWNlYWNjb3VudC9zZWNyZXQubmFtZSI6ImVnaW5ub3ZhdGlvbnMtdG9rZW4tc3ZneHAiLCJrdWJlcm5ldGVzLmlvL3NlcnZpY2VhY2NvdW50L3NlcnZpY2UtYWNjb3VudC5uYW1lIjoiZWdpbm5vdmF0aW9ucyIsImt1YmVybmV0ZXMuaW8vc2VydmljZWFjY291bnQvc2VydmljZS1hY2NvdW50LnVpZCI6ImFjYjdmOWQwLTVhMjgtNDdlMy1iMWVlLWFiN2M0ZjQzNWZkYSIsInN1YiI6InN5c3RlbTpzZXJ2aWNlYWNjb3VudDpkZWZhdWx0OmVnaW5ub3ZhdGlvbnMifQ.b72ktuNCuGG6JmxT3BOBwGf3q23BFlgFdXrW5GHDVEJ1mCON932UwK1CCM8g2C9XWSEIZjmeh6KVwKkttTRj3kKaEv3Di_nBdyCUmFZfXsbVm1UuENUhVMNNZpc46OQZJzdNwnjnvkt3XHrLl4ETBPyCZGUKfx7feBU_5ODtb6iYtzAiIGoI8k0rE73kcIuhxahoPXoAS72BSsk3EUF92sdLMI_9ht-WH1AlOKvbz3ddYr5DRPnTjuDV_pFFsL4OtzqnvuC8_QsLSW7jSSFKKSQsw0NJFZ7G2AmHE0YmCseGX6WkI_y7q11nX4Zf7YKTqs2ERyrKZljEV3S_MPj7Hg";
        ApmDemoInfo apmDemoInfo = new ApmDemoInfo(false);
        KubernetesAPI kubernetesAPI = new KubernetesAPI("192.168.11.43", 6443, string2, true);
        System.out.println("Demo " + apmDemoInfo.isDemoMode());
        String string3 = "/api/v1/namespaces/default/services";
        long l = System.currentTimeMillis();
        String string4 = kubernetesAPI.executeCommands(string3);
        System.out.println("\n\n serviceCmdOutputs:- " + string4.length());
        System.out.println("Diff " + (System.currentTimeMillis() - l));
    }
}

