/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.EgLog;
import com.eg.org.slf4j.Logger;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class EgLogbackManager {
    private static final EgLogbackManager instance = new EgLogbackManager();
    private static final ConcurrentHashMap<String, EgLog> LOGGER_TABLE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Object> SYNC_TABLE = new ConcurrentHashMap();

    private EgLogbackManager() {
    }

    public static EgLogbackManager getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger getLogger(String loggerName) {
        if (LOGGER_TABLE.containsKey(loggerName)) {
            return LOGGER_TABLE.get(loggerName).getLogger();
        }
        Object object = null;
        if (SYNC_TABLE.contains(loggerName)) {
            object = SYNC_TABLE.get(loggerName);
        } else {
            object = new Object();
            SYNC_TABLE.put(loggerName, object);
        }
        Object object2 = object;
        synchronized (object2) {
            EgLog egLog = new EgLog(loggerName);
            LOGGER_TABLE.put(loggerName, egLog);
        }
        return LOGGER_TABLE.get(loggerName).getLogger();
    }

    public void updateConfig(Properties currentProperties) {
        Set keys = LOGGER_TABLE.keySet();
        for (String keyString : keys) {
            EgLog egLog = LOGGER_TABLE.get(keyString);
            egLog.checkForUpdate(currentProperties);
        }
    }
}

