/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.apm.EgLogbackConfig;
import com.eg.apm.EgLogbackProperties;
import com.eg.ch.qos.logback.classic.AsyncAppender;
import com.eg.ch.qos.logback.classic.Level;
import com.eg.ch.qos.logback.classic.Logger;
import com.eg.ch.qos.logback.classic.LoggerContext;
import com.eg.ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import com.eg.ch.qos.logback.core.Appender;
import com.eg.ch.qos.logback.core.Context;
import com.eg.ch.qos.logback.core.FileAppender;
import com.eg.ch.qos.logback.core.encoder.Encoder;
import com.eg.ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import com.eg.ch.qos.logback.core.rolling.RollingFileAppender;
import com.eg.ch.qos.logback.core.rolling.RollingPolicy;
import com.eg.ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import com.eg.ch.qos.logback.core.rolling.TriggeringPolicy;
import com.eg.ch.qos.logback.core.util.FileSize;
import com.eg.org.slf4j.LoggerFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Properties;

public class EgLog {
    private com.eg.org.slf4j.Logger logger;
    private String loggerName;
    private volatile boolean initialized = false;
    private String prefix;
    private final String[] configArray = new String[5];
    private static final String[] LOGGER_SUFFIX = new String[]{".logger.name", ".logger.level", ".logger.max.files", ".logger.file.size", ".logger.file.name"};
    private EgLogbackConfig loggerConfig;
    private AsyncAppender asyncAppender;
    private static HashMap<String, Level> MAPPING = new HashMap();

    static {
        MAPPING.put("all", Level.ALL);
        MAPPING.put("off", Level.OFF);
        MAPPING.put("info", Level.INFO);
        MAPPING.put("warn", Level.WARN);
        MAPPING.put("debug", Level.DEBUG);
        MAPPING.put("trace", Level.TRACE);
        MAPPING.put("error", Level.ERROR);
    }

    public EgLog(String loggerName) {
        this.loggerName = loggerName;
        this.logger = LoggerFactory.getLogger((String)this.loggerName);
        this.loggerConfig = new EgLogbackConfig();
        if (loggerName != null) {
            int underscore = loggerName.indexOf("_");
            this.prefix = underscore > 0 ? loggerName.substring(0, underscore).toLowerCase() : loggerName.toLowerCase();
            this.initLogger();
        }
    }

    private void initLogger() {
        Properties properties = EgLogbackProperties.getInstance().getProperties();
        System.out.println("Properties :" + properties);
        this.initLogProperties(properties);
    }

    public com.eg.org.slf4j.Logger getLogger() {
        return this.logger;
    }

    public void checkForUpdate(Properties currentProperties) {
        String currentLevel = currentProperties.getProperty(String.valueOf(this.prefix) + LOGGER_SUFFIX[1]);
        if (currentLevel != null) {
            this.checkLogLevelForUpdate(currentLevel);
        }
        boolean changeExists = false;
        String currentMaxFiles = currentProperties.getProperty(String.valueOf(this.prefix) + LOGGER_SUFFIX[2]);
        int maxFileCount = this.loggerConfig.getLogFileMaxCount();
        if (currentMaxFiles != null && !currentMaxFiles.equals(this.configArray[2])) {
            changeExists = true;
            maxFileCount = this.getFileCount(currentMaxFiles);
        }
        String currentFileSize = currentProperties.getProperty(String.valueOf(this.prefix) + LOGGER_SUFFIX[3]);
        int maxFileSize = this.loggerConfig.getLogFileLimit();
        if (currentFileSize != null && !currentFileSize.equals(this.configArray[3])) {
            changeExists = true;
            maxFileSize = this.getFileSize(currentFileSize);
        }
        String currentFileName = currentProperties.getProperty(String.valueOf(this.prefix) + LOGGER_SUFFIX[4]);
        String fileName = this.loggerConfig.getLogFileName();
        if (currentFileName != null && !currentFileName.equals(this.configArray[4]) && currentFileName.trim().length() > 0) {
            changeExists = true;
            fileName = currentFileName.trim();
        }
        if (changeExists) {
            this.initialized = false;
            this.initLogProperties(maxFileCount, maxFileSize, fileName);
        }
    }

    private void checkLogLevelForUpdate(String currentLevel) {
        if (!currentLevel.equals(this.configArray[1])) {
            Level level = MAPPING.get(currentLevel.toLowerCase());
            if (level != null) {
                this.updateNewLogbackLevel(level);
            } else {
                this.updateNewLogbackLevel(Level.WARN);
            }
        }
    }

    private boolean isLoggerExistsOnFile(Properties logProps) {
        String keyString = String.valueOf(this.prefix) + LOGGER_SUFFIX[0];
        String valueString = logProps.getProperty(keyString);
        if (valueString != null && valueString.equals(this.loggerName)) {
            this.configArray[0] = valueString;
            int i = 0;
            while (i < LOGGER_SUFFIX.length) {
                this.configArray[i] = logProps.getProperty(String.valueOf(this.prefix) + LOGGER_SUFFIX[i]);
                ++i;
            }
            return true;
        }
        return false;
    }

    private void initLogProperties(int logFileCount, int logFileSize, String logFileName) {
        this.loggerConfig.setLogFileName(logFileName);
        this.loggerConfig.setLogFileMaxCount(logFileCount);
        this.loggerConfig.setLogFileLimit(logFileSize);
        this.start();
    }

    private void initLogProperties(Properties logProps) {
        try {
            if (this.isLoggerExistsOnFile(logProps)) {
                String logLevel = logProps.getProperty(String.valueOf(this.prefix) + LOGGER_SUFFIX[1]);
                String logFileCount = logProps.getProperty(String.valueOf(this.prefix) + LOGGER_SUFFIX[2]);
                String logFileSize = logProps.getProperty(String.valueOf(this.prefix) + LOGGER_SUFFIX[3]);
                String logFileName = logProps.getProperty(String.valueOf(this.prefix) + LOGGER_SUFFIX[4]);
                Level level = MAPPING.get(logLevel.toLowerCase());
                this.loggerConfig.setLogLevel(level);
                if (logFileName != null && logFileName.trim().length() > 0) {
                    this.loggerConfig.setLogFileName(logFileName);
                } else {
                    this.loggerConfig.setLogFileName(String.valueOf(this.prefix) + ".log");
                }
                int count = this.getFileCount(logFileCount);
                this.loggerConfig.setLogFileMaxCount(count);
                int limit = this.getFileSize(logFileSize);
                this.loggerConfig.setLogFileLimit(limit);
            } else {
                System.out.println("[EgLog:initLogProperties] - Logger -" + this.loggerName + "- proceeds with default logging properties ");
                this.setDefaultLogging();
            }
        }
        catch (Exception e) {
            System.out.println("[EgLog:initLogProperties] - Logger -" + this.loggerName + "- proceeds with default logging properties ");
            e.printStackTrace();
            this.setDefaultLogging();
        }
        this.start();
    }

    public void setDefaultLogging() {
        this.loggerConfig.setLogLevel(Level.WARN);
        this.loggerConfig.setLogFileLimit(3);
        this.loggerConfig.setLogFileMaxCount(3);
        this.loggerConfig.setLogFileName(String.valueOf(this.prefix) + ".log");
    }

    private void initEGLogger() {
        if (!this.initialized) {
            String egHome = EgInstallInfo.getInstallDir();
            System.out.println("[EgLog] - eG Home Folder :" + egHome);
            if (egHome == null || egHome.trim().length() == 0) {
                return;
            }
            String agentLogDir = String.valueOf(egHome) + File.separator + "agent" + File.separator + "logs";
            String filePath = String.valueOf(agentLogDir) + File.separator + this.loggerConfig.getLogFileName();
            LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
            RollingFileAppender egRollingFileAppender = new RollingFileAppender();
            egRollingFileAppender.setContext((Context)loggerContext);
            egRollingFileAppender.setFile(filePath);
            FixedWindowRollingPolicy fwRollingPolicy = new FixedWindowRollingPolicy();
            fwRollingPolicy.setContext((Context)loggerContext);
            fwRollingPolicy.setFileNamePattern(String.valueOf(agentLogDir) + File.separator + this.loggerConfig.getLogFileName() + "-%i.log");
            fwRollingPolicy.setMinIndex(1);
            fwRollingPolicy.setMaxIndex(this.loggerConfig.getLogFileMaxCount());
            fwRollingPolicy.setParent((FileAppender)egRollingFileAppender);
            fwRollingPolicy.start();
            SizeBasedTriggeringPolicy triggeringPolicy = new SizeBasedTriggeringPolicy();
            FileSize fileSize = FileSize.valueOf((String)(String.valueOf(this.loggerConfig.getLogFileLimit()) + "MB"));
            triggeringPolicy.setMaxFileSize(fileSize);
            triggeringPolicy.start();
            PatternLayoutEncoder encoder = new PatternLayoutEncoder();
            encoder.setContext((Context)loggerContext);
            encoder.setPattern("%date %-5level - %msg%n");
            encoder.start();
            egRollingFileAppender.setEncoder((Encoder)encoder);
            egRollingFileAppender.setRollingPolicy((RollingPolicy)fwRollingPolicy);
            egRollingFileAppender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
            egRollingFileAppender.setLazy(true);
            egRollingFileAppender.start();
            this.asyncAppender = new AsyncAppender();
            this.asyncAppender.setContext((Context)loggerContext);
            this.asyncAppender.setName(this.prefix);
            this.asyncAppender.addAppender((Appender)egRollingFileAppender);
            this.asyncAppender.setDiscardingThreshold(this.loggerConfig.getDiscardThresholdLimit());
            this.asyncAppender.setQueueSize(this.loggerConfig.getAsyncQueueSize());
            this.asyncAppender.start();
            Logger logbackLogger = loggerContext.getLogger(this.loggerName);
            logbackLogger.addAppender((Appender)this.asyncAppender);
            logbackLogger.setLevel(this.loggerConfig.getLogLevel());
            logbackLogger.setAdditive(true);
            this.initialized = true;
        }
    }

    private void start() {
        this.stop();
        this.initEGLogger();
    }

    private void stop() {
        if (this.asyncAppender != null && this.asyncAppender.isStarted()) {
            this.asyncAppender.stop();
        }
    }

    private void updateNewLogbackLevel(Level level) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Logger logbackLogger = loggerContext.getLogger(this.loggerName);
        this.loggerConfig.setLogLevel(level);
        logbackLogger.setLevel(this.loggerConfig.getLogLevel());
        this.logger.debug("{} Log Level is  : {} ", (Object)this.loggerName, (Object)level.toString());
    }

    private int getFileCount(String maxCount) {
        int max = 3;
        if (maxCount != null && maxCount.trim().length() > 0) {
            try {
                int count = Integer.parseInt(maxCount);
                if (count > 0) {
                    max = count;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return max;
    }

    private int getFileSize(String limit) {
        int size = 3;
        if (limit != null && limit.trim().length() > 0) {
            try {
                int count = Integer.parseInt(limit);
                if (count > 0) {
                    size = count;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return size;
    }
}

